/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.schematics.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.foundation.utility.outliner.AABBOutline;
import com.simibubi.create.foundation.utility.render.StructureRenderer;
import com.simibubi.create.modules.schematics.SchematicWorld;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class SchematicRenderer {
    private final RegionRenderCacheBuilder bufferCache = new RegionRenderCacheBuilder();
    private final boolean[] usedBlockRenderLayers = new boolean[BlockRenderLayer.values().length];
    private final boolean[] startedBufferBuilders = new boolean[BlockRenderLayer.values().length];
    private boolean active;
    private boolean changed = false;
    private SchematicWorld schematic;
    private AABBOutline outline;
    private BlockPos anchor;

    public void startHologram(SchematicWorld world) {
        this.anchor = world.anchor;
        this.schematic = world;
        this.active = true;
        this.changed = true;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void update() {
        this.changed = true;
    }

    public void tick() {
        if (!this.active) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || !this.changed) {
            return;
        }
        this.redraw(mc);
        this.changed = false;
    }

    public void render() {
        if (!this.active) {
            return;
        }
        GlStateManager.disableCull();
        GlStateManager.enableAlphaTest();
        GlStateManager.depthMask((boolean)true);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
        for (int blockRenderLayerId = 0; blockRenderLayerId < this.usedBlockRenderLayers.length; ++blockRenderLayerId) {
            if (!this.usedBlockRenderLayers[blockRenderLayerId]) continue;
            SchematicRenderer.drawBuffer(this.bufferCache.func_179039_a(blockRenderLayerId));
        }
        GlStateManager.pushMatrix();
        Vec3d position = new Vec3d((Vec3i)this.anchor);
        Vec3d rotation = Vec3d.field_186680_a;
        StructureRenderer.renderTileEntities(this.schematic, position, rotation, this.schematic.getTileEntities());
        GlStateManager.popMatrix();
    }

    private void redraw(Minecraft minecraft) {
        Arrays.fill(this.usedBlockRenderLayers, false);
        Arrays.fill(this.startedBufferBuilders, false);
        SchematicWorld blockAccess = this.schematic;
        blockAccess.renderMode = true;
        BlockRendererDispatcher blockRendererDispatcher = minecraft.func_175602_ab();
        LinkedList<BlockState> blockstates = new LinkedList<BlockState>();
        BlockPos min = blockAccess.getBounds().getOrigin();
        BlockPos max = min.func_177971_a((Vec3i)blockAccess.getBounds().getSize());
        this.outline = new AABBOutline(new AxisAlignedBB(min, max));
        this.outline.setTextures(AllSpecialTextures.CHECKERED, AllSpecialTextures.HIGHLIGHT_CHECKERED);
        for (BlockPos localPos : BlockPos.func_218278_a((BlockPos)min, (BlockPos)max)) {
            BlockPos pos = localPos.func_177971_a((Vec3i)this.anchor);
            BlockState state = blockAccess.func_180495_p(pos);
            for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                if (!state.func_177230_c().canRenderInLayer(state, blockRenderLayer)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)blockRenderLayer);
                int blockRenderLayerId = blockRenderLayer.ordinal();
                BufferBuilder bufferBuilder = this.bufferCache.func_179039_a(blockRenderLayerId);
                if (!this.startedBufferBuilders[blockRenderLayerId]) {
                    this.startedBufferBuilders[blockRenderLayerId] = true;
                    bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                }
                int n = blockRenderLayerId;
                this.usedBlockRenderLayers[n] = this.usedBlockRenderLayers[n] | blockRendererDispatcher.renderBlock(state, pos, (IEnviromentBlockReader)blockAccess, bufferBuilder, minecraft.field_71441_e.field_73012_v, (IModelData)EmptyModelData.INSTANCE);
                blockstates.add(state);
            }
            ForgeHooksClient.setRenderLayer(null);
        }
        blockAccess.renderMode = false;
        for (int blockRenderLayerId = 0; blockRenderLayerId < this.usedBlockRenderLayers.length; ++blockRenderLayerId) {
            if (!this.startedBufferBuilders[blockRenderLayerId]) continue;
            this.bufferCache.func_179039_a(blockRenderLayerId).func_178977_d();
        }
    }

    private static void drawBuffer(BufferBuilder bufferBuilder) {
        VertexFormatElement.Usage usage;
        VertexFormatElement vertexformatelement;
        int index;
        if (bufferBuilder.func_178989_h() <= 0) {
            return;
        }
        VertexFormat vertexformat = bufferBuilder.func_178973_g();
        int size = vertexformat.func_177338_f();
        ByteBuffer bytebuffer = bufferBuilder.func_178966_f();
        List list = vertexformat.func_177343_g();
        for (index = 0; index < list.size(); ++index) {
            vertexformatelement = (VertexFormatElement)list.get(index);
            usage = vertexformatelement.func_177375_c();
            bytebuffer.position(vertexformat.func_181720_d(index));
            usage.preDraw(vertexformat, index, size, bytebuffer);
        }
        GlStateManager.drawArrays((int)bufferBuilder.func_178979_i(), (int)0, (int)bufferBuilder.func_178989_h());
        for (index = 0; index < list.size(); ++index) {
            vertexformatelement = (VertexFormatElement)list.get(index);
            usage = vertexformatelement.func_177375_c();
            usage.postDraw(vertexformat, index, size, bytebuffer);
        }
    }
}

