/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.schematics.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingAngle;
import com.simibubi.create.foundation.gui.widgets.InterpolatedChasingValue;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.gen.feature.template.PlacementSettings;

public class SchematicTransformation {
    private InterpolatedChasingValue x = new InterpolatedChasingValue();
    private InterpolatedChasingValue y = new InterpolatedChasingValue();
    private InterpolatedChasingValue z = new InterpolatedChasingValue();
    private InterpolatedChasingValue scaleFrontBack = new InterpolatedChasingValue();
    private InterpolatedChasingValue scaleLeftRight = new InterpolatedChasingValue();
    private InterpolatedChasingAngle rotation = new InterpolatedChasingAngle();
    private double xOrigin;
    private double zOrigin;

    public void init(BlockPos anchor, PlacementSettings settings, AxisAlignedBB bounds) {
        int leftRight = settings.func_186212_b() == Mirror.LEFT_RIGHT ? -1 : 1;
        int frontBack = settings.func_186212_b() == Mirror.FRONT_BACK ? -1 : 1;
        this.scaleFrontBack.start(frontBack);
        this.scaleLeftRight.start(leftRight);
        this.xOrigin = bounds.func_216364_b() / 2.0;
        this.zOrigin = bounds.func_216362_d() / 2.0;
        int r = -(settings.func_186215_c().ordinal() * 90);
        this.rotation.start(r);
        Vec3d vec = this.fromAnchor(anchor);
        this.x.start((float)vec.field_72450_a);
        this.y.start((float)vec.field_72448_b);
        this.z.start((float)vec.field_72449_c);
    }

    public void applyGLTransformations() {
        float pt = Minecraft.func_71410_x().func_184121_ak();
        GlStateManager.translated((double)this.x.get(pt), (double)this.y.get(pt), (double)this.z.get(pt));
        Vec3d rotationOffset = this.getRotationOffset(true);
        GlStateManager.translated((double)(this.xOrigin + rotationOffset.field_72450_a), (double)0.0, (double)(this.zOrigin + rotationOffset.field_72449_c));
        GlStateManager.rotated((double)this.rotation.get(pt), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.translated((double)(-rotationOffset.field_72450_a), (double)0.0, (double)(-rotationOffset.field_72449_c));
        GlStateManager.scaled((double)this.scaleFrontBack.get(pt), (double)1.0, (double)this.scaleLeftRight.get(pt));
        GlStateManager.translated((double)(-this.xOrigin), (double)0.0, (double)(-this.zOrigin));
    }

    public Vec3d getRotationOffset(boolean ignoreMirrors) {
        Vec3d rotationOffset = Vec3d.field_186680_a;
        if ((int)(this.zOrigin * 2.0) % 2 != (int)(this.xOrigin * 2.0) % 2) {
            float zIn;
            boolean xGreaterZ = this.xOrigin > this.zOrigin;
            float xIn = xGreaterZ ? 0.0f : 0.5f;
            float f = zIn = !xGreaterZ ? 0.0f : 0.5f;
            if (!ignoreMirrors) {
                xIn *= (float)this.getMirrorModifier(Direction.Axis.X);
                zIn *= (float)this.getMirrorModifier(Direction.Axis.Z);
            }
            rotationOffset = new Vec3d((double)xIn, 0.0, (double)zIn);
        }
        return rotationOffset;
    }

    public Vec3d toLocalSpace(Vec3d vec) {
        float pt = Minecraft.func_71410_x().func_184121_ak();
        Vec3d rotationOffset = this.getRotationOffset(true);
        vec = vec.func_178786_a((double)this.x.get(pt), (double)this.y.get(pt), (double)this.z.get(pt));
        vec = vec.func_178786_a(this.xOrigin + rotationOffset.field_72450_a, 0.0, this.zOrigin + rotationOffset.field_72449_c);
        vec = VecHelper.rotate(vec, -this.rotation.get(pt), Direction.Axis.Y);
        vec = vec.func_72441_c(rotationOffset.field_72450_a, 0.0, rotationOffset.field_72449_c);
        vec = vec.func_216372_d((double)this.scaleFrontBack.get(pt), 1.0, (double)this.scaleLeftRight.get(pt));
        vec = vec.func_72441_c(this.xOrigin, 0.0, this.zOrigin);
        return vec;
    }

    public PlacementSettings toSettings() {
        boolean mirrorfb;
        PlacementSettings settings = new PlacementSettings();
        int i = (int)this.rotation.getTarget();
        boolean mirrorlr = this.scaleLeftRight.getTarget() < 0.0f;
        boolean bl = mirrorfb = this.scaleFrontBack.getTarget() < 0.0f;
        if (mirrorlr && mirrorfb) {
            mirrorfb = false;
            mirrorlr = false;
            i += 180;
        }
        if ((i %= 360) < 0) {
            i += 360;
        }
        Rotation rotation = Rotation.NONE;
        switch (i) {
            case 90: {
                rotation = Rotation.COUNTERCLOCKWISE_90;
                break;
            }
            case 180: {
                rotation = Rotation.CLOCKWISE_180;
                break;
            }
            case 270: {
                rotation = Rotation.CLOCKWISE_90;
                break;
            }
        }
        settings.func_186220_a(rotation);
        if (mirrorfb) {
            settings.func_186214_a(Mirror.FRONT_BACK);
        }
        if (mirrorlr) {
            settings.func_186214_a(Mirror.LEFT_RIGHT);
        }
        return settings;
    }

    public BlockPos getAnchor() {
        Vec3d vec = Vec3d.field_186680_a.func_72441_c(0.5, 0.0, 0.5);
        Vec3d rotationOffset = this.getRotationOffset(false);
        vec = vec.func_178786_a(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.func_178786_a(rotationOffset.field_72450_a, 0.0, rotationOffset.field_72449_c);
        vec = vec.func_216372_d((double)this.scaleFrontBack.getTarget(), 1.0, (double)this.scaleLeftRight.getTarget());
        vec = VecHelper.rotate(vec, this.rotation.getTarget(), Direction.Axis.Y);
        vec = vec.func_72441_c(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.func_72441_c((double)this.x.getTarget(), (double)this.y.getTarget(), (double)this.z.getTarget());
        return new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public Vec3d fromAnchor(BlockPos pos) {
        Vec3d vec = Vec3d.field_186680_a.func_72441_c(0.5, 0.0, 0.5);
        Vec3d rotationOffset = this.getRotationOffset(false);
        vec = vec.func_178786_a(this.xOrigin, 0.0, this.zOrigin);
        vec = vec.func_178786_a(rotationOffset.field_72450_a, 0.0, rotationOffset.field_72449_c);
        vec = vec.func_216372_d((double)this.scaleFrontBack.getTarget(), 1.0, (double)this.scaleLeftRight.getTarget());
        vec = VecHelper.rotate(vec, this.rotation.getTarget(), Direction.Axis.Y);
        vec = vec.func_72441_c(this.xOrigin, 0.0, this.zOrigin);
        return new Vec3d((Vec3i)pos.func_177973_b((Vec3i)new BlockPos(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c)));
    }

    public int getRotationTarget() {
        return (int)this.rotation.getTarget();
    }

    public int getMirrorModifier(Direction.Axis axis) {
        if (axis == Direction.Axis.Z) {
            return (int)this.scaleLeftRight.getTarget();
        }
        return (int)this.scaleFrontBack.getTarget();
    }

    public float getCurrentRotation() {
        float pt = Minecraft.func_71410_x().func_184121_ak();
        return this.rotation.get(pt);
    }

    public void tick() {
        this.x.tick();
        this.y.tick();
        this.z.tick();
        this.scaleLeftRight.tick();
        this.scaleFrontBack.tick();
        this.rotation.tick();
    }

    public void flip(Direction.Axis axis) {
        if (axis == Direction.Axis.X) {
            this.scaleLeftRight.target(this.scaleLeftRight.getTarget() * -1.0f);
        }
        if (axis == Direction.Axis.Z) {
            this.scaleFrontBack.target(this.scaleFrontBack.getTarget() * -1.0f);
        }
    }

    public void rotate90(boolean clockwise) {
        this.rotation.target(this.rotation.getTarget() + (float)(clockwise ? -90 : 90));
    }

    public void move(float xIn, float yIn, float zIn) {
        this.moveTo(this.x.getTarget() + xIn, this.y.getTarget() + yIn, this.z.getTarget() + zIn);
    }

    public void moveTo(BlockPos pos) {
        this.moveTo(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void moveTo(float xIn, float yIn, float zIn) {
        this.x.target(xIn);
        this.y.target(yIn);
        this.z.target(zIn);
    }
}

