/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.schematics.client.tools;

import com.simibubi.create.ScreenResources;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.schematics.client.tools.DeployTool;
import com.simibubi.create.modules.schematics.client.tools.FlipTool;
import com.simibubi.create.modules.schematics.client.tools.ISchematicTool;
import com.simibubi.create.modules.schematics.client.tools.MoveTool;
import com.simibubi.create.modules.schematics.client.tools.MoveVerticalTool;
import com.simibubi.create.modules.schematics.client.tools.PlaceTool;
import com.simibubi.create.modules.schematics.client.tools.RotateTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public enum Tools {
    Deploy(new DeployTool(), ScreenResources.I_TOOL_DEPLOY),
    Move(new MoveTool(), ScreenResources.I_TOOL_MOVE_XZ),
    MoveY(new MoveVerticalTool(), ScreenResources.I_TOOL_MOVE_Y),
    Rotate(new RotateTool(), ScreenResources.I_TOOL_ROTATE),
    Print(new PlaceTool(), ScreenResources.I_CONFIRM),
    Flip(new FlipTool(), ScreenResources.I_TOOL_MIRROR);

    private ISchematicTool tool;
    private ScreenResources icon;

    private Tools(ISchematicTool tool, ScreenResources icon) {
        this.tool = tool;
        this.icon = icon;
    }

    public ISchematicTool getTool() {
        return this.tool;
    }

    public String getDisplayName() {
        return Lang.translate("schematic.tool." + Lang.asId(this.name()), new Object[0]);
    }

    public ScreenResources getIcon() {
        return this.icon;
    }

    public static List<Tools> getTools(boolean creative) {
        ArrayList<Tools> tools = new ArrayList<Tools>();
        Collections.addAll(tools, Move, MoveY, Deploy, Rotate, Flip);
        if (creative) {
            tools.add(Print);
        }
        return tools;
    }

    public List<String> getDescription() {
        return Lang.translatedOptions("schematic.tool." + Lang.asId(this.name()) + ".description", "0", "1", "2", "3");
    }
}

