/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.schematics.item;

import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.modules.schematics.client.SchematicEditScreen;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.thread.SidedThreadGroups;
import org.apache.commons.io.IOUtils;

public class SchematicItem
extends Item {
    public SchematicItem(Item.Properties properties) {
        super(properties.func_200917_a(1));
    }

    public static ItemStack create(String schematic, String owner) {
        ItemStack blueprint = AllItems.BLUEPRINT.asStack();
        CompoundNBT tag = new CompoundNBT();
        tag.func_74757_a("Deployed", false);
        tag.func_74778_a("Owner", owner);
        tag.func_74778_a("File", schematic);
        tag.func_218657_a("Anchor", (INBT)NBTUtil.func_186859_a((BlockPos)BlockPos.field_177992_a));
        tag.func_74778_a("Rotation", Rotation.NONE.name());
        tag.func_74778_a("Mirror", Mirror.NONE.name());
        blueprint.func_77982_d(tag);
        SchematicItem.writeSize(blueprint);
        return blueprint;
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            if (stack.func_77978_p().func_74764_b("File")) {
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GOLD + stack.func_77978_p().func_74779_i("File")));
            }
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.RED + Lang.translate("schematic.invalid", new Object[0])));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static void writeSize(ItemStack blueprint) {
        CompoundNBT tag = blueprint.func_77978_p();
        Template t = SchematicItem.loadSchematic(blueprint);
        tag.func_218657_a("Bounds", (INBT)NBTUtil.func_186859_a((BlockPos)t.func_186259_a()));
        blueprint.func_77982_d(tag);
    }

    public static PlacementSettings getSettings(ItemStack blueprint) {
        CompoundNBT tag = blueprint.func_77978_p();
        PlacementSettings settings = new PlacementSettings();
        settings.func_186220_a(Rotation.valueOf((String)tag.func_74779_i("Rotation")));
        settings.func_186214_a(Mirror.valueOf((String)tag.func_74779_i("Mirror")));
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Template loadSchematic(ItemStack blueprint) {
        Template t = new Template();
        String owner = blueprint.func_77978_p().func_74779_i("Owner");
        String schematic = blueprint.func_77978_p().func_74779_i("File");
        String filepath = "";
        filepath = Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER ? "schematics/uploaded/" + owner + "/" + schematic : "schematics/" + schematic;
        InputStream stream = null;
        try {
            stream = Files.newInputStream(Paths.get(filepath, new String[0]), StandardOpenOption.READ);
            CompoundNBT nbt = CompressedStreamTools.func_74796_a((InputStream)stream);
            t.func_186256_b(nbt);
            if (stream == null) return t;
        }
        catch (IOException iOException) {
            if (stream == null) return t;
            IOUtils.closeQuietly(stream);
            return t;
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)stream);
        return t;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!this.onItemUse(context.func_195999_j(), context.func_221531_n())) {
            return super.func_195939_a(context);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (!this.onItemUse(playerIn, handIn)) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    private boolean onItemUse(PlayerEntity player, Hand hand) {
        if (!player.func_70093_af() || hand != Hand.MAIN_HAND) {
            return false;
        }
        if (!player.func_184586_b(hand).func_77942_o()) {
            return false;
        }
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this::displayBlueprintScreen);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void displayBlueprintScreen() {
        ScreenOpener.open(new SchematicEditScreen());
    }
}

