/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.modules.schematics.packet;

import com.simibubi.create.Create;
import com.simibubi.create.foundation.packet.SimplePacketBase;
import com.simibubi.create.foundation.type.DimensionPos;
import com.simibubi.create.modules.schematics.block.SchematicTableContainer;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class SchematicUploadPacket
extends SimplePacketBase {
    public static final int BEGIN = 0;
    public static final int WRITE = 1;
    public static final int FINISH = 2;
    private int code;
    private long size;
    private String schematic;
    private byte[] data;

    public SchematicUploadPacket(int code, String schematic) {
        this.code = code;
        this.schematic = schematic;
    }

    public static SchematicUploadPacket begin(String schematic, long size) {
        SchematicUploadPacket pkt = new SchematicUploadPacket(0, schematic);
        pkt.size = size;
        return pkt;
    }

    public static SchematicUploadPacket write(String schematic, byte[] data) {
        SchematicUploadPacket pkt = new SchematicUploadPacket(1, schematic);
        pkt.data = data;
        return pkt;
    }

    public static SchematicUploadPacket finish(String schematic) {
        return new SchematicUploadPacket(2, schematic);
    }

    public SchematicUploadPacket(PacketBuffer buffer) {
        this.code = buffer.readInt();
        this.schematic = buffer.func_150789_c(256);
        if (this.code == 0) {
            this.size = buffer.readLong();
        }
        if (this.code == 1) {
            this.data = buffer.func_179251_a();
        }
    }

    @Override
    public void write(PacketBuffer buffer) {
        buffer.writeInt(this.code);
        buffer.func_180714_a(this.schematic);
        if (this.code == 0) {
            buffer.writeLong(this.size);
        }
        if (this.code == 1) {
            buffer.func_179250_a(this.data);
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)context.get()).getSender();
            if (this.code == 0) {
                BlockPos pos = ((SchematicTableContainer)player.field_71070_bA).getTileEntity().func_174877_v();
                Create.schematicReceiver.handleNewUpload(player, this.schematic, this.size, new DimensionPos(player, pos));
            }
            if (this.code == 1) {
                Create.schematicReceiver.handleWriteRequest(player, this.schematic, this.data);
            }
            if (this.code == 2) {
                Create.schematicReceiver.handleFinishedUpload(player, this.schematic);
            }
        });
        context.get().setPacketHandled(true);
    }
}

