/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import uk.co.dotcode.customvillagertrades.MyTradeConverted;
import uk.co.dotcode.customvillagertrades.TradeUtil;
import uk.co.dotcode.customvillagertrades.configs.MyTrade;
import uk.co.dotcode.customvillagertrades.configs.TradeCollection;
import uk.co.dotcode.customvillagertrades.configs.TradeHandler;
import uk.co.dotcode.customvillagertrades.configs.WandererTradeCollection;

public class TradeEvent {
    private TradeCollection tradeCollection;
    private TradeCollection tradeCollectionAll;
    private WandererTradeCollection tradeCollectionWanderer;

    @SubscribeEvent
    public void registerWanderingTrades(WandererTradesEvent event) {
        this.tradeCollectionWanderer = TradeHandler.loadWandererTrades("wanderer");
        if (this.tradeCollectionWanderer != null) {
            boolean problem = TradeUtil.checkTradeCollection(this.tradeCollectionWanderer);
            if (this.tradeCollectionWanderer.removeOtherTrades) {
                if (this.tradeCollectionWanderer.numberOfGenericTrades() < 5) {
                    LogManager.getLogger((String)"customvillagertrades").log(Level.ERROR, "You must have at least 5 'not-rare' trades for the wanderer!");
                    problem = true;
                }
                if (this.tradeCollectionWanderer.numberOfRareTrades() < 1) {
                    LogManager.getLogger((String)"customvillagertrades").log(Level.ERROR, "You must have at least 1 'rare' trade for the wanderer!");
                    problem = true;
                }
            }
            if (!problem) {
                int i;
                ArrayList<Object> genericArray = new ArrayList();
                ArrayList<Object> rareArray = new ArrayList();
                if (this.tradeCollectionWanderer.removeOtherTrades) {
                    while (event.getGenericTrades().size() > 0) {
                        event.getGenericTrades().remove(0);
                    }
                    while (event.getRareTrades().size() > 0) {
                        event.getRareTrades().remove(0);
                    }
                } else {
                    genericArray = new ArrayList<Object>(Arrays.asList((Object[])VillagerTrades.field_221240_b.get(1)));
                    rareArray = new ArrayList<Object>(Arrays.asList((Object[])VillagerTrades.field_221240_b.get(2)));
                }
                for (int i2 = 0; i2 < this.tradeCollectionWanderer.trades.length; ++i2) {
                    MyTradeConverted convertedTrade = new MyTradeConverted(this.tradeCollectionWanderer.trades[i2]);
                    if (this.tradeCollectionWanderer.trades[i2].isRare) {
                        event.getRareTrades().add(convertedTrade);
                        rareArray.add(convertedTrade);
                        continue;
                    }
                    event.getGenericTrades().add(convertedTrade);
                    genericArray.add(convertedTrade);
                }
                VillagerTrades.ITrade[] genericTradeArray = new VillagerTrades.ITrade[genericArray.size()];
                VillagerTrades.ITrade[] rareTradeArray = new VillagerTrades.ITrade[rareArray.size()];
                for (i = 0; i < genericArray.size(); ++i) {
                    genericTradeArray[i] = (VillagerTrades.ITrade)genericArray.get(i);
                }
                for (i = 0; i < rareArray.size(); ++i) {
                    rareTradeArray[i] = (VillagerTrades.ITrade)rareArray.get(i);
                }
                VillagerTrades.field_221240_b.remove(1);
                VillagerTrades.field_221240_b.remove(2);
                VillagerTrades.field_221240_b.put(1, (Object)genericTradeArray);
                VillagerTrades.field_221240_b.put(2, (Object)rareTradeArray);
            } else {
                LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "There is a problem with the trade config for wanderer file!");
            }
        }
    }

    @SubscribeEvent
    public void registerTrades(VillagerTradesEvent event) {
        if (event.getType() != VillagerProfession.field_221151_a) {
            MyTrade currentTrade;
            int i;
            this.tradeCollection = TradeHandler.loadTrades(event.getType().toString());
            this.tradeCollectionAll = TradeHandler.loadTrades("all");
            if (this.tradeCollection != null) {
                boolean problem = TradeUtil.checkTradeCollection(this.tradeCollection);
                if (!problem) {
                    if (this.tradeCollection.removeOtherTrades) {
                        for (int level = 1; level <= 5; ++level) {
                            while (((List)event.getTrades().get(level)).size() > 0) {
                                ((List)event.getTrades().get(level)).remove(0);
                            }
                        }
                    }
                    for (i = 0; i < this.tradeCollection.trades.length; ++i) {
                        currentTrade = this.tradeCollection.trades[i];
                        ((List)event.getTrades().get(currentTrade.tradeLevel)).add(new MyTradeConverted(currentTrade));
                    }
                } else {
                    LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "There is a problem with the trade config for " + event.getType().toString() + " file!");
                }
            }
            if (this.tradeCollectionAll != null) {
                boolean problemAll = TradeUtil.checkTradeCollection(this.tradeCollectionAll);
                if (!problemAll) {
                    for (i = 0; i < this.tradeCollectionAll.trades.length; ++i) {
                        currentTrade = this.tradeCollectionAll.trades[i];
                        ((List)event.getTrades().get(currentTrade.tradeLevel)).add(new MyTradeConverted(currentTrade));
                    }
                } else {
                    LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "There is a problem with the trade config for all file!");
                }
            }
        }
    }
}

