/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.configs;

import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraftforge.registries.ForgeRegistries;
import uk.co.dotcode.customvillagertrades.TradeUtil;

public class MyTradeEffect {
    public String effectKey;
    public Integer duration;
    public Integer level;
    public Boolean isVisible;
    public String potionKey;
    public String[] blacklistedPotionKeys;

    public MyTradeEffect() {
        if (this.duration == null) {
            this.duration = 300;
        }
        if (this.level == null) {
            this.level = 1;
        }
        if (this.isVisible == null) {
            this.isVisible = true;
        }
        if (this.potionKey == null) {
            this.potionKey = "minecraft:empty";
        }
    }

    public Potion getPotionKey(String key) {
        return (Potion)ForgeRegistries.POTION_TYPES.getValue(TradeUtil.getResourceLocation(key));
    }

    public Effect getEffect(String key) {
        return (Effect)ForgeRegistries.POTIONS.getValue(TradeUtil.getResourceLocation(key));
    }

    public EffectInstance getInstance() {
        int actualLevel = this.level - 1;
        if (actualLevel < 0) {
            actualLevel = 0;
        }
        return new EffectInstance(this.getEffect(this.effectKey), this.duration.intValue(), actualLevel, false, this.isVisible.booleanValue(), this.isVisible.booleanValue());
    }

    public EffectInstance getInstance(String chosenKey) {
        int actualLevel = this.level - 1;
        if (actualLevel < 0) {
            actualLevel = 0;
        }
        return new EffectInstance(this.getEffect(chosenKey), this.duration.intValue(), actualLevel, false, this.isVisible.booleanValue(), this.isVisible.booleanValue());
    }
}

