/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.configs;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SuspiciousStewItem;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import uk.co.dotcode.customvillagertrades.TradeUtil;
import uk.co.dotcode.customvillagertrades.configs.MyTradeEffect;
import uk.co.dotcode.customvillagertrades.configs.MyTradeEnchantment;
import uk.co.dotcode.customvillagertrades.configs.NBTData;

public class MyTradeItem {
    public String itemKey;
    public String customName;
    public Integer amount;
    public Integer priceModifier;
    public Integer customColourR;
    public Integer customColourG;
    public Integer customColourB;
    public Integer metadata;
    public MyTradeEnchantment[] enchantments;
    public MyTradeEnchantment[] semiRandomEnchantments;
    public String[] blacklistedEnchantments;
    public MyTradeEffect[] effects;
    public String[] blacklistedEffects;
    public NBTData[] nbtTags;
    public String mapStructure;

    public MyTradeItem(String itemKey, int amount, int priceModifier) {
        this.itemKey = itemKey;
        this.amount = amount;
        this.priceModifier = priceModifier;
    }

    public int getPriceModifier() {
        if (this.priceModifier == null) {
            return 0;
        }
        return this.priceModifier;
    }

    public ItemStack createItemStack(int modifier, Entity entity) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(TradeUtil.getResourceLocation(this.itemKey));
        ItemStack stack = new ItemStack((IItemProvider)item, this.amount + modifier);
        stack = this.processOther(stack, entity);
        if (this.metadata != null) {
            stack.func_196085_b(this.metadata.intValue());
        }
        if (this.customName != null) {
            stack.func_200302_a((ITextComponent)new StringTextComponent(this.customName));
        }
        stack = this.processEnchantments(stack);
        this.processCustomColour(stack);
        if (!this.itemKey.equalsIgnoreCase("minecraft:tipped_arrow")) {
            stack = this.processEffects(stack, entity);
        }
        if (!this.itemKey.equalsIgnoreCase("minecraft:potion")) {
            stack = this.processNBTData(stack);
        }
        return stack;
    }

    private void processCustomColour(ItemStack stack) {
        if (this.itemKey.equalsIgnoreCase("minecraft:tipped_arrow") || this.itemKey.equalsIgnoreCase("minecraft:potion")) {
            if (this.customColourR == null) {
                this.customColourR = 255;
            }
            if (this.customColourG == null) {
                this.customColourG = 0;
            }
            if (this.customColourB == null) {
                this.customColourB = 255;
            }
            NBTData colourNBT = new NBTData();
            colourNBT.nbtName = "CustomPotionColor";
            colourNBT.dataType = "Integer";
            colourNBT.data = Integer.toString(TradeUtil.getIntFromColor(this.customColourR, this.customColourG, this.customColourB));
            stack.func_196082_o().func_197643_a(colourNBT.getTag());
        }
    }

    public boolean checkEffects() {
        block7: {
            boolean check;
            int i;
            block6: {
                if (!this.itemKey.equalsIgnoreCase("minecraft:tipped_arrow")) break block6;
                if (!this.effects[0].potionKey.equalsIgnoreCase("random") && !TradeUtil.isPotionReal(this.effects[0].potionKey)) {
                    LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Potion invalid - " + this.effects[0] + " - " + this.effects[0].potionKey);
                    return true;
                }
                if (this.effects[0].blacklistedPotionKeys == null) break block7;
                for (String s : this.effects[0].blacklistedPotionKeys) {
                    boolean check2 = TradeUtil.isPotionReal(s);
                    if (check2) continue;
                    LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Potion invalid - " + this.effects[0] + " - " + s);
                    return true;
                }
                break block7;
            }
            if (this.effects != null && this.effects.length > 0) {
                for (i = 0; i < this.effects.length; ++i) {
                    check = TradeUtil.isEffectReal(this.effects[i].effectKey);
                    if (check) continue;
                    LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Effect invalid - " + this.effects[i].effectKey);
                    return true;
                }
            }
            if (this.blacklistedEffects != null && this.blacklistedEffects.length > 0) {
                for (i = 0; i < this.blacklistedEffects.length; ++i) {
                    check = TradeUtil.isEffectReal(this.blacklistedEffects[i]);
                    if (check) continue;
                    LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Blacklisted Effect invalid - " + this.blacklistedEffects[i]);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkEnchantments() {
        boolean check;
        int i;
        if (this.enchantments != null && this.enchantments.length > 0) {
            for (i = 0; i < this.enchantments.length; ++i) {
                check = TradeUtil.isEnchantmentKeyReal(this.enchantments[i].enchantmentKey);
                if (check) continue;
                LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Enchantment invalid - " + this.enchantments[i].enchantmentKey);
                return true;
            }
        }
        if (this.semiRandomEnchantments != null && this.semiRandomEnchantments.length > 0) {
            for (i = 0; i < this.semiRandomEnchantments.length; ++i) {
                check = TradeUtil.isEnchantmentKeyReal(this.semiRandomEnchantments[i].enchantmentKey);
                if (check) continue;
                LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Semi-Random Enchantment invalid - " + this.semiRandomEnchantments[i].enchantmentKey);
                return true;
            }
        }
        if (this.blacklistedEnchantments != null && this.blacklistedEnchantments.length > 0) {
            for (i = 0; i < this.blacklistedEnchantments.length; ++i) {
                check = TradeUtil.isEnchantmentKeyReal(this.blacklistedEnchantments[i]);
                if (check) continue;
                LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Blacklisted Enchantment invalid - " + this.blacklistedEnchantments[i]);
                return true;
            }
        }
        return false;
    }

    private ItemStack processOther(ItemStack stack, Entity entity) {
        ItemStack modifiedStack = stack.func_77946_l();
        if (stack.func_77973_b() == Items.field_151098_aY && this.mapStructure != null) {
            ServerWorld serverworld;
            BlockPos blockpos;
            Structure destination = (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(TradeUtil.getResourceLocation(this.mapStructure));
            if (entity.field_70170_p instanceof ServerWorld && (blockpos = (serverworld = (ServerWorld)entity.field_70170_p).func_241117_a_(destination, entity.func_233580_cy_(), 100, true)) != null) {
                ItemStack mapFilled = FilledMapItem.func_195952_a((World)serverworld, (int)blockpos.func_177958_n(), (int)blockpos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_226642_a_((ServerWorld)serverworld, (ItemStack)mapFilled);
                MapData.func_191094_a((ItemStack)mapFilled, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)MapDecoration.Type.TARGET_POINT);
                modifiedStack = mapFilled;
            }
        }
        if (stack.func_77973_b() == Items.field_185167_i) {
            Potion selectedPotion = null;
            ItemStack potionStack = stack.func_77946_l();
            if (this.effects[0].potionKey.equalsIgnoreCase("random")) {
                ArrayList<Potion> possiblePotions = new ArrayList<Potion>();
                List list = ForgeRegistries.POTION_TYPES.getValues().stream().collect(Collectors.toList());
                for (Potion p : list) {
                    boolean blacklisted = false;
                    if (this.effects[0].blacklistedPotionKeys != null) {
                        for (String blacklistString : this.effects[0].blacklistedPotionKeys) {
                            if (!p.getRegistryName().toString().equalsIgnoreCase(blacklistString) && !p.getRegistryName().toString().equalsIgnoreCase("minecraft:awkward") && !p.getRegistryName().toString().equalsIgnoreCase("minecraft:empty") && !p.getRegistryName().toString().equalsIgnoreCase("minecraft:mundane")) continue;
                            blacklisted = true;
                        }
                    }
                    if (blacklisted) continue;
                    possiblePotions.add(p);
                }
                int random = TradeUtil.random.nextInt(possiblePotions.size());
                selectedPotion = (Potion)possiblePotions.get(random);
            } else {
                for (Potion p : ForgeRegistries.POTION_TYPES) {
                    if (!p.getRegistryName().toString().equalsIgnoreCase(this.effects[0].potionKey)) continue;
                    selectedPotion = p;
                    break;
                }
            }
            if (selectedPotion != null) {
                PotionUtils.func_185188_a((ItemStack)potionStack, selectedPotion);
                modifiedStack = potionStack;
            }
        }
        return modifiedStack;
    }

    private ItemStack processEnchantments(ItemStack stack) {
        ItemStack enchantedStack = stack.func_77946_l();
        if (this.enchantments != null) {
            for (int i = 0; i < this.enchantments.length; ++i) {
                if (this.enchantments[i].enchantmentKey.equalsIgnoreCase("random")) {
                    ArrayList<Enchantment> availableRandomEnchantments = new ArrayList<Enchantment>();
                    for (Enchantment e : ForgeRegistries.ENCHANTMENTS.getValues()) {
                        boolean isBlacklisted = false;
                        if (stack.func_77973_b().getRegistryName().toString().equalsIgnoreCase("minecraft:enchanted_book")) {
                            if (this.blacklistedEnchantments != null) {
                                for (String blacklisted : this.blacklistedEnchantments) {
                                    if (!e.getRegistryName().toString().equalsIgnoreCase(blacklisted)) continue;
                                    isBlacklisted = true;
                                }
                            }
                            if (isBlacklisted) continue;
                            availableRandomEnchantments.add(e);
                            continue;
                        }
                        if (!e.canApplyAtEnchantingTable(enchantedStack)) continue;
                        if (this.blacklistedEnchantments != null) {
                            for (String blacklisted : this.blacklistedEnchantments) {
                                if (!e.getRegistryName().toString().equalsIgnoreCase(blacklisted)) continue;
                                isBlacklisted = true;
                            }
                        }
                        if (isBlacklisted) continue;
                        availableRandomEnchantments.add(e);
                    }
                    this.addEnchantmentMyWay(enchantedStack, (Enchantment)availableRandomEnchantments.get(TradeUtil.random.nextInt(availableRandomEnchantments.size())), this.enchantments[i].enchantmentLevel, this.enchantments[i].maxEnchantmentLevel);
                    continue;
                }
                if (this.enchantments[i].enchantmentKey.contains("#")) {
                    String[] enchantmentChoices = this.enchantments[i].enchantmentKey.split("#");
                    String chosenKey = enchantmentChoices[TradeUtil.random.nextInt(enchantmentChoices.length)];
                    this.addEnchantmentMyWay(enchantedStack, (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(TradeUtil.getResourceLocation(chosenKey)), this.enchantments[i].enchantmentLevel, this.enchantments[i].maxEnchantmentLevel);
                    continue;
                }
                this.addEnchantmentMyWay(enchantedStack, this.enchantments[i].getEnchantment(), this.enchantments[i].enchantmentLevel, this.enchantments[i].maxEnchantmentLevel);
            }
        }
        if (this.semiRandomEnchantments != null) {
            int randomInt = TradeUtil.random.nextInt(this.semiRandomEnchantments.length);
            this.addEnchantmentMyWay(enchantedStack, this.semiRandomEnchantments[randomInt].getEnchantment(), this.semiRandomEnchantments[randomInt].enchantmentLevel, this.semiRandomEnchantments[randomInt].maxEnchantmentLevel);
        }
        return enchantedStack;
    }

    private ItemStack processNBTData(ItemStack stack) {
        ItemStack nbtStack = stack.func_77946_l();
        if (this.nbtTags != null) {
            for (NBTData nbt : this.nbtTags) {
                nbtStack.func_196082_o().func_197643_a(nbt.getTag());
            }
        }
        return nbtStack;
    }

    private ItemStack processEffects(ItemStack stack, Entity entity) {
        ItemStack effectStack = stack.func_77946_l();
        if (this.effects != null) {
            ArrayList effectsToApply = new ArrayList();
            for (int i = 0; i < this.effects.length; ++i) {
                if (this.effects[i].effectKey.equalsIgnoreCase("random")) {
                    ArrayList<EffectInstance> availableRandomEffects = new ArrayList<EffectInstance>();
                    for (Effect e : ForgeRegistries.POTIONS.getValues()) {
                        boolean isBlacklisted = false;
                        if (this.blacklistedEffects != null) {
                            for (String blacklisted : this.blacklistedEffects) {
                                if (!e.getRegistryName().toString().equalsIgnoreCase(blacklisted)) continue;
                                isBlacklisted = true;
                            }
                        }
                        if (isBlacklisted) continue;
                        availableRandomEffects.add(this.effects[i].getInstance(e.getRegistryName().toString()));
                    }
                    effectsToApply.add(availableRandomEffects.get(TradeUtil.random.nextInt(availableRandomEffects.size())));
                    continue;
                }
                if (this.effects[i].effectKey.contains("#")) {
                    String[] effectChoices = this.effects[i].effectKey.split("#");
                    String chosenKey = effectChoices[TradeUtil.random.nextInt(effectChoices.length)];
                    effectsToApply.add(this.effects[i].getInstance(chosenKey));
                    continue;
                }
                effectsToApply.add(this.effects[i].getInstance());
            }
            PotionUtils.func_185184_a((ItemStack)effectStack, effectsToApply);
            if (this.itemKey.equalsIgnoreCase("minecraft:suspicious_stew")) {
                for (EffectInstance e : effectsToApply) {
                    SuspiciousStewItem.func_220037_a((ItemStack)effectStack, (Effect)e.func_188419_a(), (int)e.func_76459_b());
                }
            }
        }
        return effectStack;
    }

    private ItemStack addEnchantmentMyWay(ItemStack stack, Enchantment enchantment, int level, int maxLevel) {
        int chosenLevel = level;
        if (level < 0) {
            chosenLevel = TradeUtil.random.nextInt(maxLevel) + 1;
        }
        if (stack.func_77973_b() == Items.field_151134_bR) {
            EnchantedBookItem.func_92115_a((ItemStack)stack, (EnchantmentData)new EnchantmentData(enchantment, chosenLevel));
        } else {
            stack.func_77966_a(enchantment, chosenLevel);
        }
        return stack;
    }
}

