/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.packet;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import uk.co.dotcode.customvillagertrades.packet.SendVillagerLevelUpdatePacket;

public class PacketHandler {
    public static int index = 0;
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("customvillagertrades", "main_channel")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();

    public static void register() {
        HANDLER.registerMessage(index++, SendVillagerLevelUpdatePacket.class, SendVillagerLevelUpdatePacket::encode, SendVillagerLevelUpdatePacket::new, PacketHandler::handleVillagerLevelUpdate);
    }

    public static void sendToClient(Object message, ServerPlayerEntity player) {
        HANDLER.sendTo(message, player.field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToServer(Object message) {
        HANDLER.sendToServer(message);
    }

    public static void handleVillagerLevelUpdate(SendVillagerLevelUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                UUID uuid = message.uuid;
                Entity e = ((NetworkEvent.Context)ctx.get()).getSender().func_71121_q().func_217461_a(uuid);
                if (e != null && e instanceof VillagerEntity) {
                    VillagerEntity v = (VillagerEntity)e;
                    int data = message.data;
                    v.func_213761_t(PacketHandler.getXpToSet(v.func_213700_eh().func_221132_c() + data));
                    v.func_213704_a((MerchantOffer)v.func_213706_dY().get(0));
                }
            });
        } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            // empty if block
        }
        ctx.get().setPacketHandled(true);
    }

    private static int getXpToSet(int targetLevel) {
        switch (targetLevel) {
            case 1: {
                return 0;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 71;
            }
            case 4: {
                return 151;
            }
            case 5: {
                return 251;
            }
        }
        return 0;
    }
}

