/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import uk.co.dotcode.customvillagertrades.configs.MyTrade;
import uk.co.dotcode.customvillagertrades.configs.MyTradeItem;
import uk.co.dotcode.customvillagertrades.configs.TradeCollection;
import uk.co.dotcode.customvillagertrades.configs.WandererTradeCollection;

public class TradeUtil {
    public static Random random = new Random();

    public static boolean checkTradeCollection(TradeCollection coll) {
        return TradeUtil.checkTrade(coll.trades, coll.profession);
    }

    public static boolean checkTradeCollection(WandererTradeCollection coll) {
        return TradeUtil.checkTrade(coll.trades, coll.profession);
    }

    public static boolean isJsonFile(File f) {
        String extension = f.getPath().substring(f.getPath().lastIndexOf("."));
        return extension.equalsIgnoreCase(".json");
    }

    private static boolean checkTrade(MyTrade[] trades, String profession) {
        boolean problem = false;
        for (int i = 0; i < trades.length; ++i) {
            MyTrade trade = trades[i];
            if (trade.offer != null && !TradeUtil.checkItemKey(trade.offer.itemKey)) {
                LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Unable to add a custom trade! Reason: invalid offer item - " + profession + ", entry number = " + i + ", item = " + trade.offer.itemKey);
                problem = true;
            }
            if (trade.multiOffer != null) {
                for (MyTradeItem t : trade.multiOffer) {
                    if (TradeUtil.checkItemKey(t.itemKey)) continue;
                    LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Unable to add a custom trade! Reason: invalid multiOffer item - " + profession + ", entry number = " + i + ", item = " + t.itemKey);
                    problem = true;
                }
            }
            if (!TradeUtil.checkItemKey(trade.request.itemKey)) {
                LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Unable to add a custom trade! Reason: invalid request item - " + profession + ", entry number = " + i + ", item = " + trade.request.itemKey);
                problem = true;
            }
            if (trade.additionalRequest != null && !TradeUtil.checkItemKey(trade.additionalRequest.itemKey)) {
                LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Unable to add a custom trade! Reason: invalid additional request item - " + profession + ", entry number = " + i + ", item = " + trade.additionalRequest.itemKey);
                problem = true;
            }
            boolean offerProblem = false;
            boolean multiOfferProblem = false;
            boolean requestProblem = trade.request.checkEnchantments();
            boolean additionalRequestProblem = false;
            if (trade.offer != null) {
                offerProblem = trade.offer.checkEnchantments();
            }
            if (trade.multiOffer != null) {
                for (MyTradeItem t : trade.multiOffer) {
                    if (!t.checkEnchantments()) continue;
                    multiOfferProblem = true;
                }
            }
            if (trade.additionalRequest != null) {
                additionalRequestProblem = trade.additionalRequest.checkEnchantments();
            }
            if (offerProblem || multiOfferProblem || requestProblem || additionalRequestProblem) {
                Object key = "";
                if (offerProblem) {
                    key = trade.offer.itemKey;
                }
                if (multiOfferProblem) {
                    key = "multiOffer: ";
                    for (MyTradeItem t : trade.multiOffer) {
                        key = (String)key + t.itemKey + ",";
                    }
                }
                LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Unable to add a custom trade! Reason: invalid enchantment (listed above) - " + profession + ", entry number = " + i + ", item = " + (String)key);
                problem = true;
            }
            if (trade.tradeLevel >= 1 && trade.tradeLevel <= 5) continue;
            LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Unable to add a custom trade! Reason: invalid trade level. Use a number between 1 and 5 - " + profession + ", entry number = " + i + ", level = " + trade.tradeLevel);
        }
        return problem;
    }

    private static boolean checkItemKey(String itemKey) {
        String[] splitLocation = itemKey.split(":");
        if (splitLocation.length == 2) {
            ResourceLocation resourceLocation = TradeUtil.getResourceLocation(itemKey);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
            return item != null && item != Items.f_41852_;
        }
        return false;
    }

    public static boolean isEnchantmentKeyReal(String enchantmentKey) {
        if (enchantmentKey.equalsIgnoreCase("random")) {
            return true;
        }
        if (enchantmentKey.contains("#")) {
            String[] splitEnchantments = enchantmentKey.split("#");
            boolean problem = false;
            for (String s : splitEnchantments) {
                if (!TradeUtil.isSpecificEnchantmentKeyReal(s)) continue;
                problem = true;
            }
            return !problem;
        }
        return TradeUtil.isSpecificEnchantmentKeyReal(enchantmentKey);
    }

    private static boolean isSpecificEnchantmentKeyReal(String enchantmentKey) {
        if (enchantmentKey == null) {
            LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Enchantment invalid - There's no enchantment key!");
            return false;
        }
        String[] splitLocation = enchantmentKey.split(":");
        if (splitLocation.length == 2) {
            ResourceLocation resourceLocation = TradeUtil.getResourceLocation(enchantmentKey);
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(resourceLocation);
            return enchantment != null;
        }
        return false;
    }

    public static boolean isEffectReal(String effectKey) {
        if (effectKey == null) {
            LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Effect invalid - There's no effect key!");
            return false;
        }
        if (effectKey.equalsIgnoreCase("random")) {
            return true;
        }
        String[] splitLocation = effectKey.split(":");
        if (splitLocation.length == 2) {
            ResourceLocation resourceLocation = TradeUtil.getResourceLocation(effectKey);
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(resourceLocation);
            return effect != null;
        }
        return false;
    }

    public static boolean isPotionReal(String potionKey) {
        if (potionKey == null) {
            LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Potion invalid - There's no potion key!");
            return false;
        }
        if (potionKey.equalsIgnoreCase("random")) {
            return true;
        }
        String[] splitLocation = potionKey.split(":");
        if (splitLocation.length == 2) {
            ResourceLocation resourceLocation = TradeUtil.getResourceLocation(potionKey);
            Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(resourceLocation);
            return !potion.getRegistryName().toString().equalsIgnoreCase("minecraft:empty");
        }
        return false;
    }

    public static ArrayList<MyTrade> convertOldTrades(List<? extends String> customTrades) {
        ArrayList<MyTrade> validTrades = new ArrayList<MyTrade>();
        for (int i = 0; i < customTrades.size(); ++i) {
            MyTrade theTrade = new MyTrade();
            String[] data = customTrades.get(i).split(" ");
            if (TradeUtil.checkDataNumerics(data)) {
                String[] dataToCheck;
                int tradeLevel;
                theTrade.tradeLevel = tradeLevel = Integer.parseInt(data[0]);
                if (tradeLevel < 1 || tradeLevel > 5) {
                    LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Unable to add an old custom trade! Reason: invalid trade level. Use a number between 1 and 5 - " + customTrades.get(i));
                    continue;
                }
                if (data.length == 6) {
                    dataToCheck = new String[]{data[1], data[3]};
                    if (!TradeUtil.doItemsExist(dataToCheck)) continue;
                    theTrade.offer = new MyTradeItem(data[1], Integer.parseInt(data[2]), 0);
                    theTrade.request = new MyTradeItem(data[3], Integer.parseInt(data[4]), 0);
                    theTrade.tradeExp = Integer.parseInt(data[5]);
                    validTrades.add(theTrade);
                    LogManager.getLogger((String)"customvillagertrades").log(Level.INFO, "Successfully loaded old custom trade - " + customTrades.get(i));
                    continue;
                }
                if (data.length == 7) {
                    dataToCheck = new String[]{data[1], data[3]};
                    if (!TradeUtil.doItemsExist(dataToCheck)) continue;
                    theTrade.offer = new MyTradeItem(data[1], Integer.parseInt(data[2]), 0);
                    theTrade.request = new MyTradeItem(data[3], Integer.parseInt(data[4]), 0);
                    theTrade.tradeExp = Integer.parseInt(data[5]);
                    theTrade.maxUses = Integer.parseInt(data[6]);
                    validTrades.add(theTrade);
                    LogManager.getLogger((String)"customvillagertrades").log(Level.INFO, "Successfully added old custom trade - " + customTrades.get(i));
                    continue;
                }
                if (data.length == 8) {
                    dataToCheck = new String[]{data[1], data[3], data[5]};
                    if (!TradeUtil.doItemsExist(dataToCheck)) continue;
                    theTrade.offer = new MyTradeItem(data[1], Integer.parseInt(data[2]), 0);
                    theTrade.request = new MyTradeItem(data[3], Integer.parseInt(data[4]), 0);
                    theTrade.additionalRequest = new MyTradeItem(data[5], Integer.parseInt(data[6]), 0);
                    theTrade.tradeExp = Integer.parseInt(data[7]);
                    validTrades.add(theTrade);
                    LogManager.getLogger((String)"customvillagertrades").log(Level.INFO, "Successfully added old custom trade - " + customTrades.get(i));
                    continue;
                }
                if (data.length == 9) {
                    dataToCheck = new String[]{data[1], data[3], data[5]};
                    if (!TradeUtil.doItemsExist(dataToCheck)) continue;
                    theTrade.offer = new MyTradeItem(data[1], Integer.parseInt(data[2]), 0);
                    theTrade.request = new MyTradeItem(data[3], Integer.parseInt(data[4]), 0);
                    theTrade.additionalRequest = new MyTradeItem(data[5], Integer.parseInt(data[6]), 0);
                    theTrade.tradeExp = Integer.parseInt(data[7]);
                    theTrade.maxUses = Integer.parseInt(data[8]);
                    validTrades.add(theTrade);
                    LogManager.getLogger((String)"customvillagertrades").log(Level.INFO, "Successfully added old custom trade - " + customTrades.get(i));
                    continue;
                }
                LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Unable to add an old custom trade! Reason: invalid format - " + customTrades.get(i));
                continue;
            }
            LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Unable to add an old custom trade! Reason: invalid format (numbers) - " + customTrades.get(i));
        }
        return validTrades;
    }

    private static boolean checkDataNumerics(String[] data) {
        return data.length == 6 ? StringUtils.isNumeric((CharSequence)data[0]) && StringUtils.isNumeric((CharSequence)data[2]) && StringUtils.isNumeric((CharSequence)data[4]) && StringUtils.isNumeric((CharSequence)data[5]) : (data.length == 7 ? StringUtils.isNumeric((CharSequence)data[0]) && StringUtils.isNumeric((CharSequence)data[2]) && StringUtils.isNumeric((CharSequence)data[4]) && StringUtils.isNumeric((CharSequence)data[5]) && StringUtils.isNumeric((CharSequence)data[6]) : (data.length == 8 ? StringUtils.isNumeric((CharSequence)data[0]) && StringUtils.isNumeric((CharSequence)data[2]) && StringUtils.isNumeric((CharSequence)data[4]) && StringUtils.isNumeric((CharSequence)data[6]) && StringUtils.isNumeric((CharSequence)data[7]) : data.length == 9 && StringUtils.isNumeric((CharSequence)data[0]) && StringUtils.isNumeric((CharSequence)data[2]) && StringUtils.isNumeric((CharSequence)data[4]) && StringUtils.isNumeric((CharSequence)data[6]) && StringUtils.isNumeric((CharSequence)data[7]) && StringUtils.isNumeric((CharSequence)data[8])));
    }

    private static boolean doItemsExist(String[] toCheck) {
        Object problems = "";
        for (int i = 0; i < toCheck.length; ++i) {
            String[] splitLocation = toCheck[i].split(":");
            if (splitLocation.length == 2) {
                ResourceLocation resourceLocation = TradeUtil.getResourceLocation(toCheck[i]);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                if (item != null && item != Items.f_41852_) continue;
                problems = (String)problems + toCheck[i] + " ";
                continue;
            }
            problems = (String)problems + toCheck[i] + " ";
        }
        if (((String)problems).length() > 0) {
            LogManager.getLogger((String)"customvillagertrades").log(Level.WARN, "Unable to add an old custom trade! Reason: item/block does not exist - " + (String)problems);
            return false;
        }
        return true;
    }

    public static ResourceLocation getResourceLocation(String key) {
        String[] splitLocation = key.split(":");
        return new ResourceLocation(splitLocation[0], splitLocation[1]);
    }

    public static int getIntFromColor(int r, int g, int b) {
        int rgb = r;
        rgb = (rgb << 8) + g;
        rgb = (rgb << 8) + b;
        return rgb;
    }
}

