/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.configs;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.registries.ForgeRegistries;
import uk.co.dotcode.customvillagertrades.TradeUtil;

public class MyTradeEffect {
    public String effectKey;
    public Integer duration;
    public Integer level;
    public Boolean isVisible;
    public String potionKey;
    public String[] blacklistedPotionKeys;

    public MyTradeEffect() {
        if (this.duration == null) {
            this.duration = 300;
        }
        if (this.level == null) {
            this.level = 1;
        }
        if (this.isVisible == null) {
            this.isVisible = true;
        }
        if (this.potionKey == null) {
            this.potionKey = "minecraft:empty";
        }
    }

    public Potion getPotionKey(String key) {
        return (Potion)ForgeRegistries.POTIONS.getValue(TradeUtil.getResourceLocation(key));
    }

    public MobEffect getEffect(String key) {
        return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(TradeUtil.getResourceLocation(key));
    }

    public MobEffectInstance getInstance() {
        int actualLevel = this.level - 1;
        if (actualLevel < 0) {
            actualLevel = 0;
        }
        return new MobEffectInstance(this.getEffect(this.effectKey), this.duration.intValue(), actualLevel, false, this.isVisible.booleanValue(), this.isVisible.booleanValue());
    }

    public MobEffectInstance getInstance(String chosenKey) {
        int actualLevel = this.level - 1;
        if (actualLevel < 0) {
            actualLevel = 0;
        }
        return new MobEffectInstance(this.getEffect(chosenKey), this.duration.intValue(), actualLevel, false, this.isVisible.booleanValue(), this.isVisible.booleanValue());
    }
}

