/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.configs;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.SuspiciousStewItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.saveddata.maps.MapDecoration;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import uk.co.dotcode.customvillagertrades.TradeUtil;
import uk.co.dotcode.customvillagertrades.configs.MyTradeEffect;
import uk.co.dotcode.customvillagertrades.configs.MyTradeEnchantment;
import uk.co.dotcode.customvillagertrades.configs.NBTData;

public class MyTradeItem {
    public String itemKey;
    public String customName;
    public Integer amount;
    public Integer priceModifier;
    public Integer customColourR;
    public Integer customColourG;
    public Integer customColourB;
    public Integer metadata;
    public MyTradeEnchantment[] enchantments;
    public MyTradeEnchantment[] semiRandomEnchantments;
    public String[] blacklistedEnchantments;
    public MyTradeEffect[] effects;
    public String[] blacklistedEffects;
    public NBTData[] nbtTags;
    public String mapStructure;

    public MyTradeItem(String itemKey, int amount, int priceModifier) {
        this.itemKey = itemKey;
        this.amount = amount;
        this.priceModifier = priceModifier;
    }

    public int getPriceModifier() {
        if (this.priceModifier == null) {
            return 0;
        }
        return this.priceModifier;
    }

    public ItemStack createItemStack(int modifier, Entity entity) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(TradeUtil.getResourceLocation(this.itemKey));
        ItemStack stack = new ItemStack((ItemLike)item, this.amount + modifier);
        stack = this.processOther(stack, entity);
        if (this.metadata != null) {
            stack.m_41721_(this.metadata.intValue());
        }
        if (this.customName != null) {
            stack.m_41714_((Component)new TextComponent(this.customName));
        }
        stack = this.processEnchantments(stack);
        this.processCustomColour(stack);
        if (!this.itemKey.equalsIgnoreCase("minecraft:tipped_arrow")) {
            stack = this.processEffects(stack, entity);
        }
        if (!this.itemKey.equalsIgnoreCase("minecraft:potion")) {
            stack = this.processNBTData(stack);
        }
        return stack;
    }

    private void processCustomColour(ItemStack stack) {
        if (this.itemKey.equalsIgnoreCase("minecraft:tipped_arrow") || this.itemKey.equalsIgnoreCase("minecraft:potion")) {
            if (this.customColourR == null) {
                this.customColourR = 255;
            }
            if (this.customColourG == null) {
                this.customColourG = 0;
            }
            if (this.customColourB == null) {
                this.customColourB = 255;
            }
            NBTData colourNBT = new NBTData();
            colourNBT.nbtName = "CustomPotionColor";
            colourNBT.dataType = "Integer";
            colourNBT.data = Integer.toString(TradeUtil.getIntFromColor(this.customColourR, this.customColourG, this.customColourB));
            stack.m_41784_().m_128391_(colourNBT.getTag());
        }
    }

    public boolean checkEffects() {
        block7: {
            boolean check;
            int i;
            block6: {
                if (!this.itemKey.equalsIgnoreCase("minecraft:tipped_arrow")) break block6;
                if (!this.effects[0].potionKey.equalsIgnoreCase("random") && !TradeUtil.isPotionReal(this.effects[0].potionKey)) {
                    LogManager.getLogger((String)"customvillagertrades").log(org.apache.logging.log4j.Level.WARN, "Potion invalid - " + this.effects[0] + " - " + this.effects[0].potionKey);
                    return true;
                }
                if (this.effects[0].blacklistedPotionKeys == null) break block7;
                for (int i2 = 0; i2 < this.effects[0].blacklistedPotionKeys.length; ++i2) {
                    boolean check2 = TradeUtil.isPotionReal(this.effects[0].blacklistedPotionKeys[i2]);
                    if (check2) continue;
                    LogManager.getLogger((String)"customvillagertrades").log(org.apache.logging.log4j.Level.WARN, "Potion invalid - " + this.effects[0] + " - " + this.effects[0].blacklistedPotionKeys[i2]);
                    return true;
                }
                break block7;
            }
            if (this.effects != null && this.effects.length > 0) {
                for (i = 0; i < this.effects.length; ++i) {
                    check = TradeUtil.isEffectReal(this.effects[i].effectKey);
                    if (check) continue;
                    LogManager.getLogger((String)"customvillagertrades").log(org.apache.logging.log4j.Level.WARN, "Effect invalid - " + this.effects[i].effectKey);
                    return true;
                }
            }
            if (this.blacklistedEffects != null && this.blacklistedEffects.length > 0) {
                for (i = 0; i < this.blacklistedEffects.length; ++i) {
                    check = TradeUtil.isEffectReal(this.blacklistedEffects[i]);
                    if (check) continue;
                    LogManager.getLogger((String)"customvillagertrades").log(org.apache.logging.log4j.Level.WARN, "Blacklisted Effect invalid - " + this.blacklistedEffects[i]);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkEnchantments() {
        boolean check;
        int i;
        if (this.enchantments != null && this.enchantments.length > 0) {
            for (i = 0; i < this.enchantments.length; ++i) {
                check = TradeUtil.isEnchantmentKeyReal(this.enchantments[i].enchantmentKey);
                if (check) continue;
                LogManager.getLogger((String)"customvillagertrades").log(org.apache.logging.log4j.Level.WARN, "Enchantment invalid - " + this.enchantments[i].enchantmentKey);
                return true;
            }
        }
        if (this.semiRandomEnchantments != null && this.semiRandomEnchantments.length > 0) {
            for (i = 0; i < this.semiRandomEnchantments.length; ++i) {
                check = TradeUtil.isEnchantmentKeyReal(this.semiRandomEnchantments[i].enchantmentKey);
                if (check) continue;
                LogManager.getLogger((String)"customvillagertrades").log(org.apache.logging.log4j.Level.WARN, "Semi-Random Enchantment invalid - " + this.semiRandomEnchantments[i].enchantmentKey);
                return true;
            }
        }
        if (this.blacklistedEnchantments != null && this.blacklistedEnchantments.length > 0) {
            for (i = 0; i < this.blacklistedEnchantments.length; ++i) {
                check = TradeUtil.isEnchantmentKeyReal(this.blacklistedEnchantments[i]);
                if (check) continue;
                LogManager.getLogger((String)"customvillagertrades").log(org.apache.logging.log4j.Level.WARN, "Blacklisted Enchantment invalid - " + this.blacklistedEnchantments[i]);
                return true;
            }
        }
        return false;
    }

    private ItemStack processOther(ItemStack stack, Entity entity) {
        ItemStack modifiedStack = stack.m_41777_();
        if (stack.m_41720_() == Items.f_42573_ && this.mapStructure != null) {
            ServerLevel serverlevel;
            BlockPos blockpos;
            StructureFeature destination = (StructureFeature)ForgeRegistries.STRUCTURE_FEATURES.getValue(TradeUtil.getResourceLocation(this.mapStructure));
            if (entity.f_19853_ instanceof ServerLevel && (blockpos = (serverlevel = (ServerLevel)entity.f_19853_).m_8717_(destination, entity.m_142538_(), 100, true)) != null) {
                ItemStack mapFilled = MapItem.m_42886_((Level)serverlevel, (int)blockpos.m_123341_(), (int)blockpos.m_123343_(), (byte)2, (boolean)true, (boolean)true);
                MapItem.m_42850_((ServerLevel)serverlevel, (ItemStack)mapFilled);
                MapItemSavedData.m_77925_((ItemStack)mapFilled, (BlockPos)blockpos, (String)"+", (MapDecoration.Type)MapDecoration.Type.TARGET_POINT);
                modifiedStack = mapFilled;
            }
        }
        if (stack.m_41720_() == Items.f_42738_) {
            Potion selectedPotion = null;
            ItemStack potionStack = stack.m_41777_();
            if (this.effects[0].potionKey.equalsIgnoreCase("random")) {
                ArrayList<Potion> possiblePotions = new ArrayList<Potion>();
                List list = ForgeRegistries.POTIONS.getValues().stream().collect(Collectors.toList());
                for (Potion p : list) {
                    boolean blacklisted = false;
                    if (this.effects[0].blacklistedPotionKeys != null) {
                        for (String blacklistString : this.effects[0].blacklistedPotionKeys) {
                            if (!p.getRegistryName().toString().equalsIgnoreCase(blacklistString) && !p.getRegistryName().toString().equalsIgnoreCase("minecraft:awkward") && !p.getRegistryName().toString().equalsIgnoreCase("minecraft:empty") && !p.getRegistryName().toString().equalsIgnoreCase("minecraft:mundane")) continue;
                            blacklisted = true;
                        }
                    }
                    if (blacklisted) continue;
                    possiblePotions.add(p);
                }
                int random = TradeUtil.random.nextInt(possiblePotions.size());
                selectedPotion = (Potion)possiblePotions.get(random);
            } else {
                for (Potion p : ForgeRegistries.POTIONS) {
                    if (!p.getRegistryName().toString().equalsIgnoreCase(this.effects[0].potionKey)) continue;
                    selectedPotion = p;
                    break;
                }
            }
            if (selectedPotion != null) {
                PotionUtils.m_43549_((ItemStack)potionStack, selectedPotion);
                modifiedStack = potionStack;
            }
        }
        return modifiedStack;
    }

    private ItemStack processEnchantments(ItemStack stack) {
        ItemStack enchantedStack = stack.m_41777_();
        if (this.enchantments != null) {
            for (int i = 0; i < this.enchantments.length; ++i) {
                if (this.enchantments[i].enchantmentKey.equalsIgnoreCase("random")) {
                    ArrayList<Enchantment> availableEnchantments = new ArrayList<Enchantment>();
                    for (Enchantment e : ForgeRegistries.ENCHANTMENTS.getValues()) {
                        boolean isBlacklisted = false;
                        if (stack.m_41720_().getRegistryName().toString().equalsIgnoreCase("minecraft:enchanted_book")) {
                            if (this.blacklistedEnchantments != null) {
                                for (String blacklisted : this.blacklistedEnchantments) {
                                    if (!e.getRegistryName().toString().equalsIgnoreCase(blacklisted)) continue;
                                    isBlacklisted = true;
                                }
                            }
                            if (isBlacklisted) continue;
                            availableEnchantments.add(e);
                            continue;
                        }
                        if (!e.canApplyAtEnchantingTable(enchantedStack)) continue;
                        if (this.blacklistedEnchantments != null) {
                            for (String blacklisted : this.blacklistedEnchantments) {
                                if (!e.getRegistryName().toString().equalsIgnoreCase(blacklisted)) continue;
                                isBlacklisted = true;
                            }
                        }
                        if (isBlacklisted) continue;
                        availableEnchantments.add(e);
                    }
                    this.addEnchantmentMyWay(enchantedStack, (Enchantment)availableEnchantments.get(TradeUtil.random.nextInt(availableEnchantments.size())), this.enchantments[i].enchantmentLevel, this.enchantments[i].maxEnchantmentLevel);
                    continue;
                }
                if (this.enchantments[i].enchantmentKey.contains("#")) {
                    String[] enchantmentChoices = this.enchantments[i].enchantmentKey.split("#");
                    String chosenKey = enchantmentChoices[TradeUtil.random.nextInt(enchantmentChoices.length)];
                    this.addEnchantmentMyWay(enchantedStack, (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(TradeUtil.getResourceLocation(chosenKey)), this.enchantments[i].enchantmentLevel, this.enchantments[i].maxEnchantmentLevel);
                    continue;
                }
                this.addEnchantmentMyWay(enchantedStack, this.enchantments[i].getEnchantment(), this.enchantments[i].enchantmentLevel, this.enchantments[i].maxEnchantmentLevel);
            }
        }
        if (this.semiRandomEnchantments != null) {
            int randomInt = TradeUtil.random.nextInt(this.semiRandomEnchantments.length);
            this.addEnchantmentMyWay(enchantedStack, this.semiRandomEnchantments[randomInt].getEnchantment(), this.semiRandomEnchantments[randomInt].enchantmentLevel, this.semiRandomEnchantments[randomInt].maxEnchantmentLevel);
        }
        return enchantedStack;
    }

    private ItemStack processNBTData(ItemStack stack) {
        ItemStack nbtStack = stack.m_41777_();
        if (this.nbtTags != null) {
            for (NBTData nbt : this.nbtTags) {
                nbtStack.m_41784_().m_128391_(nbt.getTag());
            }
        }
        return nbtStack;
    }

    private ItemStack processEffects(ItemStack stack, Entity entity) {
        ItemStack effectStack = stack.m_41777_();
        if (this.effects != null) {
            ArrayList<MobEffectInstance> effectsToApply = new ArrayList<MobEffectInstance>();
            for (int i = 0; i < this.effects.length; ++i) {
                if (this.effects[i].effectKey.equalsIgnoreCase("random")) {
                    ArrayList<MobEffectInstance> availableRandomEffects = new ArrayList<MobEffectInstance>();
                    for (MobEffect e : ForgeRegistries.MOB_EFFECTS.getValues()) {
                        boolean isBlacklisted = false;
                        if (this.blacklistedEffects != null) {
                            for (String blacklisted : this.blacklistedEffects) {
                                if (!e.getRegistryName().toString().equalsIgnoreCase(blacklisted)) continue;
                                isBlacklisted = true;
                            }
                        }
                        if (isBlacklisted) continue;
                        availableRandomEffects.add(this.effects[i].getInstance(e.getRegistryName().toString()));
                    }
                    effectsToApply.add(new MobEffectInstance((MobEffectInstance)availableRandomEffects.get(TradeUtil.random.nextInt(availableRandomEffects.size()))));
                    continue;
                }
                if (this.effects[i].effectKey.contains("#")) {
                    String[] effectChoices = this.effects[i].effectKey.split("#");
                    String chosenKey = effectChoices[TradeUtil.random.nextInt(effectChoices.length)];
                    effectsToApply.add(this.effects[i].getInstance(chosenKey));
                    continue;
                }
                effectsToApply.add(this.effects[i].getInstance());
            }
            PotionUtils.m_43552_((ItemStack)effectStack, effectsToApply);
            if (this.itemKey.equalsIgnoreCase("minecraft:suspicious_stew")) {
                for (MobEffectInstance e : effectsToApply) {
                    SuspiciousStewItem.m_43258_((ItemStack)effectStack, (MobEffect)e.m_19544_(), (int)e.m_19557_());
                }
            }
        }
        return effectStack;
    }

    private ItemStack addEnchantmentMyWay(ItemStack stack, Enchantment enchantment, int level, int maxLevel) {
        int chosenLevel = level;
        if (level < 0) {
            chosenLevel = TradeUtil.random.nextInt(maxLevel) + 1;
        }
        if (stack.m_41720_() == Items.f_42690_) {
            EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(enchantment, chosenLevel));
        } else {
            stack.m_41663_(enchantment, chosenLevel);
        }
        return stack;
    }
}

