/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.configs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import uk.co.dotcode.customvillagertrades.CustomTradeConfigOld;
import uk.co.dotcode.customvillagertrades.TradeUtil;
import uk.co.dotcode.customvillagertrades.configs.MyTrade;
import uk.co.dotcode.customvillagertrades.configs.MyTradeEnchantment;
import uk.co.dotcode.customvillagertrades.configs.MyTradeItem;
import uk.co.dotcode.customvillagertrades.configs.TradeCollection;
import uk.co.dotcode.customvillagertrades.configs.WandererTradeCollection;

public class TradeHandler {
    public static File folder = FMLPaths.CONFIGDIR.get().resolve("custom trades").toFile();
    public static File folderWanderer = FMLPaths.CONFIGDIR.get().resolve("custom trades/wanderer").toFile();
    public static File fileOld = FMLPaths.CONFIGDIR.get().resolve("customvillagertrades-common.toml").toFile();
    public static HashMap<String, TradeCollection> customTrades = new HashMap();
    public static HashMap<String, WandererTradeCollection> customWandererTrades = new HashMap();

    public static void init() {
        if (!folder.exists()) {
            folder.mkdir();
            LogManager.getLogger((String)"customvillagertrades").log(Level.INFO, "No config found, creating");
            if (fileOld.exists()) {
                LogManager.getLogger((String)"customvillagertrades").log(Level.INFO, "Found old config, porting to new config layouts");
                TradeHandler.portOldConfig();
            }
        }
        File[] fileArray = folder.listFiles();
        if (!folderWanderer.exists()) {
            folderWanderer.mkdir();
        }
        File[] fileArrayWanderer = folderWanderer.listFiles();
        if (fileArray == null || fileArray.length < 1) {
            TradeHandler.generateExampleTrade();
        } else {
            Gson gson = new Gson();
            for (File f : fileArray) {
                if (f.isDirectory() || !TradeUtil.isJsonFile(f)) continue;
                TradeHandler.loadFile(gson, f, false);
            }
            for (File f : fileArrayWanderer) {
                if (f.isDirectory() || !TradeUtil.isJsonFile(f)) continue;
                TradeHandler.loadFile(gson, f, true);
            }
        }
    }

    private static void loadFile(Gson gson, File f, boolean isWanderer) {
        String profession = FilenameUtils.removeExtension((String)f.getName());
        LogManager.getLogger((String)"customvillagertrades").log(Level.INFO, "Loading custom villager trades for: " + profession);
        try (FileReader reader = new FileReader(f);){
            if (isWanderer) {
                WandererTradeCollection wandererTradeCollection = (WandererTradeCollection)gson.fromJson((Reader)reader, WandererTradeCollection.class);
                customWandererTrades.put(profession, wandererTradeCollection);
            } else {
                TradeCollection tradeCollection = (TradeCollection)gson.fromJson((Reader)reader, TradeCollection.class);
                customTrades.put(profession, tradeCollection);
            }
        }
        catch (IOException e) {
            LogManager.getLogger((String)"customvillagertrades").log(Level.ERROR, "A problem has been found with the config file for '" + profession + "'! This is most likely an issue where the file can not be found/accessed (which should never happen...)");
            e.printStackTrace();
        }
        catch (JsonSyntaxException e) {
            LogManager.getLogger((String)"customvillagertrades").log(Level.ERROR, "A problem has been found with the config file for '" + profession + "'! This is most likely a formatting issue - take a look over the config for anything that seems out of place (and use a JSON verifier) - Everything needs to match the specification in the mod description.");
        }
        if (isWanderer) {
            for (Map.Entry<String, Object> entry : customWandererTrades.entrySet()) {
                TradeUtil.checkTradeCollection((WandererTradeCollection)entry.getValue());
            }
        } else {
            for (Map.Entry<String, Object> entry : customTrades.entrySet()) {
                TradeUtil.checkTradeCollection((TradeCollection)entry.getValue());
            }
        }
    }

    public static TradeCollection loadTrades(String profession) {
        return customTrades.get(profession);
    }

    public static WandererTradeCollection loadWandererTrades(String profession) {
        return customWandererTrades.get(profession);
    }

    private static void portOldConfig() {
        LogManager.getLogger((String)"customvillagertrades").log(Level.INFO, "Checking old custom villager trades");
        if (((List)CustomTradeConfigOld.allVillagerTrades.get()).size() > 0) {
            ArrayList<MyTrade> allVillagerTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.allVillagerTrades.get());
            TradeHandler.saveOldToNewFile(allVillagerTrades, "all");
        }
        if (((List)CustomTradeConfigOld.armorerTrades.get()).size() > 0) {
            ArrayList<MyTrade> armorerTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.armorerTrades.get());
            TradeHandler.saveOldToNewFile(armorerTrades, VillagerProfession.f_35586_.toString());
        }
        if (((List)CustomTradeConfigOld.butcherTrades.get()).size() > 0) {
            ArrayList<MyTrade> butcherTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.butcherTrades.get());
            TradeHandler.saveOldToNewFile(butcherTrades, VillagerProfession.f_35587_.toString());
        }
        if (((List)CustomTradeConfigOld.cartographerTrades.get()).size() > 0) {
            ArrayList<MyTrade> cartographerTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.cartographerTrades.get());
            TradeHandler.saveOldToNewFile(cartographerTrades, VillagerProfession.f_35588_.toString());
        }
        if (((List)CustomTradeConfigOld.clericTrades.get()).size() > 0) {
            ArrayList<MyTrade> clericTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.clericTrades.get());
            TradeHandler.saveOldToNewFile(clericTrades, VillagerProfession.f_35589_.toString());
        }
        if (((List)CustomTradeConfigOld.farmerTrades.get()).size() > 0) {
            ArrayList<MyTrade> farmerTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.farmerTrades.get());
            TradeHandler.saveOldToNewFile(farmerTrades, VillagerProfession.f_35590_.toString());
        }
        if (((List)CustomTradeConfigOld.fishermanTrades.get()).size() > 0) {
            ArrayList<MyTrade> fishermanTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.fishermanTrades.get());
            TradeHandler.saveOldToNewFile(fishermanTrades, VillagerProfession.f_35591_.toString());
        }
        if (((List)CustomTradeConfigOld.fletcherTrades.get()).size() > 0) {
            ArrayList<MyTrade> fletcherTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.fletcherTrades.get());
            TradeHandler.saveOldToNewFile(fletcherTrades, VillagerProfession.f_35592_.toString());
        }
        if (((List)CustomTradeConfigOld.leatherworkerTrades.get()).size() > 0) {
            ArrayList<MyTrade> leatherworkerTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.leatherworkerTrades.get());
            TradeHandler.saveOldToNewFile(leatherworkerTrades, VillagerProfession.f_35593_.toString());
        }
        if (((List)CustomTradeConfigOld.librarianTrades.get()).size() > 0) {
            ArrayList<MyTrade> librarianTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.librarianTrades.get());
            TradeHandler.saveOldToNewFile(librarianTrades, VillagerProfession.f_35594_.toString());
        }
        if (((List)CustomTradeConfigOld.masonTrades.get()).size() > 0) {
            ArrayList<MyTrade> masonTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.masonTrades.get());
            TradeHandler.saveOldToNewFile(masonTrades, VillagerProfession.f_35595_.toString());
        }
        if (((List)CustomTradeConfigOld.nitwitTrades.get()).size() > 0) {
            ArrayList<MyTrade> nitwitTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.nitwitTrades.get());
            TradeHandler.saveOldToNewFile(nitwitTrades, VillagerProfession.f_35596_.toString());
        }
        if (((List)CustomTradeConfigOld.shepherdTrades.get()).size() > 0) {
            ArrayList<MyTrade> shepherdTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.shepherdTrades.get());
            TradeHandler.saveOldToNewFile(shepherdTrades, VillagerProfession.f_35597_.toString());
        }
        if (((List)CustomTradeConfigOld.toolsmithTrades.get()).size() > 0) {
            ArrayList<MyTrade> toolsmithTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.toolsmithTrades.get());
            TradeHandler.saveOldToNewFile(toolsmithTrades, VillagerProfession.f_35598_.toString());
        }
        if (((List)CustomTradeConfigOld.weaponsmithTrades.get()).size() > 0) {
            ArrayList<MyTrade> weaponsmithTrades = TradeUtil.convertOldTrades((List)CustomTradeConfigOld.weaponsmithTrades.get());
            TradeHandler.saveOldToNewFile(weaponsmithTrades, VillagerProfession.f_35599_.toString());
        }
        LogManager.getLogger((String)"customvillagertrades").log(Level.INFO, "Old config has been converted to new configs.");
    }

    private static void saveOldToNewFile(ArrayList<MyTrade> trades, String profession) {
        TradeCollection collection = new TradeCollection();
        MyTrade[] tradeList = (MyTrade[])Arrays.copyOf(trades.toArray(), trades.size(), MyTrade[].class);
        collection.profession = profession;
        collection.trades = tradeList;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File exportPath = new File(folder, collection.profession + ".json");
        try (FileWriter writer = new FileWriter(exportPath);){
            gson.toJson((Object)collection, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void generateExampleTrade() {
        TradeCollection exampleTrades = new TradeCollection();
        MyTrade exampleOne = new MyTrade();
        exampleOne.offer = new MyTradeItem("minecraft:dirt", 3, 0);
        exampleOne.offer.enchantments = new MyTradeEnchantment[2];
        exampleOne.offer.enchantments[0] = new MyTradeEnchantment("minecraft:knockback", 2);
        exampleOne.offer.enchantments[1] = new MyTradeEnchantment("minecraft:sharpness", -1, 5);
        exampleOne.request = new MyTradeItem("minecraft:cobblestone", 1, 0);
        exampleOne.tradeExp = 3;
        exampleOne.maxUses = 10;
        exampleOne.priceMultiplier = 0.1f;
        exampleOne.tradeLevel = 1;
        MyTrade exampleTwo = new MyTrade();
        exampleTwo.offer = new MyTradeItem("minecraft:emerald", 2, 0);
        exampleTwo.request = new MyTradeItem("minecraft:iron_ingot", 2, 0);
        exampleTwo.additionalRequest = new MyTradeItem("minecraft:gold_ingot", 1, 0);
        exampleTwo.tradeExp = 6;
        exampleTwo.maxUses = 10;
        exampleTwo.priceMultiplier = 0.1f;
        exampleTwo.tradeLevel = 2;
        MyTrade exampleThree = new MyTrade();
        exampleThree.multiOffer = new MyTradeItem[3];
        exampleThree.multiOffer[0] = new MyTradeItem("minecraft:iron_axe", 1, -3);
        exampleThree.multiOffer[1] = new MyTradeItem("minecraft:golden_axe", 1, 0);
        exampleThree.multiOffer[2] = new MyTradeItem("minecraft:diamond_axe", 1, 4);
        exampleThree.request = new MyTradeItem("minecraft:iron_ingot", 6, 0);
        exampleThree.tradeExp = 15;
        exampleThree.maxUses = 5;
        exampleThree.priceMultiplier = 0.1f;
        exampleThree.tradeLevel = 3;
        MyTrade exampleFour = new MyTrade();
        exampleFour.offer = new MyTradeItem("minecraft:wooden_sword", 1, 0);
        exampleFour.offer.semiRandomEnchantments = new MyTradeEnchantment[3];
        exampleFour.offer.semiRandomEnchantments[0] = new MyTradeEnchantment("minecraft:mending", 1);
        exampleFour.offer.semiRandomEnchantments[1] = new MyTradeEnchantment("minecraft:looting", 3);
        exampleFour.offer.semiRandomEnchantments[2] = new MyTradeEnchantment("minecraft:sweeping", 2);
        exampleFour.request = new MyTradeItem("minecraft:quartz", 5, 0);
        exampleFour.tradeExp = 20;
        exampleFour.maxUses = 5;
        exampleFour.priceMultiplier = 0.0f;
        exampleFour.tradeLevel = 4;
        MyTrade exampleFive = new MyTrade();
        exampleFive.offer = new MyTradeItem("minecraft:enchanted_book", 1, 0);
        exampleFive.offer.enchantments = new MyTradeEnchantment[1];
        exampleFive.offer.enchantments[0] = new MyTradeEnchantment("random", 2);
        exampleFive.offer.blacklistedEnchantments = new String[2];
        exampleFive.offer.blacklistedEnchantments[0] = "minecraft:protection";
        exampleFive.offer.blacklistedEnchantments[1] = "minecraft:fire_protection";
        exampleFive.request = new MyTradeItem("minecraft:emerald", 3, 0);
        exampleFive.tradeExp = 3;
        exampleFive.maxUses = 10;
        exampleFive.priceMultiplier = 0.1f;
        exampleFive.tradeLevel = 1;
        MyTrade[] exampleTradeList = new MyTrade[]{exampleOne, exampleTwo, exampleThree, exampleFour, exampleFive};
        exampleTrades.profession = VillagerProfession.f_35586_.toString();
        exampleTrades.trades = exampleTradeList;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File exportPath = new File(folder, exampleTrades.profession + ".json");
        try (FileWriter writer = new FileWriter(exportPath);){
            gson.toJson((Object)exampleTrades, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

