/*
 * Decompiled with CFR 0.152.
 */
package uk.co.dotcode.customvillagertrades.packet;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraftforge.fmllegacy.network.NetworkDirection;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.fmllegacy.network.NetworkRegistry;
import net.minecraftforge.fmllegacy.network.simple.SimpleChannel;
import uk.co.dotcode.customvillagertrades.packet.SendVillagerLevelUpdatePacket;

public class PacketHandler {
    public static int index = 0;
    private static final String PROTOCOL_VERSION = "1";
    private static final SimpleChannel HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("customvillagertrades", "main_channel")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();

    public static void register() {
        HANDLER.registerMessage(index++, SendVillagerLevelUpdatePacket.class, SendVillagerLevelUpdatePacket::encode, SendVillagerLevelUpdatePacket::new, PacketHandler::handleVillagerLevelUpdate);
    }

    public static void sendToClient(Object message, ServerPlayer player) {
        HANDLER.sendTo(message, player.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sendToServer(Object message) {
        HANDLER.sendToServer(message);
    }

    public static void handleVillagerLevelUpdate(SendVillagerLevelUpdatePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                UUID uuid = message.uuid;
                Entity e = ((NetworkEvent.Context)ctx.get()).getSender().m_9236_().m_8791_(uuid);
                if (e != null && e instanceof Villager) {
                    Villager v = (Villager)e;
                    int data = message.data;
                    v.m_35546_(PacketHandler.getXpToSet(v.m_7141_().m_35576_() + data));
                    v.m_6996_((MerchantOffer)v.m_6616_().get(0));
                }
            });
        } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            // empty if block
        }
        ctx.get().setPacketHandled(true);
    }

    private static int getXpToSet(int targetLevel) {
        switch (targetLevel) {
            case 1: {
                return 0;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 71;
            }
            case 4: {
                return 151;
            }
            case 5: {
                return 251;
            }
        }
        return 0;
    }
}

