/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui;

import flaxbeard.cyberware.client.gui.ContainerScanner;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.block.tile.TileEntityScanner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiScanner
extends GuiContainer {
    private static final ResourceLocation SCANNER_TEXTURES = new ResourceLocation("cyberware:textures/gui/scanner.png");
    private InventoryPlayer playerInventory;
    private TileEntityScanner scanner;
    private static final String[] dots = new String[]{"", ".", "..", "...", "....", "....."};
    int messageNum = -1;
    boolean resetLast = false;
    private static Map<String, Integer> langMax = new HashMap<String, Integer>();

    public GuiScanner(InventoryPlayer playerInv, TileEntityScanner engineering) {
        super((Container)new ContainerScanner(playerInv, engineering));
        this.playerInventory = playerInv;
        this.scanner = engineering;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(this.playerInventory.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (!this.scanner.slots.getStackInSlot(0).func_190926_b() && this.scanner.slots.getStackInSlot(0).func_190916_E() > 0 && (this.scanner.slots.getStackInSlot(2).func_190926_b() || this.scanner.slots.getStackInSlot(2).func_190916_E() == 0)) {
            int maxMessage = this.getMaxMessage(this.field_146297_k.field_71474_y.field_74363_ab);
            GuiScanner guiScanner = this;
            int ticks = guiScanner.field_146297_k.func_71410_x().field_71439_g.field_70173_aa / 10;
            int dotsNum = ticks % 6;
            if (dotsNum == 0 && !this.resetLast || this.messageNum == -1 || this.messageNum >= maxMessage) {
                if (dotsNum == 0) {
                    this.resetLast = true;
                }
                GuiScanner guiScanner2 = this;
                this.messageNum = guiScanner2.field_146297_k.func_71410_x().field_71441_e.field_73012_v.nextInt(maxMessage);
            }
            if (dotsNum != 0) {
                this.resetLast = false;
            }
            String baseMessage = I18n.func_135052_a((String)("cyberware.gui.scanner_saying." + this.messageNum), (Object[])new Object[0]);
            String message = baseMessage + dots[dotsNum];
            this.field_146289_q.func_78276_b(message, 6, 20, 2059644);
        }
        String s = this.scanner.func_145748_c_().func_150260_c();
        this.field_146289_q.func_78276_b(s, 6, 7, 1944001);
        float chance = 0.0f;
        if (!this.scanner.slots.getStackInSlot(0).func_190926_b()) {
            chance = CyberwareConfig.SCANNER_CHANCE + CyberwareConfig.SCANNER_CHANCE_ADDL * (float)(this.scanner.slots.getStackInSlot(0).func_190916_E() - 1);
            if (this.scanner.slots.getStackInSlot(0).func_77984_f()) {
                chance = 50.0f * (1.0f - (float)this.scanner.slots.getStackInSlot(0).func_77952_i() * 1.0f / (float)this.scanner.slots.getStackInSlot(0).func_77958_k());
            }
            chance = Math.min(chance, 50.0f);
        }
        String num = Float.toString((float)Math.round(chance * 100.0f) / 100.0f) + "%";
        s = I18n.func_135052_a((String)"cyberware.gui.percent", (Object[])new Object[]{num});
        this.field_146289_q.func_78276_b(s, this.field_146999_f - 6 - this.field_146289_q.func_78256_a(s), 7, 1944001);
        int progress = (int)Math.ceil(this.scanner.getProgress() * 162.0f);
        this.field_146297_k.func_110434_K().func_110577_a(SCANNER_TEXTURES);
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
        this.func_73729_b(5, 32, 0, 175, progress, 9);
        this.func_73729_b(5 + progress, 32, 0 + progress, 166, 162 - progress, 9);
        GlStateManager.func_179084_k();
        if (this.func_146978_c(35, 53, 16, 16, mouseX, mouseY) && this.scanner.slots.getStackInSlot(0).func_190926_b()) {
            this.drawHoveringText(Arrays.asList(I18n.func_135052_a((String)"cyberware.gui.to_scan", (Object[])new Object[0])), mouseX - i, mouseY - j, this.field_146289_q);
        }
        if (this.func_146978_c(15, 53, 16, 16, mouseX, mouseY) && this.scanner.slots.getStackInSlot(1).func_190926_b()) {
            this.drawHoveringText(Arrays.asList(I18n.func_135052_a((String)"cyberware.gui.paper", (Object[])new Object[0])), mouseX - i, mouseY - j, this.field_146289_q);
        }
        if (this.scanner.ticks > 0 && this.func_146978_c(5, 32, 162, 9, mouseX, mouseY)) {
            int ticksLeft = CyberwareConfig.SCANNER_TIME - this.scanner.ticks;
            int seconds = ticksLeft % 1200 / 20;
            int minutes = ticksLeft / 1200;
            this.drawHoveringText(Arrays.asList(I18n.func_135052_a((String)"cyberware.gui.time_left", (Object[])new Object[]{minutes, seconds})), mouseX - i, mouseY - j, this.field_146289_q);
        }
    }

    private int getMaxMessage(String language) {
        if (langMax.containsKey(language)) {
            return langMax.get(language);
        }
        int count = Integer.parseInt(I18n.func_135052_a((String)"cyberware.gui.scanner_saying.count", (Object[])new Object[0])) - 1;
        langMax.put(language, count);
        return count;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(SCANNER_TEXTURES);
        int i = (this.field_146294_l - this.field_146999_f) / 2;
        int j = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

