/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.client.ClientUtils;
import flaxbeard.cyberware.client.gui.ContainerSurgery;
import flaxbeard.cyberware.client.render.ModelBox;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.block.tile.TileEntitySurgery;
import flaxbeard.cyberware.common.misc.NNLUtil;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.SurgeryRemovePacket;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiSurgery
extends GuiContainer {
    private static final ResourceLocation SURGERY_GUI_TEXTURES = new ResourceLocation("cyberware:textures/gui/surgery.png");
    private static final ResourceLocation GREY_TEXTURE = new ResourceLocation("cyberware:textures/gui/greypx.png");
    private static final ResourceLocation BLUE_TEXTURE = new ResourceLocation("cyberware:textures/gui/bluepx.png");
    private final TileEntitySurgery surgery;
    private Entity skeleton;
    private ModelBox box;
    private float partialTicks;
    private GuiButtonSurgery[] bodyIcons = new GuiButtonSurgery[7];
    private InterfaceButton back;
    private InterfaceButton index;
    private GuiButtonSurgeryLocation[] headIcons = new GuiButtonSurgeryLocation[3];
    private GuiButtonSurgeryLocation[] torsoIcons = new GuiButtonSurgeryLocation[4];
    private GuiButtonSurgeryLocation[] crossSectionIcons = new GuiButtonSurgeryLocation[3];
    private GuiButtonSurgeryLocation[] armIcons = new GuiButtonSurgeryLocation[2];
    private GuiButtonSurgeryLocation[] legIcons = new GuiButtonSurgeryLocation[2];
    private PageConfiguration current;
    private PageConfiguration target;
    private PageConfiguration ease;
    private NonNullList<ItemStack> indexStacks;
    private int[] indexPages;
    private int[] indexNews;
    private int indexCount;
    private float lastTicks;
    private float addedRotate;
    private float oldRotate;
    private float transitionStart = 0.0f;
    private float operationTime = 0.0f;
    private float amountDone = 1.0f;
    private float openTime = 0.0f;
    private int page = 0;
    private boolean mouseDown;
    private int mouseDownX;
    private float[] lastDownX = new float[5];
    private float rotateVelocity = 0.0f;
    private PageConfiguration[] configs = new PageConfiguration[25];
    List<ContainerSurgery.SlotSurgery> visibleSlots = new ArrayList<ContainerSurgery.SlotSurgery>();
    private int parent;
    private static ItemStackHandler lastLastInv = new ItemStackHandler(120);
    private static ItemStackHandler lastInv = new ItemStackHandler(120);

    public GuiSurgery(InventoryPlayer inventoryPlayer, TileEntitySurgery surgery) {
        super((Container)new ContainerSurgery(inventoryPlayer, surgery));
        this.surgery = surgery;
        this.field_147000_g = 222;
        this.configs[0] = new PageConfiguration(0.0f, 0.0f, 0.0f, 50.0f, 35.0f, 35.0f, -50.0f, 10.0f);
        this.configs[1] = new PageConfiguration(50.0f, 0.0f, 210.0f, 150.0f, 0.0f, 0.0f, -150.0f, 0.0f);
        this.configs[2] = new PageConfiguration(15.0f, 0.0f, 100.0f, 130.0f, 0.0f, 0.0f, -150.0f, 0.0f);
        this.configs[3] = new PageConfiguration(-50.0f, 0.0f, 100.0f, 130.0f, 0.0f, 0.0f, -150.0f, 0.0f);
        this.configs[4] = new PageConfiguration(50.0f, 0.0f, 100.0f, 130.0f, 0.0f, 0.0f, -150.0f, 0.0f);
        this.configs[5] = new PageConfiguration(-70.0f, 0.0f, 10.0f, 130.0f, 0.0f, 0.0f, -150.0f, 0.0f);
        this.configs[6] = new PageConfiguration(70.0f, 0.0f, 10.0f, 130.0f, 0.0f, 0.0f, -150.0f, 0.0f);
        this.configs[7] = new PageConfiguration(0.0f, 0.0f, 0.0f, 50.0f, 170.0f, 125.0f, 0.0f, 0.0f);
        this.configs[11] = new PageConfiguration(160.0f, 0.0f, 300.0f, 200.0f);
        this.configs[12] = new PageConfiguration(5.0f, 0.0f, 330.0f, 220.0f);
        this.configs[13] = new PageConfiguration(5.0f, 0.0f, 330.0f, 220.0f);
        this.configs[14] = new PageConfiguration(-20.0f, 0.0f, 220.0f, 210.0f);
        this.configs[15] = new PageConfiguration(0.0f, 0.0f, 180.0f, 180.0f);
        this.configs[16] = new PageConfiguration(0.0f, 0.0f, 180.0f, 180.0f);
        this.configs[17] = new PageConfiguration(0.0f, 0.0f, 125.0f, 180.0f);
        this.configs[18] = new PageConfiguration(0.0f, 0.0f, 0.0f, 50.0f, 190.0f, 180.0f, 0.0f, 0.0f);
        this.configs[19] = new PageConfiguration(0.0f, 0.0f, 0.0f, 50.0f, 170.0f, 180.0f, 0.0f, 0.0f);
        this.configs[20] = new PageConfiguration(0.0f, 0.0f, 0.0f, 50.0f, 170.0f, 180.0f, 0.0f, 0.0f);
        this.configs[21] = new PageConfiguration(-70.0f, 0.0f, 180.0f, 200.0f);
        this.configs[22] = new PageConfiguration(-70.0f, 0.0f, 120.0f, 220.0f);
        this.configs[23] = new PageConfiguration(10.0f, 0.0f, 20.0f, 200.0f);
        this.configs[24] = new PageConfiguration(10.0f, 0.0f, -30.0f, 220.0f);
        this.ease = this.target = this.configs[0].copy();
        this.current = this.target;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int xLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int yTop = (this.field_146295_m - this.field_147000_g) / 2;
        this.bodyIcons[0] = new GuiButtonSurgery(1, xLeft + this.field_146999_f / 2 - 18, yTop + 8, 36, 27);
        this.field_146292_n.add(this.bodyIcons[0]);
        this.bodyIcons[1] = new GuiButtonSurgery(2, xLeft + this.field_146999_f / 2 - 13, yTop + 35, 26, 38);
        this.field_146292_n.add(this.bodyIcons[1]);
        this.bodyIcons[2] = new GuiButtonSurgery(3, xLeft + this.field_146999_f / 2 - 8 + 21, yTop + 35, 16, 38);
        this.field_146292_n.add(this.bodyIcons[2]);
        this.bodyIcons[3] = new GuiButtonSurgery(4, xLeft + this.field_146999_f / 2 - 8 - 21, yTop + 35, 16, 38);
        this.field_146292_n.add(this.bodyIcons[3]);
        this.bodyIcons[4] = new GuiButtonSurgery(5, xLeft + this.field_146999_f / 2 - 6 + 7, yTop + 73, 12, 39);
        this.field_146292_n.add(this.bodyIcons[4]);
        this.bodyIcons[5] = new GuiButtonSurgery(6, xLeft + this.field_146999_f / 2 - 6 - 7, yTop + 73, 12, 39);
        this.field_146292_n.add(this.bodyIcons[5]);
        this.back = new InterfaceButton(8, xLeft + this.field_146999_f - 25, yTop + 5, Type.BACK);
        this.field_146292_n.add(this.back);
        this.index = new InterfaceButton(9, xLeft + this.field_146999_f - 22, yTop + 5, Type.INDEX);
        this.field_146292_n.add(this.index);
        this.back.field_146125_m = false;
        this.bodyIcons[6] = new GuiButtonSurgery(7, xLeft + (int)((float)(this.field_146999_f / 2) + this.configs[0].boxX - this.configs[0].boxWidth / 2.0f), yTop + (int)(65.5f + this.configs[0].boxY - this.configs[0].boxHeight / 2.0f), (int)this.configs[0].boxWidth, (int)this.configs[0].boxHeight);
        this.field_146292_n.add(this.bodyIcons[6]);
        this.headIcons[0] = new GuiButtonSurgeryLocation(11, -2.0f, 19.0f, 0.0f);
        this.field_146292_n.add(this.headIcons[0]);
        this.headIcons[1] = new GuiButtonSurgeryLocation(12, 4.0f, 21.0f, 2.0f);
        this.field_146292_n.add(this.headIcons[1]);
        this.headIcons[2] = new GuiButtonSurgeryLocation(13, 4.0f, 21.0f, -2.0f);
        this.field_146292_n.add(this.headIcons[2]);
        this.torsoIcons[0] = new GuiButtonSurgeryLocation(14, 1.0f, 8.0f, -1.0f);
        this.field_146292_n.add(this.torsoIcons[0]);
        this.torsoIcons[1] = new GuiButtonSurgeryLocation(15, 0.0f, 9.0f, -2.0f);
        this.field_146292_n.add(this.torsoIcons[1]);
        this.torsoIcons[2] = new GuiButtonSurgeryLocation(16, 0.0f, 9.0f, 2.0f);
        this.field_146292_n.add(this.torsoIcons[2]);
        this.torsoIcons[3] = new GuiButtonSurgeryLocation(17, 0.0f, 13.0f, 0.0f);
        this.field_146292_n.add(this.torsoIcons[3]);
        this.crossSectionIcons[0] = new GuiButtonSurgeryLocation(18, -12.0f, -8.0f, -1.0f);
        this.field_146292_n.add(this.crossSectionIcons[0]);
        this.crossSectionIcons[1] = new GuiButtonSurgeryLocation(19, 12.0f, -1.0f, 2.0f);
        this.field_146292_n.add(this.crossSectionIcons[1]);
        this.crossSectionIcons[2] = new GuiButtonSurgeryLocation(20, 3.0f, 5.0f, 12.0f);
        this.field_146292_n.add(this.crossSectionIcons[2]);
        this.armIcons[0] = new GuiButtonSurgeryLocation(21, 0.0f, 10.0f, -5.3f);
        this.field_146292_n.add(this.armIcons[0]);
        this.armIcons[1] = new GuiButtonSurgeryLocation(22, 0.0f, 16.0f, -6.0f);
        this.field_146292_n.add(this.armIcons[1]);
        this.legIcons[0] = new GuiButtonSurgeryLocation(23, 0.0f, 1.0f, -2.2f);
        this.field_146292_n.add(this.legIcons[0]);
        this.legIcons[1] = new GuiButtonSurgeryLocation(24, 0.0f, 6.4f, -2.2f);
        this.field_146292_n.add(this.legIcons[1]);
        this.updateSurgerySlotsVisibility(true);
    }

    private void prepTransition(int time, int targetPage) {
        if (this.page == this.index.field_146127_k) {
            if (targetPage == 0) {
                this.back.field_146125_m = false;
                this.page = 0;
                this.showHideRelevantButtons(true);
                this.ease = this.current = this.configs[0].copy();
                return;
            }
            if (targetPage >= 18 && targetPage <= 20) {
                this.ease = this.current = this.configs[targetPage].copy();
                this.page = targetPage;
                this.showHideRelevantButtons(true);
                return;
            }
            if (time == 0) {
                this.ease = this.current = this.configs[targetPage].copy();
                this.page = targetPage;
                this.showHideRelevantButtons(true);
                return;
            }
            this.ease = this.current = this.configs[0].copy();
        }
        if (targetPage == this.index.field_146127_k) {
            this.showHideRelevantButtons(false);
            this.page = 9;
            this.parent = 0;
            this.back.field_146125_m = true;
            this.index.field_146125_m = false;
            this.indexStacks = NNLUtil.initListOfSize(40);
            this.indexPages = new int[40];
            this.indexNews = new int[40];
            this.indexCount = 0;
            for (int indexSurgeySlot = 0; indexSurgeySlot < this.surgery.slots.getSlots() && this.indexCount < this.indexStacks.size(); ++indexSurgeySlot) {
                ICyberware.EnumSlot slot;
                ItemStack playerStack = this.surgery.slotsPlayer.getStackInSlot(indexSurgeySlot);
                ItemStack surgeryStack = this.surgery.slots.getStackInSlot(indexSurgeySlot);
                int nu = 0;
                ItemStack draw = ItemStack.field_190927_a;
                if (!surgeryStack.func_190926_b()) {
                    draw = surgeryStack.func_77946_l();
                    if (!playerStack.func_190926_b()) {
                        if (CyberwareAPI.areCyberwareStacksEqual(playerStack, surgeryStack)) {
                            draw.func_190917_f(playerStack.func_190916_E());
                        } else {
                            this.indexStacks.set(this.indexCount, (Object)playerStack.func_77946_l());
                            slot = ICyberware.EnumSlot.values()[indexSurgeySlot / 10];
                            this.indexPages[this.indexCount] = slot.getSlotNumber();
                            this.indexNews[this.indexCount] = 2;
                            ++this.indexCount;
                            if (this.indexCount >= this.indexStacks.size()) break;
                        }
                    }
                    nu = 1;
                } else if (!playerStack.func_190926_b() && !this.surgery.discardSlots[indexSurgeySlot]) {
                    draw = playerStack.func_77946_l();
                } else if (!playerStack.func_190926_b() && this.surgery.discardSlots[indexSurgeySlot]) {
                    draw = playerStack.func_77946_l();
                    nu = 2;
                }
                if (draw.func_190926_b()) continue;
                this.indexStacks.set(this.indexCount, (Object)draw);
                slot = ICyberware.EnumSlot.values()[indexSurgeySlot / 10];
                this.indexPages[this.indexCount] = slot.getSlotNumber();
                this.indexNews[this.indexCount] = nu;
                ++this.indexCount;
            }
            return;
        }
        this.transitionStart = this.ticksExisted() + this.partialTicks;
        this.current = this.ease;
        this.operationTime = this.amountDone * (float)time;
        this.showHideRelevantButtons(false);
        this.page = targetPage;
        this.target = this.configs[this.page].copy();
        if (this.page == 0) {
            this.back.field_146125_m = false;
        } else {
            this.back.field_146125_m = true;
            this.index.field_146125_m = false;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == this.back.field_146127_k) {
                if (this.page != 0 || this.ease.rotation != 0.0f) {
                    int pageToGoTo = this.page <= 10 ? 0 : this.parent;
                    this.prepTransition(20, pageToGoTo);
                }
                return;
            }
            this.openTime = 1.0f;
            if (button.field_146127_k > 10) {
                this.parent = this.page;
            }
            if (button.field_146127_k == 4) {
                this.prepTransition(20, 3);
            } else if (button.field_146127_k == 6) {
                this.prepTransition(20, 5);
            } else if (button.field_146127_k == 13) {
                this.prepTransition(20, 12);
            } else if (button.field_146127_k == 16) {
                this.prepTransition(20, 15);
            } else {
                this.prepTransition(20, button.field_146127_k);
            }
        }
    }

    private void showHideRelevantButtons(boolean show) {
        GuiButton[] list = new GuiButton[]{};
        switch (this.page) {
            case 0: {
                list = this.bodyIcons;
                break;
            }
            case 1: {
                list = this.headIcons;
                break;
            }
            case 2: {
                list = this.torsoIcons;
                break;
            }
            case 7: {
                list = this.crossSectionIcons;
                break;
            }
            case 5: {
                list = this.legIcons;
                break;
            }
            case 3: {
                list = this.armIcons;
            }
        }
        for (GuiButton guiButton : list) {
            guiButton.field_146125_m = show;
        }
        this.updateSurgerySlotsVisibility(show);
    }

    private void updateLocationButtons(float rot, float scale, float yOffset) {
        if (this.page == 0) {
            this.index.field_146125_m = true;
        }
        int xLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int yTop = (this.field_146295_m - this.field_147000_g) / 2;
        GuiButtonSurgeryLocation[] list = new GuiButtonSurgeryLocation[]{};
        switch (this.page) {
            case 1: {
                list = this.headIcons;
                break;
            }
            case 2: {
                list = this.torsoIcons;
                break;
            }
            case 7: {
                list = this.crossSectionIcons;
                break;
            }
            case 5: {
                list = this.legIcons;
                break;
            }
            case 3: {
                list = this.armIcons;
            }
        }
        if (this.page == 7) {
            rot += this.addedRotate;
        }
        float radRot = (float)Math.toRadians(rot);
        float sin = (float)Math.sin(radRot);
        float cos = -((float)Math.cos(radRot));
        float upDown = this.page == 7 ? (float)Math.sin(Math.toRadians(10.0)) : 0.0f;
        for (GuiButtonSurgeryLocation guiButtonSurgeryLocation : list) {
            guiButtonSurgeryLocation.xPos = (float)xLeft + sin * scale * guiButtonSurgeryLocation.x3 * 0.065f + cos * scale * guiButtonSurgeryLocation.z3 * 0.065f + (float)this.field_146999_f / 2.0f - 2.0f - (float)guiButtonSurgeryLocation.field_146120_f / 2.0f;
            guiButtonSurgeryLocation.yPos = -upDown * cos * scale * guiButtonSurgeryLocation.x3 * 0.065f + upDown * sin * scale * guiButtonSurgeryLocation.z3 * 0.065f + (float)yTop + 2.0f - yOffset + scale * guiButtonSurgeryLocation.y3 * 0.065f + 65.0f - (float)guiButtonSurgeryLocation.field_146121_g / 2.0f;
            guiButtonSurgeryLocation.field_146128_h = Math.round(guiButtonSurgeryLocation.xPos);
            guiButtonSurgeryLocation.field_146129_i = Math.round(guiButtonSurgeryLocation.yPos);
        }
    }

    private void drawSlots() {
        int criticalEssence;
        int xLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int yTop = (this.field_146295_m - this.field_147000_g) / 2;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        int essence = (int)((float)this.surgery.essence * 1.0f / (float)this.surgery.maxEssence * 49.0f);
        int warningEssence = criticalEssence = (int)((float)CyberwareConfig.CRITICAL_ESSENCE * 1.0f / (float)this.surgery.maxEssence * 49.0f);
        this.field_73735_i = 200.0f;
        this.field_146297_k.func_110434_K().func_110577_a(SURGERY_GUI_TEXTURES);
        if (this.surgery.wrongSlot != -1) {
            float trans = 1.0f - (this.ticksExisted() + this.partialTicks - (float)this.surgery.ticksWrong) / 10.0f;
            if (trans > 0.0f) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)trans);
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(this.surgery.wrongSlot);
                this.func_73729_b(xLeft + slot.field_75223_e - 5, yTop + slot.field_75221_f - 5, 185, 61, 26, 26);
            } else {
                this.surgery.wrongSlot = -1;
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        for (ContainerSurgery.SlotSurgery pos : this.visibleSlots) {
            this.func_73729_b(xLeft + pos.field_75223_e - 1, yTop + pos.field_75221_f - 1, 176, 43, 18, 18);
            this.func_73729_b(xLeft + pos.field_75223_e - 1, yTop + pos.field_75221_f - 1 - 26, 176, 18, 18, 25);
        }
        if (this.page != this.index.field_146127_k) {
            this.func_73729_b(xLeft + 5, yTop + 5 + (49 - essence), 176, 61 + (49 - essence), 9, Math.max(0, essence - warningEssence));
            this.func_73729_b(xLeft + 5, yTop + 5 + (49 - Math.min(warningEssence, essence)), 229, 61 + (49 - Math.min(warningEssence, essence)), 9, Math.max(0, Math.min(warningEssence, essence) - criticalEssence));
            this.func_73729_b(xLeft + 5, yTop + 5 + (49 - Math.min(criticalEssence, essence)), 220, 61 + (49 - Math.min(criticalEssence, essence)), 9, Math.max(0, Math.min(criticalEssence, essence)));
            this.func_73729_b(xLeft + 5, yTop + 5, 211, 61, 9, 49 - essence);
        } else {
            int w;
            this.field_73735_i = 50.0f;
            for (w = 0; w < 8; ++w) {
                for (int h = 0; h < 5; ++h) {
                    this.func_73729_b(xLeft + (20 * w + 9) - 1, yTop + (20 * h + 50) - 1 - 26, 176, this.indexNews[w + h * 8] == 2 ? 18 : 43, 18, 18);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            for (w = 0; w < 8; ++w) {
                for (int h = 0; h < 5; ++h) {
                    this.func_73729_b(xLeft + (20 * w + 9) - 1, yTop + (20 * h + 50) - 1 - 26, 194, this.indexNews[w + h * 8] == 2 ? 18 : 43, 18, 18);
                }
            }
            this.field_73735_i = 500.0f;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
        for (ContainerSurgery.SlotSurgery pos : this.visibleSlots) {
            this.func_73729_b(xLeft + pos.field_75223_e - 1, yTop + pos.field_75221_f - 1, 194, 43, 18, 18);
            this.func_73729_b(xLeft + pos.field_75223_e - 1, yTop + pos.field_75221_f - 1 - 26, 194, 18, 18, 18);
        }
        ArrayList<String> missingSlots = new ArrayList<String>();
        if (this.page != this.index.field_146127_k) {
            if (this.surgery.essence < 0) {
                missingSlots.add(I18n.func_135052_a((String)"cyberware.gui.noEssence", (Object[])new Object[0]));
            } else if (this.surgery.essence < CyberwareConfig.CRITICAL_ESSENCE) {
                missingSlots.add(I18n.func_135052_a((String)"cyberware.gui.criticalEssence", (Object[])new Object[0]));
            }
            if (this.surgery.missingPower) {
                missingSlots.add(I18n.func_135052_a((String)"cyberware.gui.noPower", (Object[])new Object[0]));
            }
            for (int index = 0; index < this.surgery.isEssentialMissing.length; ++index) {
                ICyberware.EnumSlot slot = ICyberware.EnumSlot.values()[index / 2];
                if (slot.isSided()) {
                    if (index % 2 == 0) {
                        if (!this.surgery.isEssentialMissing[index]) continue;
                        missingSlots.add(I18n.func_135052_a((String)("cyberware.gui.missingEssential." + slot.getName() + ".left"), (Object[])new Object[0]));
                        continue;
                    }
                    if (!this.surgery.isEssentialMissing[index]) continue;
                    missingSlots.add(I18n.func_135052_a((String)("cyberware.gui.missingEssential." + slot.getName() + ".right"), (Object[])new Object[0]));
                    continue;
                }
                if (index % 2 != 0 || !this.surgery.isEssentialMissing[index]) continue;
                missingSlots.add(I18n.func_135052_a((String)("cyberware.gui.missingEssential." + slot.getName()), (Object[])new Object[0]));
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            if (missingSlots.size() > 0) {
                this.func_73729_b(this.field_146999_f - 23 + xLeft, 20 + yTop, 212, 43, 16, 16);
            }
        }
        this.field_73735_i = 0.0f;
        GlStateManager.func_179121_F();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.partialTicks = partialTicks;
        float time = this.ticksExisted() + partialTicks;
        if (this.openTime == 0.0f) {
            boolean isEqual = true;
            ItemStackHandler newSlots = new ItemStackHandler(this.surgery.slotsPlayer.getSlots());
            for (int indexSlot = 0; indexSlot < this.surgery.slotsPlayer.getSlots(); ++indexSlot) {
                ItemStack thisItem;
                ItemStack surgeryItem = this.surgery.slotsPlayer.getStackInSlot(indexSlot);
                if (!ItemStack.func_179545_c((ItemStack)surgeryItem, (ItemStack)(thisItem = lastLastInv.getStackInSlot(indexSlot)))) {
                    isEqual = false;
                }
                newSlots.setStackInSlot(indexSlot, surgeryItem);
            }
            if (!isEqual) {
                this.openTime = time;
                lastLastInv = lastInv;
                lastInv = newSlots;
            } else {
                this.openTime = 1.0f;
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(SURGERY_GUI_TEXTURES);
        int xLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int yTop = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_73735_i = 0.0f;
        this.func_73729_b(xLeft, yTop, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_73735_i = 0.0f;
        WorldClient world = this.field_146297_k.field_71441_e;
        if (this.skeleton == null || this.skeleton.field_70128_L) {
            this.skeleton = new EntitySkeleton((World)world);
        } else {
            this.skeleton.field_70170_p = world;
        }
        if (this.box == null) {
            this.box = new ModelBox();
        }
        GlStateManager.func_179094_E();
        if (this.transitionStart != 0.0f) {
            this.current.rotation = this.current.rotation % 360.0f;
            if (Math.abs(this.current.rotation + 360.0f - this.target.rotation) < Math.abs(this.current.rotation - this.target.rotation)) {
                this.current.rotation = this.current.rotation + 360.0f;
            } else if (Math.abs(this.current.rotation - (this.target.rotation + 360.0f)) < Math.abs(this.current.rotation - this.target.rotation)) {
                this.current.rotation = this.current.rotation - 360.0f;
            }
            this.amountDone = (time - this.transitionStart) / this.operationTime;
            this.ease = GuiSurgery.interpolate(this.amountDone, this.current, this.target);
            if (this.amountDone >= 1.0f) {
                this.transitionStart = 0.0f;
                this.ease = this.target;
                this.showHideRelevantButtons(true);
            }
        }
        if (this.mouseDown && this.page <= 10) {
            this.ease.rotation = this.oldRotate + (float)((mouseX - this.mouseDownX) % 360);
            for (int index = 1; index < 5; ++index) {
                this.lastDownX[index] = this.lastDownX[index - 1];
            }
            this.lastDownX[0] = mouseX;
        } else {
            if (this.page > 10) {
                this.rotateVelocity = 0.0f;
            }
            PageConfiguration index = this.ease;
            index.rotation = index.rotation + this.rotateVelocity % 360.0f;
            this.rotateVelocity *= 0.8f;
        }
        float endRotate = this.ease.rotation;
        if (this.page != this.index.field_146127_k) {
            this.field_146297_k.func_110434_K().func_110577_a(SURGERY_GUI_TEXTURES);
            float percentageSkele = Math.min(1.0f, (time - this.openTime) / 40.0f);
            if (percentageSkele < 1.0f) {
                this.ease.rotation = (float)(Math.sin(Math.PI * (double)percentageSkele / 2.0) * 360.0);
            }
            GL11.glEnable((int)3089);
            this.scissor(xLeft + 3, yTop + 3, 170, 125);
            if (percentageSkele < 0.9f) {
                this.field_73735_i = 90.0f;
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(xLeft + this.field_146999_f / 2 - 40), (float)(yTop + (int)(percentageSkele * 125.0f) + 2), (float)0.0f);
                this.func_73729_b(0, 0, 176, 110, 80, 1);
                GlStateManager.func_179121_F();
                this.field_73735_i = 0.0f;
            }
            if (this.ease.boxHeight >= 35.0f) {
                GlStateManager.func_179094_E();
                float height = Math.min(125.0f, this.ease.boxHeight);
                float width = Math.min(170.0f, this.ease.boxWidth);
                this.field_146297_k.func_110434_K().func_110577_a(GREY_TEXTURE);
                this.field_73735_i = this.page == 0 ? 90.0f : 70.0f;
                GlStateManager.func_179109_b((float)((float)xLeft + (float)this.field_146999_f / 2.0f + this.ease.boxX - width / 2.0f), (float)((float)yTop + 62.5f + 3.0f + this.ease.boxY - height / 2.0f), (float)0.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)width, (float)height, (float)1.0f);
                this.func_73729_b(0, 0, 0, 0, 1, 1);
                GlStateManager.func_179121_F();
                this.field_146297_k.func_110434_K().func_110577_a(BLUE_TEXTURE);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)width, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, 0, 0, 1, 1);
                GlStateManager.func_179109_b((float)0.0f, (float)(height - 1.0f), (float)0.0f);
                this.func_73729_b(0, 0, 0, 0, 1, 1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)1.0f, (float)height, (float)1.0f);
                this.func_73729_b(0, 0, 0, 0, 1, 1);
                GlStateManager.func_179109_b((float)(width - 1.0f), (float)0.0f, (float)0.0f);
                this.func_73729_b(0, 0, 0, 0, 1, 1);
                GlStateManager.func_179121_F();
                GlStateManager.func_179121_F();
                if (this.ease.boxHeight == 35.0f) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)((float)xLeft + (float)this.field_146999_f / 2.0f + this.ease.boxX - this.ease.boxWidth / 2.0f), (float)((float)yTop + 62.5f + 3.0f + this.ease.boxY - this.ease.boxHeight / 2.0f), (float)0.0f);
                    GlStateManager.func_179094_E();
                    this.func_73729_b(0, 0, 0, 0, 1, 1);
                    GlStateManager.func_179109_b((float)(this.configs[0].boxWidth / 2.0f), (float)-12.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)1.0f, (float)12.0f, (float)1.0f);
                    this.func_73729_b(0, 0, 0, 0, 1, 1);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179094_E();
                    this.func_73729_b(0, 0, 0, 0, 1, 1);
                    GlStateManager.func_179109_b((float)(this.configs[0].boxWidth / 2.0f + 1.0f), (float)-12.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)25.0f, (float)1.0f, (float)1.0f);
                    this.func_73729_b(0, 0, 0, 0, 1, 1);
                    GlStateManager.func_179121_F();
                    GlStateManager.func_179121_F();
                }
                this.field_73735_i = 0.0f;
                ClientUtils.bindTexture("cyberware:textures/models/skin.png");
                if (!this.mouseDown && this.page < 10) {
                    this.addedRotate = (this.addedRotate + (this.ticksExisted() + partialTicks - this.lastTicks) * 2.0f) % 360.0f;
                }
                this.lastTicks = this.ticksExisted() + partialTicks;
                this.renderModel(this.box, (float)xLeft + (float)this.field_146999_f / 2.0f + this.ease.boxX, (float)yTop + 62.5f + 3.0f + this.ease.boxY, this.ease.boxHeight / 50.0f * 40.0f, endRotate + this.addedRotate);
            }
            this.scissor(xLeft + 3, yTop + 3, 170, (int)(percentageSkele * 125.0f));
            this.renderEntity(this.skeleton, (float)xLeft + (float)this.field_146999_f / 2.0f + this.ease.x, (float)(yTop + 110) + this.ease.y, this.ease.scale, endRotate, partialTicks);
            this.scissor(xLeft + 3, yTop + 3 + (int)(percentageSkele * 125.0f), 170, 125 - (int)(percentageSkele * 125.0f));
            EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            float f = entityPlayer.field_70761_aq;
            float f1 = entityPlayer.field_70177_z;
            float f2 = entityPlayer.field_70125_A;
            float f3 = entityPlayer.field_70758_at;
            float f4 = entityPlayer.field_70759_as;
            entityPlayer.field_70758_at = 0.0f;
            entityPlayer.field_70125_A = 0.0f;
            entityPlayer.field_70177_z = 0.0f;
            entityPlayer.field_70761_aq = 0.0f;
            entityPlayer.field_70177_z = this.skeleton.field_70177_z;
            entityPlayer.field_70759_as = this.skeleton.func_70079_am();
            float swingProgress = entityPlayer.field_70733_aJ;
            entityPlayer.field_70733_aJ = 0.0f;
            this.renderEntity((Entity)entityPlayer, (float)xLeft + (float)this.field_146999_f / 2.0f + this.ease.x, (float)(yTop + 115) + this.ease.y * 0.95238096f, this.ease.scale * 1.14f, this.ease.rotation + (float)(5.0 * Math.sin(time / 25.0f)), partialTicks);
            entityPlayer.field_70733_aJ = swingProgress;
            entityPlayer.field_70761_aq = f;
            entityPlayer.field_70177_z = f1;
            entityPlayer.field_70125_A = f2;
            entityPlayer.field_70758_at = f3;
            entityPlayer.field_70759_as = f4;
            GL11.glDisable((int)3089);
        }
        this.updateLocationButtons(endRotate, this.ease.scale, this.ease.y);
        this.drawSlots();
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int xLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int yTop = (this.field_146295_m - this.field_147000_g) / 2;
        if (mouseButton == 0 && mouseX >= xLeft && mouseX < xLeft + this.field_146999_f && mouseY >= yTop && mouseY < yTop + 130) {
            this.oldRotate = this.ease.rotation;
            this.mouseDown = true;
            this.mouseDownX = mouseX;
            for (int n = 0; n < 5; ++n) {
                this.lastDownX[n] = this.mouseDownX;
            }
        }
        if (mouseButton == 1 && (this.page != 0 || this.ease.rotation != 0.0f) && this.getSlotAtPosition(mouseX, mouseY) == null && mouseY < yTop + 130) {
            int pageToGoTo = this.page <= 10 ? 0 : this.parent;
            this.prepTransition(20, pageToGoTo);
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    private Slot getSlotAtPosition(int x, int y) {
        for (int indexSlot = 0; indexSlot < this.field_147002_h.field_75151_b.size(); ++indexSlot) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(indexSlot);
            if (!this.isMouseOverSlot(slot, x, y)) continue;
            return slot;
        }
        return null;
    }

    private boolean isMouseOverSlot(Slot slotIn, int mouseX, int mouseY) {
        return this.func_146978_c(slotIn.field_75223_e, slotIn.field_75221_f, 16, 16, mouseX, mouseY);
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.mouseDown) {
            this.mouseDown = false;
            this.rotateVelocity = (float)mouseX - this.lastDownX[4];
            if (Math.abs(this.rotateVelocity) < 5.0f) {
                this.rotateVelocity = 0.0f;
            }
        }
        super.func_146286_b(mouseX, mouseY, mouseButton);
    }

    private float ticksExisted() {
        return this.field_146297_k.field_71439_g != null ? (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa : 0.0f;
    }

    private static PageConfiguration interpolate(float amountDone, PageConfiguration start, PageConfiguration end) {
        return new PageConfiguration(GuiSurgery.ease(Math.min(1.0f, amountDone), start.rotation, end.rotation), GuiSurgery.ease(Math.min(1.0f, amountDone), start.x, end.x), GuiSurgery.ease(Math.min(1.0f, amountDone), start.y, end.y), GuiSurgery.ease(Math.min(1.0f, amountDone), start.scale, end.scale), GuiSurgery.ease(Math.min(1.0f, amountDone), start.boxWidth, end.boxWidth), GuiSurgery.ease(Math.min(1.0f, amountDone), start.boxHeight, end.boxHeight), GuiSurgery.ease(Math.min(1.0f, amountDone), start.boxX, end.boxX), GuiSurgery.ease(Math.min(1.0f, amountDone), start.boxY, end.boxY));
    }

    private static float ease(float percent, float startValue, float endValue) {
        float f;
        endValue -= startValue;
        float total = 100.0f;
        float elapsed = percent * total;
        elapsed /= total / 2.0f;
        if (f < 1.0f) {
            return endValue / 2.0f * elapsed * elapsed + startValue;
        }
        return -endValue / 2.0f * ((elapsed -= 1.0f) * (elapsed - 2.0f) - 1.0f) + startValue;
    }

    public void renderEntity(Entity entity, float x, float y, float scale, float rotation, float partialTicks) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        Minecraft.func_71410_x().func_175598_ae().func_188391_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
    }

    public void renderModel(ModelBase model, float x, float y, float scale, float rotation) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)120.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        float f1 = 0.7f;
        GlStateManager.func_187424_a((int)2899, (FloatBuffer)RenderHelper.func_74521_a((float)f1, (float)f1, (float)f1, (float)1.0f));
        model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
    }

    private void scissor(int x, int y, int xSize, int ySize) {
        ScaledResolution res = new ScaledResolution(this.field_146297_k);
        y = this.field_146297_k.field_71440_d - y * res.func_78325_e() - (ySize *= res.func_78325_e());
        GL11.glScissor((int)(x *= res.func_78325_e()), (int)y, (int)(xSize *= res.func_78325_e()), (int)ySize);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        Object s;
        int xLeft = (this.field_146294_l - this.field_146999_f) / 2;
        int yTop = (this.field_146295_m - this.field_147000_g) / 2;
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)900.0f);
        if (this.page == 0 && this.transitionStart == 0.0f) {
            s = "_" + Minecraft.func_71410_x().field_71439_g.func_70005_c_().toUpperCase();
            this.field_146289_q.func_78276_b((String)s, this.field_146999_f / 2 - this.field_146289_q.func_78256_a((String)s) / 2, 115, 1944001);
        }
        if (this.page == 9) {
            s = I18n.func_135052_a((String)"cyberware.gui.installed", (Object[])new Object[0]);
            this.field_146289_q.func_78276_b((String)s, 8, 9, 1944001);
        }
        if (this.page != this.index.field_146127_k) {
            s = this.surgery.essence + " / " + this.surgery.maxEssence;
            this.field_146289_q.func_78276_b((String)s, 18, 6, 1944001);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179147_l();
        this.field_73735_i = 500.0f;
        this.field_146296_j.field_77023_b = 500.0f;
        this.field_146297_k.func_110434_K().func_110577_a(SURGERY_GUI_TEXTURES);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (ContainerSurgery.SlotSurgery pos : this.visibleSlots) {
            FontRenderer fontRenderItem;
            GlStateManager.func_179094_E();
            ItemStack stack = pos.getPlayerStack();
            this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, stack, pos.field_75223_e, pos.field_75221_f - 26);
            if (!stack.func_190926_b() && stack.func_190916_E() > 1) {
                fontRenderItem = stack.func_77973_b().getFontRenderer(stack);
                if (fontRenderItem == null) {
                    fontRenderItem = this.field_146289_q;
                }
                this.field_146296_j.func_180453_a(fontRenderItem, stack, pos.field_75223_e, pos.field_75221_f - 26, Integer.toString(stack.func_190916_E()));
            }
            if (pos.func_75211_c().func_190926_b() && !pos.slotDiscarded()) {
                this.field_146296_j.field_77023_b = 50.0f;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, pos.getPlayerStack(), pos.field_75223_e, pos.field_75221_f);
                if (!stack.func_190926_b() && stack.func_190916_E() > 1) {
                    fontRenderItem = stack.func_77973_b().getFontRenderer(stack);
                    if (fontRenderItem == null) {
                        fontRenderItem = this.field_146289_q;
                    }
                    this.field_146296_j.func_180453_a(fontRenderItem, stack, pos.field_75223_e, pos.field_75221_f, Integer.toString(stack.func_190916_E()));
                }
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                this.field_146296_j.field_77023_b = 500.0f;
            } else if (CyberwareAPI.areCyberwareStacksEqual(stack, pos.func_75211_c())) {
                fontRenderItem = stack.func_77973_b().getFontRenderer(stack);
                if (fontRenderItem == null) {
                    fontRenderItem = this.field_146289_q;
                }
                String str = pos.func_75211_c().func_190916_E() == 1 ? "+1" : "+";
                int width = pos.func_75211_c().func_190916_E() == 1 ? 0 : fontRenderItem.func_78256_a(Integer.toString(pos.func_75211_c().func_190916_E()));
                this.field_146296_j.func_180453_a(fontRenderItem, stack, pos.field_75223_e - width, pos.field_75221_f, str);
            }
            GlStateManager.func_179121_F();
        }
        if (this.page == this.index.field_146127_k) {
            for (int zee = 0; zee < this.indexCount; ++zee) {
                int nu;
                ItemStack draw = (ItemStack)this.indexStacks.get(zee);
                int x = zee % 8 * 20 + 9;
                int y = zee / 8 * 20 + 24;
                this.field_146296_j.field_77023_b = 0.0f;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.field_146296_j.func_184391_a((EntityLivingBase)this.field_146297_k.field_71439_g, draw, x, y);
                FontRenderer fontRendererItem = draw.func_77973_b().getFontRenderer(draw);
                if (fontRendererItem == null) {
                    fontRendererItem = this.field_146289_q;
                }
                if (!draw.func_190926_b() && draw.func_190916_E() > 1) {
                    this.field_146296_j.func_180453_a(fontRendererItem, draw, x, y, Integer.toString(draw.func_190916_E()));
                }
                if ((nu = this.indexNews[zee]) == 1) {
                    this.field_146296_j.func_180453_a(fontRendererItem, draw, x - 10, y - 10, "+");
                } else if (nu == 2) {
                    this.field_146296_j.func_180453_a(fontRendererItem, draw, x - 10, y - 10, "-");
                }
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                this.field_146296_j.field_77023_b = 500.0f;
            }
        }
        ArrayList<String> missingSlots = new ArrayList<String>();
        if (this.page != this.index.field_146127_k) {
            if (this.surgery.essence < 0) {
                missingSlots.add(I18n.func_135052_a((String)"cyberware.gui.no_essence", (Object[])new Object[0]));
            } else if (this.surgery.essence < CyberwareConfig.CRITICAL_ESSENCE) {
                missingSlots.add(I18n.func_135052_a((String)"cyberware.gui.critical_essence", (Object[])new Object[0]));
            }
            if (this.surgery.missingPower) {
                missingSlots.add(I18n.func_135052_a((String)"cyberware.gui.no_power", (Object[])new Object[0]));
            }
            for (int index = 0; index < this.surgery.isEssentialMissing.length; ++index) {
                ICyberware.EnumSlot slot = ICyberware.EnumSlot.values()[index / 2];
                if (slot.isSided()) {
                    if (index % 2 == 0) {
                        if (!this.surgery.isEssentialMissing[index]) continue;
                        missingSlots.add(I18n.func_135052_a((String)("cyberware.gui.missing_essential." + slot.getName() + ".left"), (Object[])new Object[0]));
                        continue;
                    }
                    if (!this.surgery.isEssentialMissing[index]) continue;
                    missingSlots.add(I18n.func_135052_a((String)("cyberware.gui.missing_essential." + slot.getName() + ".right"), (Object[])new Object[0]));
                    continue;
                }
                if (index % 2 != 0 || !this.surgery.isEssentialMissing[index]) continue;
                missingSlots.add(I18n.func_135052_a((String)("cyberware.gui.missing_essential." + slot.getName()), (Object[])new Object[0]));
            }
            GlStateManager.func_179084_k();
            boolean ghost = false;
            boolean add = false;
            Slot slot = this.getSlotAtPosition(mouseX, mouseY + 26);
            if (!(slot instanceof ContainerSurgery.SlotSurgery)) {
                ghost = true;
                slot = this.getSlotAtPosition(mouseX, mouseY);
                if (slot != null && !slot.func_75211_c().func_190926_b()) {
                    slot = null;
                }
                if (slot instanceof ContainerSurgery.SlotSurgery && ((ContainerSurgery.SlotSurgery)slot).slotDiscarded() && !((ContainerSurgery.SlotSurgery)slot).getPlayerStack().func_190926_b()) {
                    if (this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                        add = true;
                    } else {
                        slot = null;
                    }
                }
            }
            if (slot instanceof ContainerSurgery.SlotSurgery) {
                ItemStack stack = ((ContainerSurgery.SlotSurgery)slot).getPlayerStack();
                if (add) {
                    this.drawHoveringText(Collections.singletonList(I18n.func_135052_a((String)"cyberware.gui.add", (Object[])new Object[]{I18n.func_135052_a((String)(stack.func_77977_a() + ".name"), (Object[])new Object[0])})), mouseX - xLeft, mouseY - yTop, this.field_146289_q);
                } else if (!stack.func_190926_b()) {
                    this.renderToolTip(stack, mouseX - xLeft, mouseY - yTop, ghost ? 1 : 0);
                }
            }
            if (missingSlots.size() > 0 && this.func_146978_c(this.field_146999_f - 23, 20, 16, 16, mouseX, mouseY)) {
                this.drawHoveringText(missingSlots, mouseX - xLeft, mouseY - yTop, this.field_146289_q);
            }
        } else {
            for (int n = 0; n < this.indexCount; ++n) {
                int x = n % 8 * 20 + 9;
                int y = n / 8 * 20 + 24;
                if (!this.func_146978_c(x - 1, y - 1, 18, 18, mouseX, mouseY)) continue;
                this.renderToolTip((ItemStack)this.indexStacks.get(n), mouseX - xLeft, mouseY - yTop, 2 + this.indexNews[n]);
                if (!this.mouseDown) continue;
                this.parent = this.index.field_146127_k;
                int time = GameSettings.func_100015_a((KeyBinding)this.field_146297_k.field_71474_y.field_74311_E) ? 0 : 30;
                this.prepTransition(time, this.indexPages[n]);
            }
        }
        if (this.page != 0 && this.func_146978_c(this.field_146999_f - 25, 5, this.back.field_146120_f, this.back.field_146121_g, mouseX, mouseY)) {
            this.drawHoveringText(Collections.singletonList(I18n.func_135052_a((String)"cyberware.gui.back", (Object[])new Object[0])), mouseX - xLeft, mouseY - yTop, this.field_146289_q);
        } else if (this.page == 0 && this.func_146978_c(this.field_146999_f - 22, 5, this.index.field_146120_f, this.index.field_146121_g, mouseX, mouseY)) {
            this.drawHoveringText(Collections.singletonList(I18n.func_135052_a((String)"cyberware.gui.index", (Object[])new Object[0])), mouseX - xLeft, mouseY - yTop, this.field_146289_q);
        }
        GlStateManager.func_179084_k();
        this.field_73735_i = 0.0f;
        this.field_146296_j.field_77023_b = 0.0f;
    }

    protected void func_184098_a(Slot slotIn, int slotId, int mouseButton, @Nonnull ClickType type) {
        ContainerSurgery.SlotSurgery surgerySlot;
        if (slotIn instanceof ContainerSurgery.SlotSurgery && !this.isSlotAccessible((ContainerSurgery.SlotSurgery)slotIn)) {
            return;
        }
        if (slotIn instanceof ContainerSurgery.SlotSurgery && (surgerySlot = (ContainerSurgery.SlotSurgery)slotIn).func_75211_c().func_190926_b() && !surgerySlot.getPlayerStack().func_190926_b() && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            int number = surgerySlot.field_75222_d;
            ItemStack playerSlotItem = surgerySlot.getPlayerStack();
            if (surgerySlot.slotDiscarded()) {
                if (!this.surgery.doesItemConflict(playerSlotItem, ((ContainerSurgery.SlotSurgery)slotIn).slot, number % 10)) {
                    surgerySlot.setDiscarded(false);
                    this.surgery.enableDependsOn(playerSlotItem, ((ContainerSurgery.SlotSurgery)slotIn).slot, number % 10);
                    CyberwarePacketHandler.INSTANCE.sendToServer((IMessage)new SurgeryRemovePacket(this.surgery.func_174877_v(), this.surgery.func_145831_w().field_73011_w.getDimension(), number, false));
                }
            } else if (this.surgery.canDisableItem(playerSlotItem, ((ContainerSurgery.SlotSurgery)slotIn).slot, number % 10)) {
                surgerySlot.setDiscarded(true);
                this.surgery.disableDependants(playerSlotItem, ((ContainerSurgery.SlotSurgery)slotIn).slot, number % 10);
                CyberwarePacketHandler.INSTANCE.sendToServer((IMessage)new SurgeryRemovePacket(this.surgery.func_174877_v(), this.surgery.func_145831_w().field_73011_w.getDimension(), number, true));
            }
        }
        super.func_184098_a(slotIn, slotId, mouseButton, type);
    }

    public boolean isSlotAccessible(@Nonnull ContainerSurgery.SlotSurgery slot) {
        return this.page == slot.slot.getSlotNumber();
    }

    protected void updateSurgerySlotsVisibility(boolean show) {
        this.visibleSlots.clear();
        Iterator iteratorSlots = this.field_147002_h.field_75151_b.iterator();
        Slot slot = (Slot)iteratorSlots.next();
        while (slot instanceof ContainerSurgery.SlotSurgery) {
            ContainerSurgery.SlotSurgery slotSurgery = (ContainerSurgery.SlotSurgery)slot;
            if (show && this.isSlotAccessible(slotSurgery)) {
                slotSurgery.field_75223_e = slotSurgery.savedXPosition;
                slotSurgery.field_75221_f = slotSurgery.savedYPosition;
                this.visibleSlots.add(slotSurgery);
            } else {
                slotSurgery.field_75223_e = Integer.MIN_VALUE;
                slotSurgery.field_75221_f = Integer.MIN_VALUE;
            }
            slot = (Slot)iteratorSlots.next();
        }
    }

    protected void renderToolTip(@Nonnull ItemStack stack, int x, int y, int extras) {
        List listTooltips = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        for (int indexTooltip = 0; indexTooltip < listTooltips.size(); ++indexTooltip) {
            if (indexTooltip == 0) {
                listTooltips.set(indexTooltip, stack.func_77973_b().getForgeRarity(stack).getColor() + (String)listTooltips.get(indexTooltip));
                continue;
            }
            listTooltips.set(indexTooltip, TextFormatting.GRAY + (String)listTooltips.get(indexTooltip));
        }
        if (extras == 1) {
            listTooltips.add(1, I18n.func_135052_a((String)"cyberware.gui.remove", (Object[])new Object[0]));
        } else if (extras >= 2) {
            listTooltips.add(1, I18n.func_135052_a((String)"cyberware.gui.click", (Object[])new Object[0]));
            if (extras == 3) {
                listTooltips.set(0, (String)listTooltips.get(0) + " " + I18n.func_135052_a((String)"cyberware.gui.added", (Object[])new Object[0]));
            } else if (extras == 4) {
                listTooltips.set(0, (String)listTooltips.get(0) + " " + I18n.func_135052_a((String)"cyberware.gui.removed", (Object[])new Object[0]));
            }
        }
        FontRenderer frontRendererItem = stack.func_77973_b().getFontRenderer(stack);
        this.drawHoveringText(listTooltips, x, y, frontRendererItem == null ? this.field_146289_q : frontRendererItem);
    }

    private static class PageConfiguration {
        private float rotation;
        private float x;
        private float y;
        private float scale;
        private float boxWidth;
        private float boxHeight;
        private float boxX;
        private float boxY;

        private PageConfiguration(float rotation, float x, float y, float scale) {
            this(rotation, x, y, scale, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        private PageConfiguration(float rotation, float x, float y, float scale, float boxWidth, float boxHeight, float boxX, float boxY) {
            this.rotation = rotation;
            this.x = x;
            this.y = y;
            this.scale = scale;
            this.boxHeight = boxHeight;
            this.boxWidth = boxWidth;
            this.boxX = boxX;
            this.boxY = boxY;
        }

        public PageConfiguration copy() {
            return new PageConfiguration(this.rotation, this.x, this.y, this.scale, this.boxWidth, this.boxHeight, this.boxX, this.boxY);
        }
    }

    private static class InterfaceButton
    extends GuiButton {
        private final Type type;

        public InterfaceButton(int buttonId, int x, int y, Type type) {
            super(buttonId, x, y, type.width, type.height, "");
            this.type = type;
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean isHovering;
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                float trans = 0.4f;
                boolean bl = isHovering = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                if (isHovering) {
                    trans = 0.6f;
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)trans);
                mc.func_110434_K().func_110577_a(SURGERY_GUI_TEXTURES);
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.type.left + this.type.width, this.type.top, this.type.width, this.type.height);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(trans / 2.0f));
                this.func_73729_b(this.field_146128_h, this.field_146129_i, this.type.left, this.type.top, this.type.width, this.type.height);
                GlStateManager.func_179121_F();
            }
        }
    }

    private static enum Type {
        BACK(176, 111, 18, 10),
        INDEX(176, 122, 12, 11);

        private int left;
        private int top;
        private int width;
        private int height;

        private Type(int left, int top, int width, int height) {
            this.left = left;
            this.top = top;
            this.width = width;
            this.height = height;
        }
    }

    private static class GuiButtonSurgery
    extends GuiButton {
        public GuiButtonSurgery(int buttonId, int x, int y, int xSize, int ySize) {
            super(buttonId, x, y, xSize, ySize, "");
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        }
    }

    private static class GuiButtonSurgeryLocation
    extends GuiButton {
        private static final int buttonSize = 16;
        private float x3;
        private float y3;
        private float z3;
        private float xPos;
        private float yPos;

        public GuiButtonSurgeryLocation(int buttonId, float x3, float y3, float z3) {
            super(buttonId, 0, 0, 16, 16, "");
            this.x3 = x3;
            this.y3 = y3;
            this.z3 = z3;
            this.field_146125_m = false;
        }

        public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                float trans = 0.4f;
                if (mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + 16 && mouseY < this.field_146129_i + 16) {
                    trans = 0.6f;
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)trans);
                mc.func_110434_K().func_110577_a(SURGERY_GUI_TEXTURES);
                GlStateManager.func_179109_b((float)this.xPos, (float)this.yPos, (float)0.0f);
                this.func_73729_b(0, 0, 194, 0, this.field_146120_f, this.field_146121_g);
                GlStateManager.func_179121_F();
            }
        }
    }
}

