/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.handler;

import com.mojang.realmsclient.gui.ChatFormatting;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IDeconstructable;
import flaxbeard.cyberware.common.CyberwareContent;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MiscHandler {
    public static final MiscHandler INSTANCE = new MiscHandler();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void handleCyberwareTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (CyberwareAPI.isCyberware(stack)) {
            ICyberware ware = CyberwareAPI.getCyberware(stack);
            ICyberware.Quality quality = ware.getQuality(stack);
            GameSettings settings = Minecraft.func_71410_x().field_71474_y;
            if (GameSettings.func_100015_a((KeyBinding)settings.field_74311_E)) {
                NonNullList<NonNullList<ItemStack>> requirements;
                List<String> info = ware.getInfo(stack);
                if (info != null) {
                    event.getToolTip().addAll(info);
                }
                if ((requirements = ware.required(stack)).size() > 0) {
                    String joined = "";
                    for (int indexRequirement = 0; indexRequirement < requirements.size(); ++indexRequirement) {
                        String toAdd = "";
                        for (int indexSubRequirement = 0; indexSubRequirement < ((NonNullList)requirements.get(indexRequirement)).size(); ++indexSubRequirement) {
                            if (indexSubRequirement != 0) {
                                toAdd = toAdd + " " + I18n.func_135052_a((String)"cyberware.tooltip.joiner_or", (Object[])new Object[0]) + " ";
                            }
                            toAdd = toAdd + I18n.func_135052_a((String)(((ItemStack)((NonNullList)requirements.get(indexRequirement)).get(indexSubRequirement)).func_77977_a() + ".name"), (Object[])new Object[0]);
                        }
                        if (indexRequirement != 0) {
                            joined = joined + I18n.func_135052_a((String)"cyberware.tooltip.joiner", (Object[])new Object[0]) + " ";
                        }
                        joined = joined + toAdd;
                    }
                    event.getToolTip().add(ChatFormatting.AQUA + I18n.func_135052_a((String)"cyberware.tooltip.requires", (Object[])new Object[0]) + " " + joined);
                }
                event.getToolTip().add(ChatFormatting.RED + I18n.func_135052_a((String)("cyberware.slot." + ware.getSlot(stack).getName()), (Object[])new Object[0]));
                if (quality != null) {
                    event.getToolTip().add(I18n.func_135052_a((String)quality.getUnlocalizedName(), (Object[])new Object[0]));
                }
            } else {
                event.getToolTip().add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"cyberware.tooltip.shift_prompt", (Object[])new Object[0]));
            }
        } else if (stack.func_77973_b() instanceof IDeconstructable) {
            if (event.getToolTip().size() > 1) {
                event.getToolTip().add(1, ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"cyberware.tooltip.can_deconstruct", (Object[])new Object[0]));
            } else {
                event.getToolTip().add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)"cyberware.tooltip.can_deconstruct", (Object[])new Object[0]));
            }
        }
    }

    @SubscribeEvent
    public void handleNeuropozynePopulation(LootTableLoadEvent event) {
        LootFunction[] lf;
        LootCondition[] lc;
        LootTable table;
        LootPool main;
        if ((event.getName() == LootTableList.field_186422_d || event.getName() == LootTableList.field_186424_f || event.getName() == LootTableList.field_186427_i || event.getName() == LootTableList.field_186428_j || event.getName() == LootTableList.field_186426_h || event.getName() == LootTableList.field_186429_k || event.getName() == LootTableList.field_186430_l) && (main = (table = event.getTable()).getPool("main")) != null) {
            lc = new LootCondition[]{};
            lf = new LootFunction[]{new SetCount(lc, new RandomValueRange(16.0f, 64.0f))};
            main.addEntry((LootEntry)new LootEntryItem(CyberwareContent.neuropozyne, 15, 0, lf, lc, "cyberware:neuropozyne"));
        }
        if (event.getName() == LootTableList.field_186425_g && (main = (table = event.getTable()).getPool("main")) != null) {
            lc = new LootCondition[]{};
            lf = new LootFunction[]{};
            main.addEntry((LootEntry)new LootEntryItem(Item.func_150898_a((Block)CyberwareContent.surgeryApparatus), 15, 0, lf, lc, "cyberware:surgery_apparatus"));
        }
    }
}

