/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.misc;

import flaxbeard.cyberware.api.item.IDeconstructable;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemBlueprint;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;

public class BlueprintCraftingHandler
implements IRecipe {
    private IRecipe realRecipe = this;

    public ResourceLocation getRegistryName() {
        return new ResourceLocation("cyberware", "blueprintCrafting");
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        return (IRecipe)this.realRecipe.setRegistryName(name);
    }

    public Class<IRecipe> getRegistryType() {
        return this.realRecipe.getRegistryType();
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inventoryCrafting, @Nonnull World world) {
        return new BlueprintResult(inventoryCrafting).canCraft;
    }

    @Nonnull
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventoryCrafting) {
        return new BlueprintResult(inventoryCrafting).output;
    }

    @Nonnull
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventoryCrafting) {
        return new BlueprintResult(inventoryCrafting).remaining;
    }

    static {
        RecipeSorter.register((String)"cyberware:blueprintCrafting", BlueprintCraftingHandler.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }

    private class BlueprintResult {
        private final boolean canCraft;
        private final NonNullList<ItemStack> remaining;
        private final ItemStack output;
        private ItemStack ware = ItemStack.field_190927_a;
        int wareStack = 0;

        public BlueprintResult(InventoryCrafting inv) {
            this.canCraft = this.process(inv);
            if (this.canCraft) {
                this.remaining = NonNullList.func_191196_a();
                this.remaining.add((Object)this.ware.func_77946_l());
                this.output = ItemBlueprint.getBlueprintForItem(this.ware);
            } else {
                this.remaining = NonNullList.func_191196_a();
                this.output = ItemStack.field_190927_a;
            }
        }

        private boolean process(InventoryCrafting inventoryCrafting) {
            boolean hasBlankBlueprint = false;
            for (int indexSlot = 0; indexSlot < inventoryCrafting.func_70302_i_(); ++indexSlot) {
                ItemStack stack = inventoryCrafting.func_70301_a(indexSlot);
                if (stack.func_190926_b()) continue;
                if (stack.func_77973_b() instanceof IDeconstructable) {
                    if (this.ware.func_190926_b()) {
                        this.ware = stack;
                        this.wareStack = indexSlot;
                        continue;
                    }
                    return false;
                }
                if (!(stack.func_77973_b() != CyberwareContent.blueprint || stack.func_77942_o() && stack.func_77978_p().func_74764_b("blueprintItem"))) {
                    if (!hasBlankBlueprint) {
                        hasBlankBlueprint = true;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            return !this.ware.func_190926_b() && hasBlankBlueprint;
        }
    }
}

