/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block;

import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.item.ItemSurgeryChamber;
import flaxbeard.cyberware.common.block.tile.TileEntitySurgery;
import flaxbeard.cyberware.common.block.tile.TileEntitySurgeryChamber;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class BlockSurgeryChamber
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool OPEN = PropertyBool.func_177716_a((String)"open");
    public static final PropertyEnum<EnumChamberHalf> HALF = PropertyEnum.func_177709_a((String)"half", EnumChamberHalf.class);
    public final Item ib;
    private static final AxisAlignedBB top = new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB south = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625);
    private static final AxisAlignedBB north = new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB east = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0);
    private static final AxisAlignedBB west = new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB bottom = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockSurgeryChamber() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false)).func_177226_a(HALF, (Comparable)((Object)EnumChamberHalf.LOWER)));
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        String name = "surgery_chamber";
        this.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)this);
        this.ib = new ItemSurgeryChamber((Block)this);
        this.ib.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)this.ib);
        this.func_149663_c("cyberware." + name);
        this.ib.func_77655_b("cyberware." + name);
        this.ib.func_77637_a(Cyberware.creativeTab);
        GameRegistry.registerTileEntity(TileEntitySurgeryChamber.class, (String)("cyberware:" + name));
        CyberwareContent.items.add(this.ib);
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.ib);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean b) {
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean open = (Boolean)state.func_177229_b((IProperty)OPEN);
        if (state.func_177229_b(HALF) == EnumChamberHalf.UPPER) {
            BlockSurgeryChamber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)top);
            if (!open || face != EnumFacing.SOUTH) {
                BlockSurgeryChamber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)south);
            }
            if (!open || face != EnumFacing.NORTH) {
                BlockSurgeryChamber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)north);
            }
            if (!open || face != EnumFacing.EAST) {
                BlockSurgeryChamber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)east);
            }
            if (!open || face != EnumFacing.WEST) {
                BlockSurgeryChamber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)west);
            }
        } else {
            BlockSurgeryChamber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bottom);
            if (!open || face != EnumFacing.SOUTH) {
                BlockSurgeryChamber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)south);
            }
            if (!open || face != EnumFacing.NORTH) {
                BlockSurgeryChamber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)north);
            }
            if (!open || face != EnumFacing.EAST) {
                BlockSurgeryChamber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)east);
            }
            if (!open || face != EnumFacing.WEST) {
                BlockSurgeryChamber.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)west);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        boolean top = state.func_177229_b(HALF) == EnumChamberHalf.UPPER;
        if (this.canOpen(top ? pos : pos.func_177984_a(), worldIn)) {
            this.toggleDoor(top, state, pos, worldIn);
            this.notifySurgeon(top ? pos : pos.func_177984_a(), worldIn);
        }
        return true;
    }

    public void toggleDoor(boolean top, IBlockState state, BlockPos pos, World worldIn) {
        IBlockState otherState;
        state = state.func_177231_a((IProperty)OPEN);
        worldIn.func_180501_a(pos, state, 2);
        BlockPos otherPos = pos.func_177984_a();
        if (top) {
            otherPos = pos.func_177977_b();
        }
        if ((otherState = worldIn.func_180495_p(otherPos)).func_177230_c() == this) {
            otherState = otherState.func_177231_a((IProperty)OPEN);
            worldIn.func_180501_a(otherPos, otherState, 2);
        }
    }

    private boolean canOpen(BlockPos pos, World worldIn) {
        TileEntity above = worldIn.func_175625_s(pos.func_177984_a());
        if (above instanceof TileEntitySurgery) {
            return ((TileEntitySurgery)above).canOpen();
        }
        return true;
    }

    private void notifySurgeon(BlockPos pos, World worldIn) {
        TileEntity above = worldIn.func_175625_s(pos.func_177984_a());
        if (above instanceof TileEntitySurgery) {
            ((TileEntitySurgery)above).notifyChange();
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (state.func_177229_b(HALF) == EnumChamberHalf.UPPER) {
            BlockPos blockpos = pos.func_177977_b();
            IBlockState iblockstate = worldIn.func_180495_p(blockpos);
            if (iblockstate.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            } else if (blockIn != this) {
                iblockstate.func_189546_a(worldIn, blockpos, blockIn, fromPos);
            }
        } else {
            boolean shouldBreak = false;
            BlockPos blockpos1 = pos.func_177984_a();
            IBlockState iblockstate1 = worldIn.func_180495_p(blockpos1);
            if (iblockstate1.func_177230_c() != this) {
                worldIn.func_175698_g(pos);
                if (!worldIn.field_72995_K) {
                    this.func_176226_b(worldIn, pos, state, 0);
                }
            }
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(HALF) == EnumChamberHalf.UPPER ? null : this.ib;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return pos.func_177956_o() >= worldIn.func_72800_K() - 1 ? false : worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP) && super.func_176196_c(worldIn, pos) && super.func_176196_c(worldIn, pos.func_177984_a());
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(HALF, (Comparable)((Object)((meta & 1) > 0 ? EnumChamberHalf.UPPER : EnumChamberHalf.LOWER))).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 2) > 0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta >> 2)));
    }

    public int func_176201_c(IBlockState state) {
        return (((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() << 2) + (state.func_177229_b(HALF) == EnumChamberHalf.UPPER ? 1 : 0) + ((Boolean)state.func_177229_b((IProperty)OPEN) != false ? 2 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HALF, FACING, OPEN});
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos = pos.func_177977_b();
        BlockPos blockpos1 = pos.func_177984_a();
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(HALF) == EnumChamberHalf.UPPER && worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        if (state.func_177229_b(HALF) == EnumChamberHalf.LOWER && worldIn.func_180495_p(blockpos1).func_177230_c() == this) {
            if (player.field_71075_bZ.field_75098_d) {
                worldIn.func_175698_g(pos);
            }
            worldIn.func_175698_g(blockpos1);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return (meta & 1) > 0 ? new TileEntitySurgeryChamber() : null;
    }

    public static enum EnumChamberHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

