/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block.tile;

import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.block.BlockSurgeryChamber;
import flaxbeard.cyberware.common.handler.EssentialsMissingHandler;
import flaxbeard.cyberware.common.item.ItemCyberware;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntitySurgery
extends TileEntity
implements ITickable {
    public ItemStackHandler slotsPlayer = new ItemStackHandler(120);
    public ItemStackHandler slots = new ItemStackHandler(120);
    public boolean[] discardSlots = new boolean[120];
    public boolean[] isEssentialMissing = new boolean[ICyberware.EnumSlot.values().length * 2];
    public int essence = 0;
    public int maxEssence = 0;
    public int wrongSlot = -1;
    public int ticksWrong = 0;
    public int lastEntity = -1;
    public int cooldownTicks = 0;
    public boolean missingPower = false;
    public boolean inProgress = false;
    public EntityLivingBase targetEntity = null;
    public int progressTicks = 0;
    public static boolean workingOnPlayer = false;
    public static int playerProgressTicks = 0;

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void updatePlayerSlots(EntityLivingBase entity) {
        this.func_70296_d();
        if (CyberwareAPI.hasCapability((Entity)entity)) {
            if (entity.func_145782_y() != this.lastEntity) {
                for (int i = 0; i < this.discardSlots.length; ++i) {
                    this.discardSlots[i] = false;
                }
                this.lastEntity = entity.func_145782_y();
            }
            ICyberwareUserData c = CyberwareAPI.getCapability((Entity)entity);
            int i = 0;
            for (ICyberware.EnumSlot slotType : ICyberware.EnumSlot.values()) {
                for (int n = 0; n < 10; ++n) {
                    ItemStack toPut = ((ItemStack)c.getInstalledCyberware(slotType).get(n)).func_77946_l();
                    if (!ItemStack.func_77989_b((ItemStack)toPut, (ItemStack)this.slotsPlayer.getStackInSlot(i * 10 + n))) {
                        this.discardSlots[i * 10 + n] = false;
                        if (this.doesItemConflict(toPut, slotType, n)) {
                            this.discardSlots[i * 10 + n] = true;
                        }
                    }
                    this.slotsPlayer.setStackInSlot(i * 10 + n, toPut);
                }
                this.updateEssential(slotType);
                ++i;
            }
            boolean needToCheck = true;
            while (needToCheck) {
                i = 0;
                needToCheck = false;
                for (ICyberware.EnumSlot slotType : ICyberware.EnumSlot.values()) {
                    for (int n = 0; n < 10; ++n) {
                        int index = i * 10 + n;
                        ItemStack stack = this.slots.getStackInSlot(index);
                        if (stack.func_190926_b() || this.areRequirementsFulfilled(stack, slotType, n)) continue;
                        this.addItemStack(entity, stack);
                        this.slots.setStackInSlot(index, ItemStack.field_190927_a);
                        needToCheck = true;
                    }
                    ++i;
                }
            }
            this.updateEssence();
        } else {
            this.slotsPlayer = new ItemStackHandler(120);
            for (ICyberware.EnumSlot slotType : ICyberware.EnumSlot.values()) {
                this.updateEssential(slotType);
            }
        }
        this.wrongSlot = -1;
    }

    public boolean doesItemConflict(@Nullable ItemStack stack, ICyberware.EnumSlot slot, int n) {
        int row = slot.ordinal();
        if (!stack.func_190926_b()) {
            for (int i = 0; i < 10; ++i) {
                ItemStack otherStack;
                if (i == n) continue;
                int index = row * 10 + i;
                ItemStack slotStack = this.slots.getStackInSlot(index);
                ItemStack playerStack = this.slotsPlayer.getStackInSlot(index);
                ItemStack itemStack = !slotStack.func_190926_b() ? slotStack : (otherStack = this.discardSlots[index] ? ItemStack.field_190927_a : playerStack);
                if (!otherStack.func_190926_b() && otherStack.func_77973_b() == stack.func_77973_b() && otherStack.func_77952_i() == stack.func_77952_i()) {
                    this.setWrongSlot(index);
                    return true;
                }
                if (!otherStack.func_190926_b() && CyberwareAPI.getCyberware(otherStack).isIncompatible(otherStack, stack)) {
                    this.setWrongSlot(index);
                    return true;
                }
                if (otherStack.func_190926_b() || !CyberwareAPI.getCyberware(stack).isIncompatible(stack, otherStack)) continue;
                this.setWrongSlot(index);
                return true;
            }
        }
        return false;
    }

    public void setWrongSlot(int index) {
        this.wrongSlot = index;
        Cyberware.proxy.wrong(this);
    }

    public void disableDependants(ItemStack stack, ICyberware.EnumSlot slot, int n) {
        int row = slot.ordinal();
        if (!stack.func_190926_b()) {
            for (int i = 0; i < 10; ++i) {
                int index;
                ItemStack playerStack;
                if (i == n || this.areRequirementsFulfilled(playerStack = this.slotsPlayer.getStackInSlot(index = row * 10 + i), slot, n)) continue;
                this.discardSlots[index] = true;
            }
        }
    }

    public void enableDependsOn(ItemStack stack, ICyberware.EnumSlot slot, int n) {
        if (!stack.func_190926_b()) {
            ICyberware ware = CyberwareAPI.getCyberware(stack);
            for (NonNullList neededItem : ware.required(stack)) {
                boolean found = false;
                block1: for (ItemStack needed : neededItem) {
                    for (int row = 0; row < ICyberware.EnumSlot.values().length; ++row) {
                        for (int i = 0; i < 10; ++i) {
                            int index;
                            ItemStack playerStack;
                            if (i == n || (playerStack = this.slotsPlayer.getStackInSlot(index = row * 10 + i)).func_190926_b() || playerStack.func_77973_b() != needed.func_77973_b() || playerStack.func_77952_i() != needed.func_77952_i()) continue;
                            found = true;
                            this.discardSlots[index] = false;
                            break block1;
                        }
                    }
                }
                if (found) continue;
                System.out.println("BADDDD!!!!!!!!!");
            }
        }
    }

    public boolean canDisableItem(ItemStack stack, ICyberware.EnumSlot slot, int n) {
        if (!stack.func_190926_b()) {
            for (int row = 0; row < ICyberware.EnumSlot.values().length; ++row) {
                for (int i = 0; i < 10; ++i) {
                    ItemStack otherStack;
                    if (i == n) continue;
                    int index = row * 10 + i;
                    ItemStack slotStack = this.slots.getStackInSlot(index);
                    ItemStack playerStack = ItemStack.field_190927_a;
                    ItemStack itemStack = !slotStack.func_190926_b() ? slotStack : (otherStack = this.discardSlots[index] ? ItemStack.field_190927_a : playerStack);
                    if (this.areRequirementsFulfilled(otherStack, slot, n)) continue;
                    this.setWrongSlot(index);
                    return false;
                }
            }
        }
        return true;
    }

    public boolean areRequirementsFulfilled(ItemStack stack, ICyberware.EnumSlot slot, int n) {
        if (!stack.func_190926_b()) {
            ICyberware ware = CyberwareAPI.getCyberware(stack);
            for (NonNullList neededItem : ware.required(stack)) {
                boolean found = false;
                block1: for (ItemStack needed : neededItem) {
                    for (int row = 0; row < ICyberware.EnumSlot.values().length; ++row) {
                        for (int i = 0; i < 10; ++i) {
                            ItemStack otherStack;
                            if (i == n) continue;
                            int index = row * 10 + i;
                            ItemStack slotStack = this.slots.getStackInSlot(index);
                            ItemStack playerStack = this.slotsPlayer.getStackInSlot(index);
                            ItemStack itemStack = !slotStack.func_190926_b() ? slotStack : (otherStack = this.discardSlots[index] ? ItemStack.field_190927_a : playerStack);
                            if (otherStack.func_190926_b() || otherStack.func_77973_b() != needed.func_77973_b() || otherStack.func_77952_i() != needed.func_77952_i()) continue;
                            found = true;
                            break block1;
                        }
                    }
                }
                if (found) continue;
                return false;
            }
        }
        return true;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.slots.deserializeNBT(compound.func_74775_l("inv"));
        this.slotsPlayer.deserializeNBT(compound.func_74775_l("inv2"));
        NBTTagList list = (NBTTagList)compound.func_74781_a("discard");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.discardSlots[i] = ((NBTTagByte)list.func_179238_g(i)).func_150290_f() > 0;
        }
        this.essence = compound.func_74762_e("essence");
        this.maxEssence = compound.func_74762_e("maxEssence");
        this.lastEntity = compound.func_74762_e("lastEntity");
        this.missingPower = compound.func_74767_n("missingPower");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("essence", this.essence);
        compound.func_74768_a("maxEssence", this.maxEssence);
        compound.func_74768_a("lastEntity", this.lastEntity);
        compound.func_74757_a("missingPower", this.missingPower);
        compound.func_74782_a("inv", (NBTBase)this.slots.serializeNBT());
        compound.func_74782_a("inv2", (NBTBase)this.slotsPlayer.serializeNBT());
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.discardSlots.length; ++i) {
            list.func_74742_a((NBTBase)new NBTTagByte((byte)(this.discardSlots[i] ? 1 : 0)));
        }
        compound.func_74782_a("discard", (NBTBase)list);
        return compound;
    }

    public void updateEssential(ICyberware.EnumSlot slot) {
        if (slot.hasEssential()) {
            byte answer = this.isEssential(slot);
            boolean foundFirst = (answer & 1) > 0;
            boolean foundSecond = (answer & 2) > 0;
            this.isEssentialMissing[slot.ordinal() * 2] = !foundFirst;
            this.isEssentialMissing[slot.ordinal() * 2 + 1] = !foundSecond;
        } else {
            this.isEssentialMissing[slot.ordinal() * 2] = false;
            this.isEssentialMissing[slot.ordinal() * 2 + 1] = false;
        }
    }

    private byte isEssential(ICyberware.EnumSlot slot) {
        byte r = 0;
        for (int i = 0; i < 10; ++i) {
            ICyberware ware;
            ItemStack stack;
            int index = slot.ordinal() * 10 + i;
            ItemStack slotStack = this.slots.getStackInSlot(index);
            ItemStack playerStack = this.slotsPlayer.getStackInSlot(index);
            ItemStack itemStack = !slotStack.func_190926_b() ? slotStack : (stack = this.discardSlots[index] ? ItemStack.field_190927_a : playerStack);
            if (stack.func_190926_b() || !(ware = CyberwareAPI.getCyberware(stack)).isEssential(stack)) continue;
            if (slot.isSided() && ware instanceof ICyberware.ISidedLimb) {
                if (((ICyberware.ISidedLimb)((Object)ware)).getSide(stack) == ICyberware.ISidedLimb.EnumSide.LEFT && (r & 1) == 0) {
                    r = (byte)(r + 1);
                    continue;
                }
                if ((r & 2) != 0) continue;
                r = (byte)(r + 2);
                continue;
            }
            return 3;
        }
        return r;
    }

    public void func_73660_a() {
        if (this.inProgress && this.progressTicks < 80) {
            if (this.targetEntity != null && !this.targetEntity.field_70128_L && CyberwareAPI.hasCapability((Entity)this.targetEntity)) {
                BlockPos pos = this.func_174877_v();
                if (this.progressTicks > 20 && this.progressTicks < 60) {
                    this.targetEntity.field_70165_t = (float)pos.func_177958_n() + 0.5f;
                    this.targetEntity.field_70161_v = (float)pos.func_177952_p() + 0.5f;
                }
                if (this.progressTicks >= 20 && this.progressTicks <= 60 && this.progressTicks % 5 == 0) {
                    this.targetEntity.func_70097_a(EssentialsMissingHandler.surgery, 2.0f);
                }
                if (this.progressTicks == 60) {
                    this.processUpdate();
                }
                ++this.progressTicks;
                if (Cyberware.proxy.workingOnPlayer(this.targetEntity)) {
                    workingOnPlayer = true;
                    playerProgressTicks = this.progressTicks;
                }
            } else {
                this.inProgress = false;
                this.progressTicks = 0;
                if (Cyberware.proxy.workingOnPlayer(this.targetEntity)) {
                    workingOnPlayer = false;
                }
                this.targetEntity = null;
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b());
                if (state.func_177230_c() instanceof BlockSurgeryChamber) {
                    ((BlockSurgeryChamber)state.func_177230_c()).toggleDoor(true, state, this.func_174877_v().func_177977_b(), this.field_145850_b);
                }
            }
        } else if (this.inProgress) {
            if (Cyberware.proxy.workingOnPlayer(this.targetEntity)) {
                workingOnPlayer = false;
            }
            this.inProgress = false;
            this.progressTicks = 0;
            this.targetEntity = null;
            this.cooldownTicks = 60;
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b());
            if (state.func_177230_c() instanceof BlockSurgeryChamber) {
                ((BlockSurgeryChamber)state.func_177230_c()).toggleDoor(true, state, this.func_174877_v().func_177977_b(), this.field_145850_b);
            }
        }
        if (this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
    }

    public void processUpdate() {
        this.updatePlayerSlots(this.targetEntity);
        BlockPos p = this.func_174877_v();
        ICyberwareUserData cyberware = CyberwareAPI.getCapability((Entity)this.targetEntity);
        for (int slotIndex = 0; slotIndex < ICyberware.EnumSlot.values().length; ++slotIndex) {
            ICyberware.EnumSlot slot = ICyberware.EnumSlot.values()[slotIndex];
            NonNullList wares = NonNullList.func_191196_a();
            for (int j = 0; j < 10; ++j) {
                wares.add((Object)ItemStack.field_190927_a);
            }
            int c = 0;
            for (int j = slotIndex * 10; j < (slotIndex + 1) * 10; ++j) {
                ItemStack newStack = this.slots.getStackInSlot(j);
                ItemStack targetEntityStack = this.slotsPlayer.getStackInSlot(j).func_77946_l();
                if (!newStack.func_190926_b() && newStack.func_190916_E() > 0) {
                    ItemStack ret = newStack.func_77946_l();
                    if (CyberwareAPI.areCyberwareStacksEqual(ret, targetEntityStack)) {
                        int maxSize = CyberwareAPI.getCyberware(ret).installedStackSize(ret);
                        if (ret.func_190916_E() < maxSize) {
                            int numToShift = Math.min(maxSize - ret.func_190916_E(), targetEntityStack.func_190916_E());
                            targetEntityStack.func_190918_g(numToShift);
                            ret.func_190917_f(numToShift);
                        }
                    }
                    if (!targetEntityStack.func_190926_b() && targetEntityStack.func_190916_E() > 0) {
                        targetEntityStack = CyberwareAPI.sanitize(targetEntityStack);
                        this.addItemStack(this.targetEntity, targetEntityStack);
                    }
                    wares.set(c, (Object)ret);
                    ++c;
                    continue;
                }
                if (targetEntityStack.func_190926_b() || targetEntityStack.func_190916_E() <= 0) continue;
                if (this.discardSlots[j]) {
                    targetEntityStack = CyberwareAPI.sanitize(targetEntityStack);
                    this.addItemStack(this.targetEntity, targetEntityStack);
                    continue;
                }
                wares.set(c, (Object)this.slotsPlayer.getStackInSlot(j).func_77946_l());
                ++c;
            }
            if (!this.field_145850_b.field_72995_K) {
                cyberware.setInstalledCyberware(this.targetEntity, slot, (NonNullList<ItemStack>)wares);
            }
            cyberware.setHasEssential(slot, !this.isEssentialMissing[slotIndex * 2], !this.isEssentialMissing[slotIndex * 2 + 1]);
        }
        cyberware.setEssence(this.essence);
        cyberware.updateCapacity();
        cyberware.setImmune();
        if (!this.field_145850_b.field_72995_K) {
            CyberwareAPI.updateData((Entity)this.targetEntity);
        }
        this.slots = new ItemStackHandler(120);
    }

    private void addItemStack(EntityLivingBase entity, ItemStack stack) {
        boolean flag = true;
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            boolean bl = flag = !player.field_71071_by.func_70441_a(stack);
        }
        if (flag && !this.field_145850_b.field_72995_K) {
            EntityItem item = new EntityItem(this.field_145850_b, (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() - 2.0f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), stack);
            this.field_145850_b.func_72838_d((Entity)item);
        }
    }

    public boolean canOpen() {
        return !this.inProgress && this.cooldownTicks <= 0;
    }

    public void notifyChange() {
        BlockPos p;
        List entities;
        boolean opened = (Boolean)this.field_145850_b.func_180495_p(this.func_174877_v().func_177977_b()).func_177229_b((IProperty)BlockSurgeryChamber.OPEN);
        if (!opened && (entities = this.field_145850_b.func_72872_a(EntityLivingBase.class, new AxisAlignedBB((double)(p = this.func_174877_v()).func_177958_n(), (double)((float)p.func_177956_o() - 2.0f), (double)p.func_177952_p(), (double)((float)p.func_177958_n() + 1.0f), (double)p.func_177956_o(), (double)((float)p.func_177952_p() + 1.0f)))).size() == 1) {
            this.inProgress = true;
            this.progressTicks = 0;
            this.targetEntity = (EntityLivingBase)entities.get(0);
        }
    }

    public void updateEssence() {
        this.maxEssence = this.essence = CyberwareConfig.ESSENCE;
        boolean hasConsume = false;
        boolean hasProduce = false;
        for (ICyberware.EnumSlot slot : ICyberware.EnumSlot.values()) {
            for (int i = 0; i < 10; ++i) {
                ItemStack stack;
                int index = slot.ordinal() * 10 + i;
                ItemStack slotStack = this.slots.getStackInSlot(index);
                ItemStack playerStack = this.slotsPlayer.getStackInSlot(index);
                ItemStack itemStack = !slotStack.func_190926_b() ? slotStack : (stack = this.discardSlots[index] ? ItemStack.field_190927_a : playerStack);
                if (stack.func_190926_b()) continue;
                ItemStack ret = stack.func_77946_l();
                if (!slotStack.func_190926_b() && !ret.func_190926_b() && !playerStack.func_190926_b() && CyberwareAPI.areCyberwareStacksEqual(playerStack, ret)) {
                    int maxSize = CyberwareAPI.getCyberware(ret).installedStackSize(ret);
                    if (ret.func_190916_E() < maxSize) {
                        int numToShift = Math.min(maxSize - ret.func_190916_E(), playerStack.func_190916_E());
                        ret.func_190917_f(numToShift);
                    }
                }
                ICyberware ware = CyberwareAPI.getCyberware(ret);
                this.essence -= ware.getEssenceCost(ret);
                if (ware instanceof ItemCyberware && ((ItemCyberware)ware).getPowerConsumption(ret) > 0) {
                    hasConsume = true;
                }
                if (!(ware instanceof ItemCyberware) || ((ItemCyberware)ware).getPowerProduction(ret) <= 0 && ware != CyberwareContent.creativeBattery) continue;
                hasProduce = true;
            }
        }
        this.missingPower = hasConsume && !hasProduce;
    }
}

