/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.handler;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.CyberwareHudDataEvent;
import flaxbeard.cyberware.api.hud.CyberwareHudEvent;
import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.api.hud.NotificationInstance;
import flaxbeard.cyberware.api.item.IHudjack;
import flaxbeard.cyberware.client.KeyBinds;
import flaxbeard.cyberware.client.gui.GuiHudConfiguration;
import flaxbeard.cyberware.client.gui.hud.MissingPowerDisplay;
import flaxbeard.cyberware.client.gui.hud.NotificationDisplay;
import flaxbeard.cyberware.client.gui.hud.PowerDisplay;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.CyberwareContent;
import java.util.List;
import java.util.Stack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class HudHandler {
    public static final HudHandler INSTANCE = new HudHandler();
    public static final ResourceLocation HUD_TEXTURE = new ResourceLocation("cyberware:textures/gui/hud.png");
    private static Iterable<ItemStack> inv;
    private static boolean lightArmor;
    public static Stack<NotificationInstance> notifications;
    private static int cachedCap;
    private static int cachedTotal;
    private static float cachedPercent;
    private static int radioRange;
    private static PowerDisplay pd;
    private static MissingPowerDisplay mpd;
    private static NotificationDisplay nd;
    private int lastTick = 0;
    private double lastVelX = 0.0;
    private double lastVelY = 0.0;
    private double lastVelZ = 0.0;
    private double lastLastVelX = 0.0;
    private double lastLastVelY = 0.0;
    private double lastLastVelZ = 0.0;

    public static void addNotification(NotificationInstance not) {
        notifications.push(not);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void addHudElements(CyberwareHudEvent event) {
        if (event.isHudjackAvailable()) {
            event.addElement(pd);
            event.addElement(mpd);
            event.addElement(nd);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void saveHudElements(CyberwareHudDataEvent event) {
        event.addElement(pd);
        event.addElement(mpd);
        event.addElement(nd);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onDrawScreenPost(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.POTION_ICONS) {
            boolean done;
            ICyberwareUserData data;
            GlStateManager.func_179094_E();
            Minecraft mc = Minecraft.func_71410_x();
            EntityPlayerSP p = mc.field_71439_g;
            float floatAmt = 0.0f;
            boolean active = false;
            if (CyberwareAPI.hasCapability((Entity)p)) {
                List<ItemStack> hudjackItems = CyberwareAPI.getCapability((Entity)p).getHudjackItems();
                for (ItemStack stack : hudjackItems) {
                    if (!((IHudjack)((Object)CyberwareAPI.getCyberware(stack))).isActive(stack)) continue;
                    active = true;
                    if (!CyberwareConfig.ENABLE_FLOAT) break;
                    if (CyberwareAPI.getCyberware(stack) == CyberwareContent.eyeUpgrades) {
                        floatAmt = CyberwareConfig.HUDLENS_FLOAT;
                        break;
                    }
                    floatAmt = CyberwareConfig.HUDJACK_FLOAT;
                    break;
                }
            }
            double accelLastY = this.lastVelY - this.lastLastVelY;
            double accelY = p.field_70181_x - this.lastVelY;
            double accelPitch = accelLastY + (accelY - accelLastY) * (double)(event.getPartialTicks() + (float)p.field_70173_aa - (float)this.lastTick) / 2.0;
            double pitchCameraMove = floatAmt * (p.field_71164_i + (p.field_71155_g - p.field_71164_i) * event.getPartialTicks() - p.field_70125_A);
            double yawCameraMove = floatAmt * (p.field_71163_h + (p.field_71154_f - p.field_71163_h) * event.getPartialTicks() - p.field_70177_z);
            GlStateManager.func_179137_b((double)yawCameraMove, (double)(pitchCameraMove + accelPitch * 50.0 * (double)floatAmt), (double)0.0);
            if (p.field_70173_aa > this.lastTick + 1) {
                this.lastTick = p.field_70173_aa;
                this.lastLastVelX = this.lastVelX;
                this.lastLastVelY = this.lastVelY;
                this.lastLastVelZ = this.lastVelZ;
                this.lastVelX = p.field_70159_w;
                this.lastVelY = p.field_70181_x;
                this.lastVelZ = p.field_70179_y;
            }
            CyberwareHudEvent hudEvent = new CyberwareHudEvent(event.getResolution(), active);
            MinecraftForge.EVENT_BUS.post((Event)hudEvent);
            List<IHudElement> elements = hudEvent.getElements();
            boolean active2 = hudEvent.isHudjackAvailable();
            ScaledResolution sr = event.getResolution();
            for (IHudElement element : elements) {
                if (element.getHeight() + GuiHudConfiguration.getAbsoluteY(sr, element) <= 3) {
                    GuiHudConfiguration.setYFromAbsolute(sr, element, 0 - element.getHeight() + 4);
                }
                if (GuiHudConfiguration.getAbsoluteY(sr, element) >= sr.func_78328_b() - 3) {
                    GuiHudConfiguration.setYFromAbsolute(sr, element, sr.func_78328_b() - 4);
                }
                if (element.getWidth() + GuiHudConfiguration.getAbsoluteX(sr, element) <= 3) {
                    GuiHudConfiguration.setXFromAbsolute(sr, element, 0 - element.getWidth() + 4);
                }
                if (GuiHudConfiguration.getAbsoluteX(sr, element) >= sr.func_78326_a() - 3) {
                    GuiHudConfiguration.setXFromAbsolute(sr, element, sr.func_78326_a() - 4);
                }
                GL11.glPushMatrix();
                element.render((EntityPlayer)p, sr, active2, mc.field_71462_r instanceof GuiHudConfiguration, event.getPartialTicks());
                GL11.glPopMatrix();
            }
            if (CyberwareAPI.hasCapability((Entity)mc.field_71439_g) && (data = CyberwareAPI.getCapability((Entity)mc.field_71439_g)).getActiveItems().size() > 0 && !(done = CyberwareAPI.getCapability((Entity)mc.field_71439_g).hasOpenedRadialMenu())) {
                String s = I18n.func_135052_a((String)"cyberware.gui.open_menu", (Object[])new Object[]{KeyBinds.menu.getDisplayName()});
                FontRenderer fr = mc.field_71466_p;
                fr.func_175063_a(s, (float)(sr.func_78326_a() - fr.func_78256_a(s) - 5), 5.0f, CyberwareAPI.getHUDColorHex());
            }
            GlStateManager.func_179121_F();
        }
    }

    static {
        lightArmor = false;
        notifications = new NotificationStack<NotificationInstance>(5);
        cachedCap = 0;
        cachedTotal = 0;
        cachedPercent = 0.0f;
        radioRange = -1;
        pd = new PowerDisplay();
        mpd = new MissingPowerDisplay();
        nd = new NotificationDisplay();
        nd.setHorizontalAnchor(IHudElement.EnumAnchorHorizontal.LEFT);
        nd.setVerticalAnchor(IHudElement.EnumAnchorVertical.BOTTOM);
    }

    private static class NotificationStack<T>
    extends Stack<T> {
        private int maxSize;

        public NotificationStack(int size) {
            this.maxSize = size;
        }

        @Override
        public Object push(Object object) {
            while (this.size() >= this.maxSize) {
                this.remove(0);
            }
            return super.push(object);
        }
    }
}

