/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.DodgePacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ItemBrainUpgrade
extends ItemCyberware
implements IMenuItem {
    private static Map<Integer, Boolean> isContextWorking = new HashMap<Integer, Boolean>();
    private static Map<Integer, Boolean> isMatrixWorking = new HashMap<Integer, Boolean>();
    private static Map<Integer, Boolean> isRadioWorking = new HashMap<Integer, Boolean>();
    private static ArrayList<String> lastHits = new ArrayList();
    private static final float[] f = new float[]{1.0f, 0.0f, 0.0f};

    public ItemBrainUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        return other.func_77973_b() == this && stack.func_77952_i() == 0 && other.func_77952_i() == 2;
    }

    @SubscribeEvent
    public void handleTeleJam(EnderTeleportEvent event) {
        EntityLivingBase te = event.getEntityLiving();
        if (CyberwareAPI.isCyberwareInstalled((Entity)te, new ItemStack((Item)this, 1, 1))) {
            event.setCanceled(true);
            return;
        }
        if (te != null) {
            float range = 25.0f;
            List test = te.field_70170_p.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(te.field_70165_t - (double)range, te.field_70163_u - (double)range, te.field_70161_v - (double)range, te.field_70165_t + (double)te.field_70130_N + (double)range, te.field_70163_u + (double)te.field_70131_O + (double)range, te.field_70161_v + (double)te.field_70130_N + (double)range));
            for (EntityLivingBase e : test) {
                if (!(te.func_70032_d((Entity)e) <= range) || !CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)this, 1, 1))) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void handleClone(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            EntityPlayer p = event.getOriginal();
            if (CyberwareAPI.isCyberwareInstalled((Entity)p, new ItemStack((Item)this, 1, 0)) && !p.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                if (!p.field_70170_p.field_72995_K) {
                    ItemStack stack = new ItemStack(CyberwareContent.expCapsule);
                    NBTTagCompound c = new NBTTagCompound();
                    c.func_74768_a("xp", p.field_71067_cb);
                    stack.func_77982_d(c);
                    EntityItem item = new EntityItem(p.field_70170_p, p.field_70165_t, p.field_70163_u, p.field_70161_v, stack);
                    p.field_70170_p.func_72838_d((Entity)item);
                }
            } else if (CyberwareAPI.isCyberwareInstalled((Entity)p, new ItemStack((Item)this, 1, 2)) && !p.field_70170_p.func_82736_K().func_82766_b("keepInventory")) {
                event.getEntityPlayer().func_71023_q((int)((float)Math.min(100, p.field_71068_ca * 7) * 0.9f));
            }
        }
    }

    @SubscribeEvent
    public void handleMining(PlayerEvent.BreakSpeed event) {
        ItemStack test;
        EntityPlayer p = event.getEntityPlayer();
        if (CyberwareAPI.isCyberwareInstalled((Entity)p, test = new ItemStack((Item)this, 1, 3)) && EnableDisableHelper.isEnabled(CyberwareAPI.getCyberware((Entity)p, test)) && this.isContextWorking((EntityLivingBase)p) && !p.func_70093_af()) {
            IBlockState state = event.getState();
            ItemStack tool = p.func_184586_b(EnumHand.MAIN_HAND);
            if (!tool.func_190926_b() && (tool.func_77973_b() instanceof ItemSword || tool.func_77973_b().func_77658_a().contains("sword"))) {
                return;
            }
            if (this.isToolEffective(tool, state)) {
                return;
            }
            for (int i = 0; i < 10; ++i) {
                ItemStack potentialTool;
                if (i == p.field_71071_by.field_70461_c || !this.isToolEffective(potentialTool = (ItemStack)p.field_71071_by.field_70462_a.get(i), state)) continue;
                p.field_71071_by.field_70461_c = i;
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        ItemStack test = new ItemStack((Item)this, 1, 3);
        if (e.field_70173_aa % 20 == 0 && CyberwareAPI.isCyberwareInstalled((Entity)e, test) && EnableDisableHelper.isEnabled(CyberwareAPI.getCyberware((Entity)e, test))) {
            isContextWorking.put(e.func_145782_y(), CyberwareAPI.getCapability((Entity)e).usePower(test, this.getPowerConsumption(test)));
        }
        test = new ItemStack((Item)this, 1, 4);
        if (e.field_70173_aa % 20 == 0 && CyberwareAPI.isCyberwareInstalled((Entity)e, test)) {
            isMatrixWorking.put(e.func_145782_y(), CyberwareAPI.getCapability((Entity)e).usePower(test, this.getPowerConsumption(test)));
        }
        test = new ItemStack((Item)this, 1, 5);
        if (e.field_70173_aa % 20 == 0 && CyberwareAPI.isCyberwareInstalled((Entity)e, test) && EnableDisableHelper.isEnabled(CyberwareAPI.getCyberware((Entity)e, test))) {
            isRadioWorking.put(e.func_145782_y(), CyberwareAPI.getCapability((Entity)e).usePower(test, this.getPowerConsumption(test)));
        }
    }

    private boolean isRadioWorking(EntityLivingBase e) {
        if (!isRadioWorking.containsKey(e.func_145782_y())) {
            isRadioWorking.put(e.func_145782_y(), false);
        }
        return isRadioWorking.get(e.func_145782_y());
    }

    private boolean isContextWorking(EntityLivingBase e) {
        if (!isContextWorking.containsKey(e.func_145782_y())) {
            isContextWorking.put(e.func_145782_y(), false);
        }
        return isContextWorking.get(e.func_145782_y());
    }

    private boolean isMatrixWorking(EntityLivingBase e) {
        if (!isMatrixWorking.containsKey(e.func_145782_y())) {
            isMatrixWorking.put(e.func_145782_y(), false);
        }
        return isMatrixWorking.get(e.func_145782_y());
    }

    public boolean isToolEffective(ItemStack tool, IBlockState state) {
        if (!tool.func_190926_b()) {
            for (String toolType : tool.func_77973_b().getToolClasses(tool)) {
                if (!state.func_177230_c().isToolEffective(toolType, state)) continue;
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public void handleXPDrop(LivingExperienceDropEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)this, 1, 0)) || CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)this, 1, 2))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleHurt(LivingAttackEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)this, 1, 4)) && this.isMatrixWorking(e) && !e.field_70170_p.field_72995_K && event.getSource() instanceof EntityDamageSource) {
            Entity attacker = ((EntityDamageSource)event.getSource()).func_76364_f();
            if (e instanceof EntityPlayer) {
                String str = e.func_145782_y() + " " + e.field_70173_aa + " " + attacker.func_145782_y();
                if (lastHits.contains(str)) {
                    return;
                }
                lastHits.add(str);
            }
            boolean armor = false;
            for (ItemStack stack : e.func_184193_aE()) {
                if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemArmor ? ((ItemArmor)stack.func_77973_b()).func_82812_d().func_78044_b(EntityEquipmentSlot.CHEST) > 4 : !stack.func_190926_b() && stack.func_77973_b() instanceof ISpecialArmor && ((ISpecialArmor)stack.func_77973_b()).getProperties((EntityLivingBase)e, (ItemStack)stack, (DamageSource)event.getSource(), (double)((double)event.getAmount()), (int)1).AbsorbRatio * 25.0 > 4.0) {
                    return;
                }
                if (stack.func_190926_b()) continue;
                armor = true;
            }
            if (!((float)e.field_70172_ad > (float)e.field_70771_an / 2.0f)) {
                Random random = e.func_70681_au();
                float f = random.nextFloat();
                float f2 = armor ? 0.7f : 0.65f;
                if (f < f2) {
                    event.setCanceled(true);
                    e.field_70172_ad = e.field_70771_an;
                    e.field_70738_aO = 10;
                    e.field_70737_aN = 10;
                    ReflectionHelper.setPrivateValue(EntityLivingBase.class, (Object)e, (Object)Float.valueOf(9999.0f), (int)47);
                    CyberwarePacketHandler.INSTANCE.sendToAllAround((IMessage)new DodgePacket(e.func_145782_y()), new NetworkRegistry.TargetPoint(e.field_70170_p.field_73011_w.getDimension(), e.field_70165_t, e.field_70163_u, e.field_70161_v, 50.0));
                }
            }
        }
    }

    @Override
    public int getPowerConsumption(ItemStack stack) {
        return stack.func_77952_i() == 3 ? 1 : (stack.func_77952_i() == 4 ? 8 : (stack.func_77952_i() == 5 ? 2 : 0));
    }

    @Override
    public boolean hasMenu(ItemStack stack) {
        return stack.func_77952_i() == 3 || stack.func_77952_i() == 5;
    }

    @Override
    public void use(Entity e, ItemStack stack) {
        EnableDisableHelper.toggle(stack);
    }

    @Override
    public String getUnlocalizedLabel(ItemStack stack) {
        return EnableDisableHelper.getUnlocalizedLabel(stack);
    }

    @Override
    public float[] getColor(ItemStack stack) {
        return (float[])(EnableDisableHelper.isEnabled(stack) ? f : null);
    }
}

