/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import flaxbeard.cyberware.Cyberware;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.IMenuItem;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemCyberware;
import flaxbeard.cyberware.common.misc.NNLUtil;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.GuiPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.NonNullList;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHandUpgrade
extends ItemCyberware
implements IMenuItem {
    private Map<Integer, Boolean> lastClaws = new HashMap<Integer, Boolean>();
    public static float clawsTime;
    private static final UUID strengthId;
    private static final float[] f;

    public ItemHandUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public NonNullList<NonNullList<ItemStack>> required(ItemStack stack) {
        return NNLUtil.fromArray(new ItemStack[][]{{new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 0), new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 1)}});
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void handleOpenInv(GuiOpenEvent event) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null && event.getGui() != null && event.getGui().getClass() == GuiInventory.class && !Minecraft.func_71410_x().field_71439_g.func_184812_l_() && CyberwareAPI.isCyberwareInstalled((Entity)Minecraft.func_71410_x().field_71439_g, new ItemStack((Item)this, 1, 0))) {
            event.setCanceled(true);
            Minecraft.func_71410_x().field_71439_g.openGui((Object)Cyberware.INSTANCE, 1, Minecraft.func_71410_x().field_71439_g.field_70170_p, 0, 0, 0);
            CyberwarePacketHandler.INSTANCE.sendToServer((IMessage)new GuiPacket(1, 0, 0, 0));
        }
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        return other.func_77973_b() == this;
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void handleLivingUpdate(CyberwareUpdateEvent event) {
        ItemStack test;
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, test = new ItemStack((Item)this, 1, 1))) {
            boolean isEquipped;
            boolean last = this.getLastClaws(e);
            boolean bl = e.func_184614_ca().func_190926_b() && (e.func_184591_cq() == EnumHandSide.RIGHT ? CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 1)) : CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 0))) ? true : (isEquipped = false);
            if (isEquipped && EnableDisableHelper.isEnabled(CyberwareAPI.getCyberware((Entity)e, test))) {
                this.addUnarmedDamage(e, test);
                this.lastClaws.put(e.func_145782_y(), true);
                if (!last && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
                    this.updateHand(e, true);
                }
            } else {
                this.removeUnarmedDamage(e, test);
                this.lastClaws.put(e.func_145782_y(), false);
            }
        } else {
            this.lastClaws.put(e.func_145782_y(), false);
        }
    }

    private void updateHand(EntityLivingBase e, boolean delay) {
        if (Minecraft.func_71410_x() != null && Minecraft.func_71410_x().field_71439_g != null && e == Minecraft.func_71410_x().field_71439_g) {
            clawsTime = Minecraft.func_71410_x().func_184121_ak() + (float)e.field_70173_aa + (float)(delay ? 5 : 0);
        }
    }

    private boolean getLastClaws(EntityLivingBase e) {
        if (!this.lastClaws.containsKey(e.func_145782_y())) {
            this.lastClaws.put(e.func_145782_y(), false);
        }
        return this.lastClaws.get(e.func_145782_y());
    }

    public void addUnarmedDamage(EntityLivingBase entity, ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(strengthId, "Claws damage upgrade", 5.5, 0));
            entity.func_110140_aT().func_111147_b((Multimap)multimap);
        }
    }

    public void removeUnarmedDamage(EntityLivingBase entity, ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(strengthId, "Claws Claws upgrade", 5.5, 0));
            entity.func_110140_aT().func_111148_a((Multimap)multimap);
        }
    }

    @Override
    public void onRemoved(EntityLivingBase entity, ItemStack stack) {
        if (stack.func_77952_i() == 1) {
            this.removeUnarmedDamage(entity, stack);
        }
    }

    @SubscribeEvent
    public void handleMining(PlayerEvent.HarvestCheck event) {
        ItemStack pick;
        boolean rightArm;
        EntityPlayer p = event.getEntityPlayer();
        ItemStack test = new ItemStack((Item)this, 1, 2);
        boolean bl = rightArm = p.func_184591_cq() == EnumHandSide.RIGHT ? CyberwareAPI.isCyberwareInstalled((Entity)p, new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 1)) : CyberwareAPI.isCyberwareInstalled((Entity)p, new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 0));
        if (rightArm && CyberwareAPI.isCyberwareInstalled((Entity)p, test) && p.func_184614_ca().func_190926_b() && (pick = new ItemStack(Items.field_151050_s)).func_150998_b(event.getTargetBlock())) {
            event.setCanHarvest(true);
        }
    }

    @SubscribeEvent
    public void handleMineSpeed(PlayerEvent.BreakSpeed event) {
        boolean rightArm;
        EntityPlayer p = event.getEntityPlayer();
        ItemStack test = new ItemStack((Item)this, 1, 2);
        boolean bl = rightArm = p.func_184591_cq() == EnumHandSide.RIGHT ? CyberwareAPI.isCyberwareInstalled((Entity)p, new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 1)) : CyberwareAPI.isCyberwareInstalled((Entity)p, new ItemStack((Item)CyberwareContent.cyberlimbs, 1, 0));
        if (rightArm && CyberwareAPI.isCyberwareInstalled((Entity)p, test) && p.func_184614_ca().func_190926_b()) {
            ItemStack pick = new ItemStack(Items.field_151050_s);
            event.setNewSpeed(event.getNewSpeed() * pick.func_150997_a(p.field_70170_p.func_180495_p(event.getPos())));
        }
    }

    @Override
    public boolean hasMenu(ItemStack stack) {
        return stack.func_77952_i() == 1;
    }

    @Override
    public void use(Entity e, ItemStack stack) {
        EnableDisableHelper.toggle(stack);
        if (e instanceof EntityLivingBase && FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.updateHand((EntityLivingBase)e, false);
        }
    }

    @Override
    public String getUnlocalizedLabel(ItemStack stack) {
        return EnableDisableHelper.getUnlocalizedLabel(stack);
    }

    @Override
    public float[] getColor(ItemStack stack) {
        return (float[])(EnableDisableHelper.isEnabled(stack) ? f : null);
    }

    static {
        strengthId = UUID.fromString("63c32801-94fb-40d4-8bd2-89135c1e44b1");
        f = new float[]{1.0f, 0.0f, 0.0f};
    }
}

