/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.api.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public interface ICyberware {
    public EnumSlot getSlot(ItemStack var1);

    public int installedStackSize(ItemStack var1);

    public ItemStack[][] required(ItemStack var1);

    public boolean isIncompatible(ItemStack var1, ItemStack var2);

    public boolean isEssential(ItemStack var1);

    public List<String> getInfo(ItemStack var1);

    public int getCapacity(ItemStack var1);

    public Quality getQuality(ItemStack var1);

    public ItemStack setQuality(ItemStack var1, Quality var2);

    public boolean canHoldQuality(ItemStack var1, Quality var2);

    public void onAdded(EntityLivingBase var1, ItemStack var2);

    public void onRemoved(EntityLivingBase var1, ItemStack var2);

    public int getEssenceCost(ItemStack var1);

    public static interface ISidedLimb {
        public EnumSide getSide(ItemStack var1);

        public static enum EnumSide {
            LEFT,
            RIGHT;

        }
    }

    public static enum EnumSlot {
        EYES(12, "eyes"),
        CRANIUM(11, "cranium"),
        HEART(14, "heart"),
        LUNGS(15, "lungs"),
        LOWER_ORGANS(17, "lowerOrgans"),
        SKIN(18, "skin"),
        MUSCLE(19, "muscle"),
        BONE(20, "bone"),
        ARM(21, "arm", true, true),
        HAND(22, "hand", true, false),
        LEG(23, "leg", true, true),
        FOOT(24, "foot", true, false);

        private final int slotNumber;
        private final String name;
        private final boolean sidedSlot;
        private final boolean hasEssential;

        private EnumSlot(int slot, String name, boolean sidedSlot, boolean hasEssential) {
            this.slotNumber = slot;
            this.name = name;
            this.sidedSlot = sidedSlot;
            this.hasEssential = hasEssential;
        }

        private EnumSlot(int slot, String name) {
            this(slot, name, false, true);
        }

        public int getSlotNumber() {
            return this.slotNumber;
        }

        public static EnumSlot getSlotByPage(int page) {
            for (EnumSlot slot : EnumSlot.values()) {
                if (slot.getSlotNumber() != page) continue;
                return slot;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSided() {
            return this.sidedSlot;
        }

        public boolean hasEssential() {
            return this.hasEssential;
        }
    }

    public static class Quality {
        private static Map<String, Quality> mapping = new HashMap<String, Quality>();
        public static List<Quality> qualities = new ArrayList<Quality>();
        private String unlocalizedName;
        private String nameModifier;
        private String spriteSuffix;

        public Quality(String unlocalizedName) {
            this(unlocalizedName, null, null);
        }

        public Quality(String unlocalizedName, String nameModifier, String spriteSuffix) {
            this.unlocalizedName = unlocalizedName;
            this.nameModifier = nameModifier;
            this.spriteSuffix = spriteSuffix;
            mapping.put(unlocalizedName, this);
            qualities.add(this);
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public static Quality getQualityFromString(String name) {
            if (mapping.containsKey(name)) {
                return mapping.get(name);
            }
            return null;
        }

        public String getNameModifier() {
            return this.nameModifier;
        }

        public String getSpriteSuffix() {
            return this.spriteSuffix;
        }
    }
}

