/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.CyberwareHudDataEvent;
import flaxbeard.cyberware.api.hud.CyberwareHudEvent;
import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.api.item.IHudjack;
import flaxbeard.cyberware.client.ClientUtils;
import flaxbeard.cyberware.client.gui.hud.HudNBTData;
import flaxbeard.cyberware.common.handler.HudHandler;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.SyncHudDataPacket;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiHudConfiguration
extends GuiScreen {
    IHudElement dragging = null;
    IHudElement hoveredElement = null;
    int offsetX = 0;
    int offsetY = 0;
    ScaledResolution sr = null;
    boolean clicked = false;

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.sr = new ScaledResolution(this.field_146297_k);
        GlStateManager.func_179094_E();
        Minecraft mc = Minecraft.func_71410_x();
        boolean active = false;
        if (CyberwareAPI.hasCapability((Entity)mc.field_71439_g)) {
            List<ItemStack> hudjackItems = CyberwareAPI.getCapability((Entity)mc.field_71439_g).getHudjackItems();
            for (ItemStack itemStack : hudjackItems) {
                if (!((IHudjack)((Object)CyberwareAPI.getCyberware(itemStack))).isActive(itemStack)) continue;
                active = true;
                break;
            }
        }
        CyberwareHudEvent hudEvent = new CyberwareHudEvent(this.sr, active);
        MinecraftForge.EVENT_BUS.post((Event)hudEvent);
        List<IHudElement> elements = hudEvent.getElements();
        this.hoveredElement = null;
        for (IHudElement element : elements) {
            int elemY;
            int elemX;
            if (this.hoveredElement != null || this.dragging != null || !this.isPointInRegion(elemX = GuiHudConfiguration.getAbsoluteX(this.sr, element), elemY = GuiHudConfiguration.getAbsoluteY(this.sr, element), element.getWidth(), element.getHeight(), mouseX, mouseY)) continue;
            this.hoveredElement = element;
            this.offsetX = mouseX - elemX;
            this.offsetY = mouseY - elemY;
        }
        for (IHudElement element : elements) {
            this.drawBox(element, mouseX, mouseY);
            this.drawButtons(element, mouseX, mouseY);
        }
        for (IHudElement element : elements) {
            this.drawButtonTooltips(element, mouseX, mouseY);
        }
        if (this.dragging != null) {
            int n = mouseX - this.offsetX;
            int moveToY = mouseY - this.offsetY;
            GuiHudConfiguration.setXFromAbsolute(this.sr, this.dragging, n);
            GuiHudConfiguration.setYFromAbsolute(this.sr, this.dragging, moveToY);
            GameSettings cfr_ignored_0 = mc.field_71474_y;
            if (GameSettings.func_100015_a((KeyBinding)mc.field_71474_y.field_74311_E)) {
                this.dragging.setX(Math.round((float)this.dragging.getX() / 5.0f) * 5);
                this.dragging.setY(Math.round((float)this.dragging.getY() / 5.0f) * 5);
            }
            ArrayList<String> l = new ArrayList<String>();
            l.add(this.dragging.getX() + ", " + this.dragging.getY());
            ClientUtils.drawHoveringText(this, l, mouseX, mouseY, mc.field_71466_p);
        } else if (this.hoveredElement != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(this.hoveredElement.getX() + ", " + this.hoveredElement.getY());
            ClientUtils.drawHoveringText(this, arrayList, mouseX, mouseY, mc.field_71466_p);
        }
        GlStateManager.func_179121_F();
        this.clicked = false;
    }

    private void drawBox(IHudElement element, int mouseX, int mouseY) {
        int height;
        int width;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
        int elemX = GuiHudConfiguration.getAbsoluteX(this.sr, element) - 1;
        int elemY = GuiHudConfiguration.getAbsoluteY(this.sr, element) - 1;
        GL11.glPushMatrix();
        float[] color = CyberwareAPI.getHUDColor();
        GL11.glColor3f((float)color[0], (float)color[1], (float)color[2]);
        if (element == this.dragging || element == this.hoveredElement) {
            int elemPosY;
            int elemPosX;
            boolean right = element.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT;
            boolean bottom = element.getVerticalAnchor() == IHudElement.EnumAnchorVertical.BOTTOM;
            int pos = right ? GuiHudConfiguration.getAbsoluteX(this.sr, element) + element.getWidth() : 0;
            int posY = bottom ? elemY + element.getHeight() + 1 : elemY;
            posY = Math.max(1, posY);
            posY = Math.min(this.sr.func_78328_b() - 2, posY);
            for (elemPosX = element.getX(); elemPosX >= 2; elemPosX -= 2) {
                ClientUtils.drawTexturedModalRect(pos, posY, 255, 0, 1, 1);
                pos += 2;
            }
            ClientUtils.drawTexturedModalRect(pos, posY, 255, 0, elemPosX, 1);
            pos = bottom ? GuiHudConfiguration.getAbsoluteY(this.sr, element) + element.getHeight() : 0;
            int posX = right ? elemX + element.getWidth() + 1 : elemX;
            posX = Math.max(1, posX);
            posX = Math.min(this.sr.func_78326_a() - 2, posX);
            for (elemPosY = element.getY(); elemPosY >= 2; elemPosY -= 2) {
                ClientUtils.drawTexturedModalRect(posX, pos, 255, 0, 1, 1);
                pos += 2;
            }
            ClientUtils.drawTexturedModalRect(posX, pos, 255, 0, 1, elemPosY);
        }
        boolean shift = this.field_146297_k.field_71439_g.field_70173_aa / 4 % 2 == 0;
        int one = shift ? 254 : 255;
        int two = shift ? 255 : 254;
        int pos = 0;
        for (width = element.getWidth() + 2; width >= 2; width -= 2) {
            ClientUtils.drawTexturedModalRect(elemX + pos, elemY, one, 0, 1, 1);
            ClientUtils.drawTexturedModalRect(elemX + pos + 1, elemY, two, 0, 1, 1);
            ClientUtils.drawTexturedModalRect(elemX + pos, elemY + element.getHeight() + 1, one, 0, 1, 1);
            ClientUtils.drawTexturedModalRect(elemX + pos + 1, elemY + element.getHeight() + 1, two, 0, 1, 1);
            pos += 2;
        }
        ClientUtils.drawTexturedModalRect(elemX, elemY, one, 0, width, 1);
        ClientUtils.drawTexturedModalRect(elemX, elemY + element.getHeight() + 1, 255, 0, width, 1);
        pos = 0;
        for (height = element.getHeight() + 2; height >= 2; height -= 2) {
            ClientUtils.drawTexturedModalRect(elemX, elemY + pos, one, 0, 1, 1);
            ClientUtils.drawTexturedModalRect(elemX, elemY + pos + 1, two, 0, 1, 1);
            ClientUtils.drawTexturedModalRect(elemX + element.getWidth() + 1, elemY + pos, one, 0, 1, 1);
            ClientUtils.drawTexturedModalRect(elemX + element.getWidth() + 1, elemY + pos + 1, two, 0, 1, 1);
            pos += 2;
        }
        ClientUtils.drawTexturedModalRect(elemX, elemY + pos, one, 0, 1, height);
        ClientUtils.drawTexturedModalRect(elemX + element.getWidth() + 1, elemY + pos, two, 0, 1, height);
        GL11.glPopMatrix();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected boolean isPointInRegion(int rectX, int rectY, int rectWidth, int rectHeight, int pointX, int pointY) {
        return pointX >= rectX - 1 && pointX < rectX + rectWidth + 1 && pointY >= rectY - 1 && pointY < rectY + rectHeight + 1;
    }

    private void drawButtonTooltips(IHudElement element, int mouseX, int mouseY) {
        ArrayList<String> l;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
        int elemX = GuiHudConfiguration.getAbsoluteX(this.sr, element) - 1;
        int elemY = GuiHudConfiguration.getAbsoluteY(this.sr, element) - 1;
        int buttonsY = elemY + element.getHeight() + 10 > this.sr.func_78328_b() ? elemY - 11 : elemY + element.getHeight() + 4;
        int buttonsX = elemX + 5;
        boolean showHideHover = false;
        boolean hidden = false;
        if (element.canHide()) {
            showHideHover = this.isPointInRegion(buttonsX, buttonsY, 9, 9, mouseX, mouseY);
            hidden = element.isHidden();
            buttonsX += 11;
        }
        boolean upDownHover = this.isPointInRegion(buttonsX, buttonsY, 9, 9, mouseX, mouseY);
        boolean down = element.getVerticalAnchor() != IHudElement.EnumAnchorVertical.BOTTOM;
        boolean leftRightHover = this.isPointInRegion(buttonsX += 11, buttonsY, 9, 9, mouseX, mouseY);
        boolean right = element.getHorizontalAnchor() != IHudElement.EnumAnchorHorizontal.RIGHT;
        boolean resetHover = this.isPointInRegion(buttonsX += 11, buttonsY, 9, 9, mouseX, mouseY);
        if (upDownHover) {
            l = new ArrayList<String>();
            l.add(I18n.func_135052_a((String)(down ? "cyberware.gui.stickDown" : "cyberware.gui.stickUp"), (Object[])new Object[0]));
            ClientUtils.drawHoveringText(this, l, mouseX, mouseY, this.field_146297_k.field_71466_p);
            if (this.clicked) {
                this.flipVertical(element);
            }
        }
        if (showHideHover) {
            l = new ArrayList();
            l.add(I18n.func_135052_a((String)(hidden ? "cyberware.gui.show" : "cyberware.gui.hide"), (Object[])new Object[0]));
            ClientUtils.drawHoveringText(this, l, mouseX, mouseY, this.field_146297_k.field_71466_p);
            if (this.clicked) {
                element.setHidden(!hidden);
            }
        }
        if (resetHover) {
            l = new ArrayList();
            l.add(I18n.func_135052_a((String)"cyberware.gui.resetHud", (Object[])new Object[0]));
            ClientUtils.drawHoveringText(this, l, mouseX, mouseY, this.field_146297_k.field_71466_p);
            if (this.clicked) {
                element.reset();
            }
        }
        if (leftRightHover) {
            l = new ArrayList();
            l.add(I18n.func_135052_a((String)(right ? "cyberware.gui.stickRight" : "cyberware.gui.stickLeft"), (Object[])new Object[0]));
            ClientUtils.drawHoveringText(this, l, mouseX, mouseY, this.field_146297_k.field_71466_p);
            if (this.clicked) {
                this.flipHorizontal(element);
            }
        }
    }

    private void drawButtons(IHudElement element, int mouseX, int mouseY) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
        int elemX = GuiHudConfiguration.getAbsoluteX(this.sr, element) - 1;
        int elemY = GuiHudConfiguration.getAbsoluteY(this.sr, element) - 1;
        int buttonsY = elemY + element.getHeight() + 10 > this.sr.func_78328_b() ? elemY - 11 : elemY + element.getHeight() + 4;
        int buttonsX = elemX + 5;
        boolean showHideHover = false;
        boolean hidden = false;
        if (element.canHide()) {
            showHideHover = this.isPointInRegion(buttonsX, buttonsY, 9, 9, mouseX, mouseY);
            ClientUtils.drawTexturedModalRect(buttonsX, buttonsY, showHideHover ^ (hidden = element.isHidden()) ? 125 : 116, 0, 9, 9);
            buttonsX += 11;
        }
        boolean upDownHover = this.isPointInRegion(buttonsX, buttonsY, 9, 9, mouseX, mouseY);
        boolean down = element.getVerticalAnchor() != IHudElement.EnumAnchorVertical.BOTTOM;
        ClientUtils.drawTexturedModalRect(buttonsX, buttonsY, down ^ upDownHover ? 80 : 89, 0, 9, 9);
        boolean leftRightHover = this.isPointInRegion(buttonsX += 11, buttonsY, 9, 9, mouseX, mouseY);
        boolean right = element.getHorizontalAnchor() != IHudElement.EnumAnchorHorizontal.RIGHT;
        ClientUtils.drawTexturedModalRect(buttonsX, buttonsY, right ^ leftRightHover ? 98 : 107, 0, 9, 9);
        boolean resetHover = this.isPointInRegion(buttonsX += 11, buttonsY, 9, 9, mouseX, mouseY);
        ClientUtils.drawTexturedModalRect(buttonsX, buttonsY, 134, 0, 9, 9);
        buttonsX += 11;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 0) {
            if (this.dragging == null) {
                this.dragging = this.hoveredElement;
            }
            this.clicked = true;
        }
        if (mouseButton == 1 && this.hoveredElement != null) {
            this.flipVertical(this.hoveredElement);
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.dragging != null) {
            this.dragging = null;
        }
    }

    public static int getAbsoluteX(ScaledResolution sr, IHudElement element) {
        if (element.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT) {
            return sr.func_78326_a() - element.getX() - element.getWidth();
        }
        return element.getX();
    }

    public static int getAbsoluteY(ScaledResolution sr, IHudElement element) {
        if (element.getVerticalAnchor() == IHudElement.EnumAnchorVertical.BOTTOM) {
            return sr.func_78328_b() - element.getY() - element.getHeight();
        }
        return element.getY();
    }

    public static void setXFromAbsolute(ScaledResolution sr, IHudElement element, int x) {
        if (element.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT) {
            element.setX(sr.func_78326_a() - x - element.getWidth());
        } else {
            element.setX(x);
        }
    }

    public static void setYFromAbsolute(ScaledResolution sr, IHudElement element, int y) {
        if (element.getVerticalAnchor() == IHudElement.EnumAnchorVertical.BOTTOM) {
            element.setY(sr.func_78328_b() - y - element.getHeight());
        } else {
            element.setY(y);
        }
    }

    private void flipVertical(IHudElement element) {
        int y = GuiHudConfiguration.getAbsoluteY(this.sr, element);
        element.setVerticalAnchor(element.getVerticalAnchor() == IHudElement.EnumAnchorVertical.BOTTOM ? IHudElement.EnumAnchorVertical.TOP : IHudElement.EnumAnchorVertical.BOTTOM);
        GuiHudConfiguration.setYFromAbsolute(this.sr, element, y);
    }

    private void flipHorizontal(IHudElement element) {
        int x = GuiHudConfiguration.getAbsoluteX(this.sr, element);
        element.setHorizontalAnchor(element.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT ? IHudElement.EnumAnchorHorizontal.LEFT : IHudElement.EnumAnchorHorizontal.RIGHT);
        GuiHudConfiguration.setXFromAbsolute(this.sr, element, x);
    }

    public void func_73876_c() {
        if (this.field_146297_k != null && this.field_146297_k.field_71474_y != null) {
            GameSettings cfr_ignored_0 = this.field_146297_k.field_71474_y;
            if (GameSettings.func_100015_a((KeyBinding)this.field_146297_k.field_71474_y.field_151445_Q)) {
                this.field_146297_k.func_147108_a(null);
            }
        }
        super.func_73876_c();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146281_b() {
        NBTTagCompound comp = new NBTTagCompound();
        CyberwareHudDataEvent hudEvent = new CyberwareHudDataEvent();
        MinecraftForge.EVENT_BUS.post((Event)hudEvent);
        List<IHudElement> elements = hudEvent.getElements();
        for (IHudElement element : elements) {
            HudNBTData elementData = new HudNBTData(new NBTTagCompound());
            element.save(elementData);
            comp.func_74782_a(element.getUniqueName(), (NBTBase)elementData.getTag());
        }
        if (this.field_146297_k.field_71439_g != null) {
            ICyberwareUserData data = CyberwareAPI.getCapability((Entity)this.field_146297_k.field_71439_g);
            NBTTagCompound oldComp = data.getHudData();
            data.setHudData(comp);
        }
        CyberwarePacketHandler.INSTANCE.sendToServer((IMessage)new SyncHudDataPacket(comp));
    }
}

