/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui.hud;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.HudElementBase;
import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.handler.HudHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class MissingPowerDisplay
extends HudElementBase {
    private static final List<ItemStack> exampleStacks = new ArrayList<ItemStack>();

    public MissingPowerDisplay() {
        super("cyberware:missingPower");
        this.setDefaultX(-15);
        this.setDefaultY(35);
        this.setWidth(36);
        this.setHeight(144);
    }

    @Override
    public void renderElement(int x, int y, EntityPlayer p, ScaledResolution resolution, boolean hudjackAvailable, boolean isConfigOpen, float partialTicks) {
        if (!this.isHidden() && hudjackAvailable) {
            boolean flipHoriz = this.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT;
            float currTime = (float)p.field_70173_aa + partialTicks;
            GL11.glPushMatrix();
            GlStateManager.func_179147_l();
            ICyberwareUserData data = CyberwareAPI.getCapability((Entity)p);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            RenderItem ir = Minecraft.func_71410_x().func_175599_af();
            List<ItemStack> stacks = isConfigOpen ? exampleStacks : data.getPowerOutages();
            List<Integer> stackTimes = data.getPowerOutageTimes();
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            float zL = ir.field_77023_b;
            ir.field_77023_b = -300.0f;
            int left = x - 1 + (flipHoriz ? 0 : 20);
            int top = y;
            for (int i = stacks.size() - 1; i >= 0; --i) {
                ItemStack stack = stacks.get(i);
                if (stack == null) continue;
                int time = (int)currTime;
                if (isConfigOpen) {
                    if (i == 0) {
                        time = (int)(currTime - 20.0f - (float)(p.field_70173_aa % 40));
                    }
                } else {
                    time = stackTimes.get(i);
                }
                boolean keep = p.field_70173_aa - time < 50;
                double pct = Math.max(0.0f, (currTime - (float)time - 20.0f) / 30.0f);
                float move = (float)(20.0 * Math.sin(pct * 1.5707963267948966));
                if (keep) {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(flipHoriz ? move : -move), (float)0.0f, (float)0.0f);
                    fr.func_175063_a("!", (float)(left + 14), (float)(top + 8), 0xFF0000);
                    RenderHelper.func_74519_b();
                    ir.func_180450_b(stack, left, top);
                    RenderHelper.func_74518_a();
                    GL11.glPopMatrix();
                    top += 18;
                    continue;
                }
                if (isConfigOpen) continue;
                toRemove.add(i);
            }
            ir.field_77023_b = zL;
            Iterator iterator = toRemove.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                stacks.remove(i);
                stackTimes.remove(i);
            }
            GL11.glPopMatrix();
        }
    }

    static {
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
        exampleStacks.add(new ItemStack((Item)CyberwareContent.cybereyes));
    }
}

