/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.client.gui.hud;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.hud.HudElementBase;
import flaxbeard.cyberware.api.hud.IHudElement;
import flaxbeard.cyberware.client.ClientUtils;
import flaxbeard.cyberware.common.handler.HudHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;

public class PowerDisplay
extends HudElementBase {
    private static int cachedCap = 0;
    private static int cachedTotal = 0;
    private static float cachedPercent = 0.0f;
    private static int cachedProd = 0;
    private static int cachedCons = 0;

    public PowerDisplay() {
        super("cyberware:power");
        this.setDefaultX(5);
        this.setDefaultY(5);
        this.setHeight(25);
        this.setWidth(101);
    }

    @Override
    public void renderElement(int x, int y, EntityPlayer p, ScaledResolution resolution, boolean hudjackAvailable, boolean isConfigOpen, float partialTicks) {
        if (!this.isHidden() && hudjackAvailable) {
            boolean flipHoriz = this.getHorizontalAnchor() == IHudElement.EnumAnchorHorizontal.RIGHT;
            float currTime = (float)p.field_70173_aa + partialTicks;
            GL11.glPushMatrix();
            GlStateManager.func_179147_l();
            ICyberwareUserData data = CyberwareAPI.getCapability((Entity)p);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(HudHandler.HUD_TEXTURE);
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            if (p.field_70173_aa % 20 == 0) {
                cachedPercent = data.getPercentFull();
                cachedCap = data.getCapacity();
                cachedTotal = data.getStoredPower();
                cachedProd = data.getProduction();
                cachedCons = data.getConsumption();
            }
            float[] color = CyberwareAPI.getHUDColor();
            int colorHex = CyberwareAPI.getHUDColorHex();
            if (cachedPercent != -1.0f) {
                int xOffset;
                int amount = Math.round(21.0f * cachedPercent);
                boolean danger = cachedPercent <= 0.2f;
                boolean superDanger = danger && cachedPercent <= 0.05f;
                int n = xOffset = danger ? 39 : 0;
                if (!superDanger || p.field_70173_aa % 4 != 0) {
                    int moveX = flipHoriz ? x + this.getWidth() - 13 : x;
                    GlStateManager.func_179094_E();
                    if (!danger) {
                        GlStateManager.func_179124_c((float)color[0], (float)color[1], (float)color[2]);
                    }
                    ClientUtils.drawTexturedModalRect(moveX, y, xOffset, 0, 13, 2 + (21 - amount));
                    ClientUtils.drawTexturedModalRect(moveX, y + 2 + (21 - amount), 13 + xOffset, 2 + (21 - amount), 13, amount + 2);
                    ClientUtils.drawTexturedModalRect(moveX, y + 2 + (21 - amount), 26 + xOffset, 2 + (21 - amount), 13, amount + 2);
                    GlStateManager.func_179121_F();
                    String output = cachedTotal + " / " + cachedCap;
                    int textX = flipHoriz ? x + this.getWidth() - 15 - fr.func_78256_a(output) : x + 15;
                    fr.func_175063_a(output, (float)textX, (float)(y + 4), danger ? 0xFF0000 : colorHex);
                    output = "-" + cachedCons + " / +" + cachedProd;
                    textX = flipHoriz ? x + this.getWidth() - 15 - fr.func_78256_a(output) : x + 15;
                    fr.func_175063_a(output, (float)textX, (float)(y + 14), danger ? 0xFF0000 : colorHex);
                }
            }
            GL11.glPopMatrix();
        }
    }
}

