/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.block.tile;

import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.item.IBlueprint;
import flaxbeard.cyberware.common.CyberwareConfig;
import flaxbeard.cyberware.common.item.ItemBlueprint;
import flaxbeard.cyberware.common.misc.SpecificWrapper;
import flaxbeard.cyberware.common.network.CyberwarePacketHandler;
import flaxbeard.cyberware.common.network.ScannerSmashPacket;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RangedWrapper;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityEngineeringTable
extends TileEntity
implements ITickable {
    public ItemStackHandlerEngineering slots = new ItemStackHandlerEngineering(this, 10);
    private final RangedWrapper slotsTopSides = new RangedWrapper((IItemHandlerModifiable)this.slots, 0, 7);
    private final SpecificWrapper slotsBottom = new SpecificWrapper((IItemHandlerModifiable)this.slots, 2, 3, 4, 5, 6, 7, 9);
    public final GuiWrapper guiSlots = new GuiWrapper(this.slots);
    public String customName = null;
    public float clickedTime = -100.0f;
    private int time;
    public HashMap<String, BlockPos> lastPlayerArchive = new HashMap();

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.slotsBottom;
            }
            return (T)this.slotsTopSides;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.slots.deserializeNBT(compound.func_74775_l("inv"));
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        this.time = compound.func_74762_e("time");
        this.lastPlayerArchive = new HashMap();
        NBTTagList list = (NBTTagList)compound.func_74781_a("playerArchive");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound comp = list.func_150305_b(i);
            String name = comp.func_74779_i("name");
            int x = comp.func_74762_e("x");
            int y = comp.func_74762_e("y");
            int z = comp.func_74762_e("z");
            BlockPos pos = new BlockPos(x, y, z);
            this.lastPlayerArchive.put(name, pos);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74782_a("inv", (NBTBase)this.slots.serializeNBT());
        if (this.hasCustomName()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        compound.func_74768_a("time", this.time);
        NBTTagList list = new NBTTagList();
        for (String name : this.lastPlayerArchive.keySet()) {
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74778_a("name", name);
            BlockPos pos = this.lastPlayerArchive.get(name);
            entry.func_74768_a("x", pos.func_177958_n());
            entry.func_74768_a("y", pos.func_177956_o());
            entry.func_74768_a("z", pos.func_177952_p());
            list.func_74742_a((NBTBase)entry);
        }
        compound.func_74782_a("playerArchive", (NBTBase)list);
        return compound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound data = pkt.func_148857_g();
        this.func_145839_a(data);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound data = new NBTTagCompound();
        this.func_189515_b(data);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, data);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public String getName() {
        return this.hasCustomName() ? this.customName : "cyberware.container.engineering";
    }

    public boolean hasCustomName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomInventoryName(String p_145951_1_) {
        this.customName = p_145951_1_;
    }

    public ITextComponent getDisplayName() {
        return this.hasCustomName() ? new TextComponentString(this.getName()) : new TextComponentTranslation(this.getName(), new Object[0]);
    }

    public void updateRecipe() {
        ItemStack blueprintStack = this.slots.getStackInSlot(8);
        if (blueprintStack != null && blueprintStack.func_77973_b() instanceof IBlueprint) {
            IBlueprint blueprint = (IBlueprint)blueprintStack.func_77973_b();
            ItemStack[] toCheck = new ItemStack[6];
            for (int i = 0; i < 6; ++i) {
                toCheck[i] = ItemStack.func_77944_b((ItemStack)this.slots.getStackInSlot(i + 2));
            }
            ItemStack result = ItemStack.func_77944_b((ItemStack)blueprint.getResult(blueprintStack, toCheck));
            if (result != null) {
                result.field_77994_a = 1;
            }
            this.slots.setStackInSlot(9, result);
        } else {
            this.slots.setStackInSlot(9, null);
        }
    }

    public void subtractResources() {
        ItemStack blueprintStack = this.slots.getStackInSlot(8);
        if (blueprintStack != null && blueprintStack.func_77973_b() instanceof IBlueprint) {
            IBlueprint blueprint = (IBlueprint)blueprintStack.func_77973_b();
            ItemStack[] toCheck = new ItemStack[6];
            for (int i = 0; i < 6; ++i) {
                toCheck[i] = ItemStack.func_77944_b((ItemStack)this.slots.getStackInSlot(i + 2));
            }
            ItemStack[] result = blueprint.consumeItems(blueprintStack, toCheck);
            for (int i = 0; i < 6; ++i) {
                this.slots.setStackInSlot(i + 2, result[i]);
            }
        } else {
            throw new IllegalStateException("Tried to subtract resources when no blueprint was available!");
        }
        this.updateRecipe();
    }

    /*
     * WARNING - void declaration
     */
    public void smash(boolean pkt) {
        ItemStack toDestroy = this.slots.getStackInSlot(0);
        if (CyberwareAPI.canDeconstruct(toDestroy) && toDestroy.field_77994_a > 0) {
            ItemStack paperSlot = this.slots.getStackInSlot(1);
            boolean doBlueprint = paperSlot != null && paperSlot.field_77994_a > 0;
            ItemStack[] components = (ItemStack[])CyberwareAPI.getComponents(toDestroy).clone();
            ArrayList<ItemStack> random = new ArrayList<ItemStack>();
            for (ItemStack itemStack : components) {
                if (itemStack == null) continue;
                for (int i = 0; i < itemStack.field_77994_a; ++i) {
                    ItemStack copy = itemStack.func_77946_l();
                    copy.field_77994_a = 1;
                    random.add(copy);
                }
            }
            int numToRemove = 1;
            switch (this.field_145850_b.func_175659_aa()) {
                case EASY: {
                    numToRemove = 1;
                    break;
                }
                case HARD: {
                    numToRemove = 2;
                    break;
                }
                case NORMAL: {
                    numToRemove = 2;
                    break;
                }
                case PEACEFUL: {
                    numToRemove = 1;
                    break;
                }
            }
            if (this.slots.getStackInSlot(0).func_77984_f()) {
                float percent = (float)this.slots.getStackInSlot(0).func_77952_i() * 1.0f / (float)this.slots.getStackInSlot(0).func_77958_k();
                int addl = (int)((float)random.size() * percent);
                addl = Math.max(0, addl - 1);
                numToRemove += addl;
            }
            numToRemove = Math.min(numToRemove, random.size() - 1);
            for (int i = 0; i < numToRemove; ++i) {
                random.remove(this.field_145850_b.field_73012_v.nextInt(random.size()));
            }
            ItemStackHandler handler = new ItemStackHandler(6);
            for (int i = 0; i < 6; ++i) {
                handler.setStackInSlot(i, ItemStack.func_77944_b((ItemStack)this.slots.getStackInSlot(i + 2)));
            }
            boolean canInsert = true;
            for (ItemStack drop : components) {
                ItemStack left = drop.func_77946_l();
                boolean wasAble = false;
                for (int slot = 0; slot < 6; ++slot) {
                    if ((left = handler.insertItem(slot, left, false)) != null) continue;
                    wasAble = true;
                    break;
                }
                if (wasAble) continue;
                canInsert = false;
                break;
            }
            if (doBlueprint) {
                ItemStack itemStack = ItemBlueprint.getBlueprintForItem(toDestroy);
                boolean wasAble = false;
                for (int slot = 0; slot < 6; ++slot) {
                    void var10_16;
                    ItemStack itemStack2 = handler.insertItem(slot, (ItemStack)var10_16, false);
                    if (itemStack2 != null) continue;
                    wasAble = true;
                    break;
                }
                if (!wasAble) {
                    canInsert = false;
                }
            }
            if (canInsert) {
                if (pkt) {
                    CyberwarePacketHandler.INSTANCE.sendToAllAround((IMessage)new ScannerSmashPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 25.0));
                }
                if (!this.field_145850_b.field_72995_K) {
                    float f = CyberwareConfig.ENGINEERING_CHANCE;
                    if (toDestroy.func_77984_f()) {
                        f = Math.min(100.0f, CyberwareConfig.ENGINEERING_CHANCE * 5.0f * (1.0f - (float)this.slots.getStackInSlot(0).func_77952_i() * 1.0f / (float)this.slots.getStackInSlot(0).func_77958_k()));
                    }
                    if (doBlueprint && this.func_145831_w().field_73012_v.nextFloat() < CyberwareConfig.ENGINEERING_CHANCE / 100.0f) {
                        ItemStack blue = ItemBlueprint.getBlueprintForItem(toDestroy);
                        random.add(blue);
                        ItemStack current = this.slots.getStackInSlot(1);
                        --current.field_77994_a;
                        if (current.field_77994_a <= 0) {
                            current = null;
                        }
                        this.slots.setStackInSlot(1, current);
                    }
                    for (ItemStack drop : random) {
                        int slot;
                        ItemStack dropLeft = drop.func_77946_l();
                        for (slot = 2; slot < 8 && (this.slots.getStackInSlot(slot) == null || (dropLeft = this.slots.insertItem(slot, dropLeft, false)) != null); ++slot) {
                        }
                        for (slot = 2; slot < 8 && (dropLeft = this.slots.insertItem(slot, dropLeft, false)) != null; ++slot) {
                        }
                    }
                    ItemStack current = this.slots.getStackInSlot(0);
                    --current.field_77994_a;
                    if (current.field_77994_a <= 0 || current == null) {
                        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.func_174877_v()), this.field_145850_b.func_180495_p(this.func_174877_v()), 2);
                        current = null;
                    }
                    this.slots.setStackInSlot(0, current);
                    this.updateRecipe();
                } else {
                    this.smashSounds();
                }
            }
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_175640_z(this.func_174877_v()) || this.field_145850_b.func_175640_z(this.func_174877_v().func_177982_a(0, -1, 0))) {
            if (this.time == 0) {
                this.smash(false);
            }
            this.time = (this.time + 1) % 25;
        } else {
            this.time = 0;
        }
    }

    public void smashSounds() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        this.clickedTime = (float)Minecraft.func_71410_x().field_71439_g.field_70173_aa + Minecraft.func_71410_x().func_184121_ak();
        this.field_145850_b.func_184134_a((double)x, (double)y, (double)z, SoundEvents.field_187715_dR, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        this.field_145850_b.func_184134_a((double)x, (double)y, (double)z, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 1.0f, 0.5f, false);
        for (int i = 0; i < 10; ++i) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.ITEM_CRACK, (double)((float)x + 0.5f), (double)y, (double)((float)z + 0.5f), (double)(0.25f * (this.field_145850_b.field_73012_v.nextFloat() - 0.5f)), (double)0.1f, (double)(0.25f * (this.field_145850_b.field_73012_v.nextFloat() - 0.5f)), new int[]{Item.func_150891_b((Item)this.slots.getStackInSlot(0).func_77973_b())});
        }
    }

    public class GuiWrapper
    implements IItemHandlerModifiable {
        private ItemStackHandlerEngineering slots;

        public GuiWrapper(ItemStackHandlerEngineering slots) {
            this.slots = slots;
        }

        public int getSlots() {
            return this.slots.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            return this.slots.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            this.slots.overrideExtract = true;
            ItemStack res = this.slots.insertItem(slot, stack, simulate);
            this.slots.overrideExtract = false;
            return res;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            this.slots.overrideExtract = true;
            ItemStack ret = this.slots.extractItem(slot, amount, simulate);
            this.slots.overrideExtract = false;
            return ret;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            this.slots.overrideExtract = true;
            this.slots.setStackInSlot(slot, stack);
            this.slots.overrideExtract = false;
        }
    }

    public class ItemStackHandlerEngineering
    extends ItemStackHandler {
        public boolean overrideExtract;
        private TileEntityEngineeringTable table;

        public ItemStackHandlerEngineering(TileEntityEngineeringTable table, int i) {
            super(i);
            this.overrideExtract = false;
            this.table = table;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            boolean check = false;
            if (slot == 0 && this.getStackInSlot(0) == null && !((TileEntityEngineeringTable)TileEntityEngineeringTable.this).field_145850_b.field_72995_K) {
                check = true;
            }
            super.setStackInSlot(slot, stack);
            if (check) {
                this.table.field_145850_b.func_180501_a(TileEntityEngineeringTable.this.func_174877_v(), this.table.field_145850_b.func_180495_p(TileEntityEngineeringTable.this.func_174877_v()), 2);
                this.table.field_145850_b.func_184138_a(TileEntityEngineeringTable.this.field_174879_c, this.table.field_145850_b.func_180495_p(TileEntityEngineeringTable.this.func_174877_v()), this.table.field_145850_b.func_180495_p(TileEntityEngineeringTable.this.func_174877_v()), 2);
            }
            if (slot >= 2 && slot <= 8) {
                this.table.updateRecipe();
            }
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!this.isItemValidForSlot(slot, stack)) {
                return stack;
            }
            boolean check = false;
            if (slot == 0 && this.getStackInSlot(0) == null && !simulate && !((TileEntityEngineeringTable)TileEntityEngineeringTable.this).field_145850_b.field_72995_K) {
                check = true;
            }
            ItemStack result = super.insertItem(slot, stack, simulate);
            if (check) {
                this.table.field_145850_b.func_180501_a(TileEntityEngineeringTable.this.func_174877_v(), this.table.field_145850_b.func_180495_p(TileEntityEngineeringTable.this.func_174877_v()), 2);
                this.table.field_145850_b.func_184138_a(TileEntityEngineeringTable.this.field_174879_c, this.table.field_145850_b.func_180495_p(TileEntityEngineeringTable.this.func_174877_v()), this.table.field_145850_b.func_180495_p(TileEntityEngineeringTable.this.func_174877_v()), 2);
            }
            if (slot >= 2 && slot <= 8 && !simulate) {
                this.table.updateRecipe();
            }
            return result;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!this.canRemoveItem(slot)) {
                return null;
            }
            ItemStack result = super.extractItem(slot, amount, simulate);
            if (slot == 9 && result != null && !simulate) {
                this.table.subtractResources();
            }
            if (slot >= 2 && slot <= 7 && !simulate) {
                this.table.updateRecipe();
            }
            return result;
        }

        public boolean canRemoveItem(int slot) {
            if (this.overrideExtract) {
                return true;
            }
            if (this.getStackInSlot(8) != null && slot >= 2 && slot <= 7) {
                return false;
            }
            return slot != 1 && slot != 8;
        }

        public boolean isItemValidForSlot(int slot, ItemStack stack) {
            switch (slot) {
                case 0: {
                    return CyberwareAPI.canDeconstruct(stack);
                }
                case 1: {
                    int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
                    int paperId = OreDictionary.getOreID((String)"paper");
                    for (int id : ids) {
                        if (id != paperId) continue;
                        return true;
                    }
                    return false;
                }
                case 8: {
                    return stack != null && stack.func_77973_b() instanceof IBlueprint;
                }
                case 9: {
                    return false;
                }
            }
            return this.overrideExtract || !CyberwareAPI.canDeconstruct(stack);
        }
    }

    public static class TileEntityEngineeringDummy
    extends TileEntity {
        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            TileEntity above = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 1, 0));
            if (above != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return above.hasCapability(capability, facing);
            }
            return super.hasCapability(capability, facing);
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            TileEntity above = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, 1, 0));
            if (above != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)above.getCapability(capability, facing);
            }
            return (T)super.getCapability(capability, facing);
        }
    }
}

