/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.item.ItemCyberware;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ItemBoneUpgrade
extends ItemCyberware {
    private static final UUID healthId = UUID.fromString("8bce997a-4c3a-11e6-beb8-9e71128cae77");

    public ItemBoneUpgrade(String name, ICyberware.EnumSlot slot, String[] subnames) {
        super(name, slot, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onAdded(EntityLivingBase entity, ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(healthId, "Bone hp upgrade", (double)(4.0f * (float)stack.field_77994_a), 0));
            entity.func_110140_aT().func_111147_b((Multimap)multimap);
        }
    }

    @Override
    public void onRemoved(EntityLivingBase entity, ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(healthId, "Bone hp upgrade", (double)(4.0f * (float)stack.field_77994_a), 0));
            entity.func_110140_aT().func_111148_a((Multimap)multimap);
        }
    }

    @SubscribeEvent
    public void handleJoinWorld(EntityJoinWorldEvent event) {
        Entity e = event.getEntity();
        ItemStack test = new ItemStack((Item)this, 1, 0);
        if (e instanceof EntityLivingBase && CyberwareAPI.isCyberwareInstalled(e, test)) {
            this.onAdded((EntityLivingBase)e, CyberwareAPI.getCyberware(e, test));
        } else if (CyberwareAPI.hasCapability(e) && e instanceof EntityLivingBase) {
            this.onRemoved((EntityLivingBase)e, test);
        }
    }

    @SubscribeEvent
    public void handleFallDamage(LivingHurtEvent event) {
        EntityLivingBase e = event.getEntityLiving();
        if (CyberwareAPI.isCyberwareInstalled((Entity)e, new ItemStack((Item)this, 1, 1)) && event.getSource() == DamageSource.field_76379_h) {
            event.setAmount(event.getAmount() * 0.3333f);
        }
    }

    @Override
    public boolean isIncompatible(ItemStack stack, ItemStack other) {
        return other.func_77973_b() == this;
    }

    @Override
    public int getCapacity(ItemStack wareStack) {
        return wareStack.func_77952_i() == 2 ? 900 * wareStack.field_77994_a : 0;
    }

    @Override
    public int installedStackSize(ItemStack stack) {
        return stack.func_77952_i() == 0 ? 5 : (stack.func_77952_i() == 2 ? 4 : 1);
    }

    @Override
    protected int getUnmodifiedEssenceCost(ItemStack stack) {
        if (stack.func_77952_i() == 0) {
            switch (stack.field_77994_a) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 6;
                }
                case 3: {
                    return 9;
                }
                case 4: {
                    return 12;
                }
                case 5: {
                    return 15;
                }
            }
        }
        if (stack.func_77952_i() == 2) {
            switch (stack.field_77994_a) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 3;
                }
                case 3: {
                    return 4;
                }
                case 4: {
                    return 5;
                }
            }
        }
        return super.getUnmodifiedEssenceCost(stack);
    }
}

