/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.cyberware.common.misc;

import flaxbeard.cyberware.api.item.IDeconstructable;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemBlueprint;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.RecipeSorter;

public class BlueprintCraftingHandler
implements IRecipe {
    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return new BlueprintResult(inv).canCraft;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return new BlueprintResult(inv).output;
    }

    public int func_77570_a() {
        return 0;
    }

    public ItemStack func_77571_b() {
        return null;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return new BlueprintResult(inv).remaining;
    }

    static {
        RecipeSorter.register((String)"cyberware:blueprintCrafting", BlueprintCraftingHandler.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
    }

    private class BlueprintResult {
        private final boolean canCraft;
        private final ItemStack[] remaining;
        private final ItemStack output;
        private ItemStack ware = null;
        int wareStack = 0;

        public BlueprintResult(InventoryCrafting inv) {
            this.canCraft = this.process(inv);
            if (this.canCraft) {
                this.remaining = new ItemStack[9];
                this.remaining[this.wareStack] = ItemStack.func_77944_b((ItemStack)this.ware);
                this.output = ItemBlueprint.getBlueprintForItem(this.ware);
            } else {
                this.remaining = new ItemStack[9];
                this.output = null;
            }
        }

        private boolean process(InventoryCrafting inv) {
            boolean hasBlankBlueprint = false;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null) continue;
                if (stack.func_77973_b() instanceof IDeconstructable) {
                    if (this.ware == null) {
                        this.ware = stack;
                        this.wareStack = i;
                        continue;
                    }
                    return false;
                }
                if (!(stack.func_77973_b() != CyberwareContent.blueprint || stack.func_77942_o() && stack.func_77978_p().func_74764_b("blueprintItem"))) {
                    if (!hasBlankBlueprint) {
                        hasBlankBlueprint = true;
                        continue;
                    }
                    return false;
                }
                return false;
            }
            return this.ware != null && hasBlankBlueprint;
        }
    }
}

