/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils;

import net.darkhax.bookshelf.client.model.FullbrightBakedModel;
import net.darkhax.bookshelf.registry.RegistryHelper;
import net.darkhax.bookshelf.registry.RegistryHelperClient;
import net.darkhax.darkutils.Content;
import net.darkhax.darkutils.features.enderhopper.RenderEnderHopper;
import net.darkhax.darkutils.features.enderhopper.TileEntityEnderHopper;
import net.darkhax.darkutils.features.slimecrucible.RenderSlimeCrucible;
import net.darkhax.darkutils.features.slimecrucible.ScreenSlimeCrucible;
import net.darkhax.darkutils.features.slimecrucible.TileEntitySlimeCrucible;
import net.darkhax.darkutils.features.witherslime.EntitySlimeWither;
import net.darkhax.darkutils.features.witherslime.RenderSlimeWither;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;

public class ContentClient
extends Content {
    public ContentClient(RegistryHelper registry) {
        super(registry);
        if (registry instanceof RegistryHelperClient) {
            RegistryHelperClient clientRegistry = (RegistryHelperClient)registry;
            clientRegistry.setSpecialRenderer(TileEntitySlimeCrucible.class, (TileEntityRenderer)new RenderSlimeCrucible());
            clientRegistry.setSpecialRenderer(TileEntityEnderHopper.class, (TileEntityRenderer)new RenderEnderHopper());
            clientRegistry.registerGuiScreen(this.containerSlimeCrucible, ScreenSlimeCrucible::new);
            clientRegistry.registerEntityRenderer(EntitySlimeWither.class, RenderSlimeWither::new);
            this.makeFullBrightFlatTile(clientRegistry, this.vectorPlate);
            this.makeFullBrightFlatTile(clientRegistry, this.vectorPlateFast);
            this.makeFullBrightFlatTile(clientRegistry, this.vectorPlateHyper);
            this.makeFullBrightFlatTile(clientRegistry, this.importPlate);
            this.makeFullBrightFlatTile(clientRegistry, this.importPlateFast);
            this.makeFullBrightFlatTile(clientRegistry, this.importPlateHyper);
            this.makeFullBrightFlatTile(clientRegistry, this.exportPlate);
            this.makeFullBrightFlatTile(clientRegistry, this.exportPlateFast);
            this.makeFullBrightFlatTile(clientRegistry, this.exportPlateHyper);
            this.makeFullBrightFlatTile(clientRegistry, this.runeDamage);
            this.makeFullBrightFlatTile(clientRegistry, this.runeDamagePlayer);
            this.makeFullBrightFlatTile(clientRegistry, this.runePoison);
            this.makeFullBrightFlatTile(clientRegistry, this.runeWeakness);
            this.makeFullBrightFlatTile(clientRegistry, this.runeSlowness);
            this.makeFullBrightFlatTile(clientRegistry, this.runeWither);
            this.makeFullBrightFlatTile(clientRegistry, this.runeFire);
            this.makeFullBrightFlatTile(clientRegistry, this.runeFatigue);
            this.makeFullBrightFlatTile(clientRegistry, this.runeGlowing);
            this.makeFullBrightFlatTile(clientRegistry, this.runeHunger);
            this.makeFullBrightFlatTile(clientRegistry, this.runeBlindness);
            this.makeFullBrightFlatTile(clientRegistry, this.runeNausea);
            this.makeFullBrightFlatTile(clientRegistry, this.anchorPlate);
        }
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::addTooltips);
    }

    private void addTooltips(ItemTooltipEvent event) {
        ResourceLocation id;
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b() && stack.func_77973_b() != null && (id = stack.func_77973_b().getRegistryName()) != null && "darkutils".equals(id.func_110624_b())) {
            event.getToolTip().add(new TranslationTextComponent("tooltip.darkutils." + id.func_110623_a() + ".short", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    private void makeFullBrightFlatTile(RegistryHelperClient registry, Block tile) {
        ResourceLocation blockId = tile.getRegistryName();
        registry.registerModelFactory(blockId, (original, ctx) -> new FullbrightBakedModel(original, Float.valueOf(0.007f), new ResourceLocation[]{new ResourceLocation(blockId.func_110624_b(), "block/" + blockId.func_110623_a())}));
    }
}

