/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.enderhopper;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.darkutils.features.enderhopper.BlockEnderHopper;
import net.darkhax.darkutils.features.enderhopper.TileEntityEnderHopper;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.animation.TileEntityRendererFast;

@OnlyIn(value=Dist.CLIENT)
public class RenderEnderHopper
extends TileEntityRendererFast<TileEntityEnderHopper> {
    private static TextureAtlasSprite icon;
    private static Map<Direction, Renderable> directionMap;

    public void renderTileEntityFast(TileEntityEnderHopper tile, double x, double y, double z, float partialTicks, int destroyStage, BufferBuilder buffer) {
        BlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        if (state.func_177230_c() instanceof BlockEnderHopper && ((Boolean)state.func_177229_b((IProperty)BlockEnderHopper.SHOW_BORDER)).booleanValue()) {
            GlStateManager.pushMatrix();
            RenderEnderHopper.renderCubeOverlay(9.001f, x, y, z, 0xFFFFFF, buffer);
            GlStateManager.popMatrix();
        }
    }

    private static void renderCubeOverlay(float box, double x, double y, double z, int color, BufferBuilder buffer) {
        if (icon == null) {
            icon = Minecraft.func_71410_x().func_147117_R().func_195424_a(new ResourceLocation("minecraft", "block/nether_portal"));
        }
        buffer.func_178969_c(x + 0.5, y + 0.5, z + 0.5);
        RenderEnderHopper.drawOverlay(box, box, box, icon, color, 255, buffer);
    }

    public static void drawOverlay(float width, float height, float length, TextureAtlasSprite icon, int color, int alpha, BufferBuilder buffer) {
        Direction[] directions;
        for (Direction direction : directions = Direction.func_196054_a((Entity)Minecraft.func_71410_x().field_175622_Z)) {
            Renderable renderable = directionMap.get(direction.func_176740_k().func_176722_c() ? direction : direction.func_176734_d());
            renderable.render(buffer, width, height, length, icon, color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, alpha, 200, 200);
        }
    }

    static {
        directionMap = (Map)Util.func_200696_a(new HashMap(), map -> {
            map.put(Direction.UP, (buffer, width, height, length, icon, red, green, blue, alpha, light1, light2) -> {
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(height / 2.0f), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(width / 2.0f), (double)(height / 2.0f), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(width / 2.0f), (double)(height / 2.0f), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(height / 2.0f), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
            });
            map.put(Direction.DOWN, (buffer, width, height, length, icon, red, green, blue, alpha, light1, light2) -> {
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(-(height / 2.0f)), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(width / 2.0f), (double)(-(height / 2.0f)), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(width / 2.0f), (double)(-(height / 2.0f)), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(-(height / 2.0f)), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
            });
            map.put(Direction.NORTH, (buffer, width, height, length, icon, red, green, blue, alpha, light1, light2) -> {
                buffer.func_181662_b((double)(width / 2.0f), (double)(-(height / 2.0f)), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(-(height / 2.0f)), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(height / 2.0f), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(width / 2.0f), (double)(height / 2.0f), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
            });
            map.put(Direction.SOUTH, (buffer, width, height, length, icon, red, green, blue, alpha, light1, light2) -> {
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(-(height / 2.0f)), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(width / 2.0f), (double)(-(height / 2.0f)), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(width / 2.0f), (double)(height / 2.0f), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(height / 2.0f), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
            });
            map.put(Direction.EAST, (buffer, width, height, length, icon, red, green, blue, alpha, light1, light2) -> {
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(height / 2.0f), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(height / 2.0f), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(-(height / 2.0f)), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(-(width / 2.0f)), (double)(-(height / 2.0f)), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
            });
            map.put(Direction.WEST, (buffer, width, height, length, icon, red, green, blue, alpha, light1, light2) -> {
                buffer.func_181662_b((double)(width / 2.0f), (double)(-(height / 2.0f)), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(width / 2.0f), (double)(-(height / 2.0f)), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94206_g()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(width / 2.0f), (double)(height / 2.0f), (double)(length / 2.0f)).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94212_f(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
                buffer.func_181662_b((double)(width / 2.0f), (double)(height / 2.0f), (double)(-(length / 2.0f))).func_181669_b(red, green, blue, alpha).func_187315_a((double)icon.func_94209_e(), (double)icon.func_94210_h()).func_187314_a(light1, light2).func_181675_d();
            });
        });
    }

    private static interface Renderable {
        public void render(BufferBuilder var1, float var2, float var3, float var4, TextureAtlasSprite var5, int var6, int var7, int var8, int var9, int var10, int var11);
    }
}

