/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.flatblocks;

import net.darkhax.darkutils.features.flatblocks.collision.CollisionEffect;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class BlockFlatTile
extends Block
implements IBucketPickupHandler,
ILiquidContainer {
    public static final Block.Properties BLOCK_PROPERTIES = Block.Properties.func_200949_a((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).func_200948_a(3.0f, 10.0f);
    public static final VoxelShape BOUNDS = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    public static final VoxelShape EFFECT_BOUNDS = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private final CollisionEffect collisionEffect;

    public BlockFlatTile() {
        this(null);
    }

    public BlockFlatTile(CollisionEffect collisionEffect) {
        this(BLOCK_PROPERTIES, collisionEffect);
    }

    public BlockFlatTile(Block.Properties properties, CollisionEffect collisionEffect) {
        super(properties.func_200942_a());
        this.collisionEffect = collisionEffect;
        BlockState defaultState = (BlockState)this.field_176227_L.func_177621_b();
        defaultState = (BlockState)defaultState.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false));
        defaultState = (BlockState)defaultState.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
        this.func_180632_j(defaultState);
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (this.collisionEffect != null && !((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208194_u)).booleanValue() && EFFECT_BOUNDS.func_197752_a().func_186670_a(pos).func_72326_a(entity.func_174813_aQ())) {
            this.collisionEffect.apply(state, world, pos, entity);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{BlockStateProperties.field_208194_u, BlockStateProperties.field_208198_y});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return BOUNDS;
    }

    public boolean func_181623_g() {
        return true;
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return true;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, IFluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a && !worldIn.func_201670_d()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(true)), 3);
            worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReader)worldIn));
        }
        return false;
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, BlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BlockStateProperties.field_208198_y) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)BlockStateProperties.field_208198_y)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState preExistingFluidState = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockState placedState = super.func_196258_a(context);
        placedState = (BlockState)placedState.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(preExistingFluidState.func_206886_c() == Fluids.field_204546_a));
        placedState = (BlockState)placedState.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
        return placedState;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(worldIn.func_175640_z(pos))));
        }
        super.func_220069_a(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

