/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.slimecrucible;

import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.slimecrucible.ISlimeCrucibleBlock;
import net.darkhax.darkutils.features.slimecrucible.SlimeCrucibleType;
import net.darkhax.darkutils.features.slimecrucible.TileEntitySlimeCrucible;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockSlimeCrucible
extends ContainerBlock
implements ISlimeCrucibleBlock {
    private static final VoxelShape boundsFullCube = VoxelShapes.func_197868_b();
    private static final VoxelShape boundsCollision = VoxelShapes.func_197878_a((VoxelShape)boundsFullCube, (VoxelShape)Block.func_208617_a((double)2.0, (double)Math.max(2, 1), (double)2.0, (double)14.0, (double)16.0, (double)14.0), (IBooleanFunction)IBooleanFunction.field_223234_e_);
    private final SlimeCrucibleType type;

    public BlockSlimeCrucible(Block.Properties properties, SlimeCrucibleType type) {
        super(properties);
        this.type = type;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return boundsCollision;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return boundsFullCube;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return boundsCollision;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntitySlimeCrucible();
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntitySlimeCrucible) {
            TileEntitySlimeCrucible crucible = (TileEntitySlimeCrucible)tile;
            ItemStack heldItem = player.func_184586_b(handIn);
            int points = TileEntitySlimeCrucible.getSlimePointsForItem(world, heldItem, this.type);
            if (points > 0 && crucible.getContainedSlimePoints() <= this.getCrucibleType().getMaxSlimePoints()) {
                crucible.addSlimePoints(points);
                if (world instanceof ServerWorld) {
                    ServerWorld serverWorld = (ServerWorld)world;
                    for (int i = 0; i < 16; ++i) {
                        serverWorld.func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, heldItem), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.25, (double)pos.func_177952_p() + 0.5, 1, world.field_73012_v.nextDouble() * 0.45 - 0.45, 0.0, world.field_73012_v.nextDouble() * 0.45 - 0.45, 0.0);
                    }
                    player.func_195066_a(DarkUtils.content.statSlimeCrucibleFeed);
                }
                crucible.setSquishAmount(1.0f);
                world.func_184148_a(null, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.25f), (double)((float)pos.func_177952_p() + 0.5f), crucible.getContainedSlime(world).func_213353_d(heldItem), SoundCategory.BLOCKS, 0.5f + 0.5f * (float)world.field_73012_v.nextInt(2), (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                heldItem.func_190918_g(1);
                return true;
            }
            player.func_213829_a(state.func_215699_b(world, pos));
            if (!world.field_72995_K) {
                player.func_195066_a(DarkUtils.content.statSlimeCrucibleInteract);
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntity tileentity;
        if (stack.func_82837_s() && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntitySlimeCrucible) {
            ((TileEntitySlimeCrucible)tileentity).setCustomName(stack.func_200301_q());
        }
    }

    @Override
    public SlimeCrucibleType getCrucibleType() {
        return this.type;
    }
}

