/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.slimecrucible;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.inventory.InventoryListenable;
import net.darkhax.bookshelf.inventory.SlotOutput;
import net.darkhax.bookshelf.util.WorldUtils;
import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.slimecrucible.ISlimeCrucibleBlock;
import net.darkhax.darkutils.features.slimecrucible.MessageSyncCrucibleType;
import net.darkhax.darkutils.features.slimecrucible.RecipeSlimeCrafting;
import net.darkhax.darkutils.features.slimecrucible.SlimeCrucibleEvents;
import net.darkhax.darkutils.features.slimecrucible.SlimeCrucibleType;
import net.darkhax.darkutils.features.slimecrucible.TileEntitySlimeCrucible;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ContainerSlimeCrucible
extends Container {
    @Nullable
    private final ServerPlayerEntity playerEntity;
    private final IWorldPosCallable worldPosition;
    private final World playerWorld;
    private final IntReferenceHolder selectedRecipe = IntReferenceHolder.func_221492_a();
    private final IntReferenceHolder slimePoints = IntReferenceHolder.func_221492_a();
    private boolean hasSyncedType = false;
    private SlimeCrucibleType crucibleType;
    private final List<RecipeSlimeCrafting> availableRecipes = Lists.newArrayList();
    private ItemStack currentInput = ItemStack.field_190927_a;
    private long lastSoundPlayingTick;
    final Slot slotInput;
    final Slot slotOutput;
    private final InventoryListenable inventory = new InventoryListenable(1, this::func_75130_a);
    private final CraftResultInventory reultInventory = new CraftResultInventory();
    private ItemStack tempCraftingStack = ItemStack.field_190927_a;

    public ContainerSlimeCrucible(int id, PlayerInventory playerInv) {
        this(id, playerInv, IWorldPosCallable.field_221489_a);
    }

    public ContainerSlimeCrucible(int id, PlayerInventory playerInventory, IWorldPosCallable worldPosition) {
        super(DarkUtils.content.containerSlimeCrucible, id);
        this.playerEntity = playerInventory.field_70458_d instanceof ServerPlayerEntity ? (ServerPlayerEntity)playerInventory.field_70458_d : null;
        this.playerWorld = playerInventory.field_70458_d.field_70170_p;
        this.worldPosition = worldPosition;
        this.slotInput = this.func_75146_a(new Slot((IInventory)this.inventory, 0, 20, 49));
        this.slotOutput = this.func_75146_a((Slot)new SlotOutput((IInventory)this.reultInventory, 1, 143, 33, this::onOutputSlotChanged));
        this.selectedRecipe.func_221494_a(-1);
        this.worldPosition.func_221486_a((world, pos) -> {
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntitySlimeCrucible) {
                this.setCrucibleType(((TileEntitySlimeCrucible)tileEntity).getCrucibleType());
                this.slimePoints.func_221494_a(((TileEntitySlimeCrucible)tileEntity).getContainedSlimePoints());
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.func_75146_a(new Slot((IInventory)playerInventory, column + row * 9 + 9, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            this.func_75146_a(new Slot((IInventory)playerInventory, slotIndex, 8 + slotIndex * 18, 142));
        }
        this.func_216958_a(this.selectedRecipe);
        this.func_216958_a(this.slimePoints);
    }

    public boolean canCraft(int recipeIndex) {
        return this.canCraft(this.getAvailableRecipes().get(recipeIndex));
    }

    public boolean canCraft(RecipeSlimeCrafting recipe) {
        return recipe.isValid(this.getCurrentInput(), this.getCrucibleType(), this.getSlimePoints());
    }

    public void setCrucibleType(SlimeCrucibleType type) {
        this.crucibleType = type;
        this.updateAvailableRecipes();
    }

    public SlimeCrucibleType getCrucibleType() {
        return this.crucibleType;
    }

    public int getSelectedRecipeId() {
        return this.selectedRecipe.func_221495_b();
    }

    public int getSlimePoints() {
        return this.slimePoints.func_221495_b();
    }

    public List<RecipeSlimeCrafting> getAvailableRecipes() {
        return this.availableRecipes;
    }

    public int getAvailableRecipesSize() {
        return this.availableRecipes.size();
    }

    public boolean canDisplayRecipes() {
        return !this.availableRecipes.isEmpty();
    }

    public ItemStack getCurrentInput() {
        return this.currentInput;
    }

    private void updateAvailableRecipes() {
        this.availableRecipes.clear();
        if (this.getCrucibleType() != null) {
            Collection recipes = WorldUtils.getRecipeList(DarkUtils.content.recipeTypeSlimeCrafting, (RecipeManager)this.playerWorld.func_199532_z());
            recipes = recipes.stream().sorted(Comparator.comparingInt(recipe -> this.canCraft((RecipeSlimeCrafting)recipe) ? -1 : (recipe.isHidden() ? 1 : 0))).collect(Collectors.toList());
            for (RecipeSlimeCrafting recipe2 : recipes) {
                if (!recipe2.isValid(this.getCrucibleType())) continue;
                this.availableRecipes.add(recipe2);
            }
        }
    }

    private void updateOutputs() {
        if (!this.availableRecipes.isEmpty() && this.selectedRecipe.func_221495_b() >= 0 && this.selectedRecipe.func_221495_b() < this.availableRecipes.size() && this.canCraft(this.selectedRecipe.func_221495_b())) {
            this.slotOutput.func_75215_d(this.getSelectedRecipe().func_77572_b((IInventory)this.inventory));
        } else {
            this.slotOutput.func_75215_d(ItemStack.field_190927_a);
            this.selectedRecipe.func_221494_a(-1);
            this.updateAvailableRecipes();
        }
        this.func_75142_b();
    }

    public RecipeSlimeCrafting getSelectedRecipe() {
        return this.availableRecipes.get(this.getSelectedRecipeId());
    }

    private ItemStack onOutputSlotChanged(PlayerEntity player, ItemStack stack) {
        RecipeSlimeCrafting recipe = this.getSelectedRecipe();
        ItemStack inputStack = this.slotInput.func_75209_a(recipe.getInputCount());
        ItemStack outputCopy = stack;
        this.worldPosition.func_221486_a((world, pos) -> {
            SlimeCrucibleEvents.RecipeCraftedEvent event = new SlimeCrucibleEvents.RecipeCraftedEvent(recipe, player, (World)world, (BlockPos)pos, outputCopy);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.tempCraftingStack = event.getOutput();
            this.playerEntity.func_195066_a(DarkUtils.content.statSlimeCrucibleItemsCrafted);
            int consumedPoints = recipe.getSlimePoints();
            this.slimePoints.func_221494_a(this.getSlimePoints() - consumedPoints);
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileEntitySlimeCrucible) {
                TileEntitySlimeCrucible crucible = (TileEntitySlimeCrucible)tileEntity;
                crucible.removeSlimePoints(consumedPoints);
            }
        });
        if (!inputStack.func_190926_b()) {
            this.updateOutputs();
        }
        stack = this.tempCraftingStack;
        this.tempCraftingStack = ItemStack.field_190927_a;
        stack.func_77973_b().func_77622_d(stack, player.field_70170_p, player);
        this.worldPosition.func_221486_a(this::playCraftingSound);
        return stack;
    }

    private void playCraftingSound(World world, BlockPos pos) {
        long worldTime;
        if (this.getCrucibleType() != null && this.lastSoundPlayingTick != (worldTime = world.func_82737_E())) {
            world.func_184133_a((PlayerEntity)null, pos, this.getCrucibleType().getCraftingSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.lastSoundPlayingTick = worldTime;
        }
    }

    public void setUpdateListener(Consumer<IInventory> listener) {
        this.inventory.setInventoryListener(listener);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return WorldUtils.isWithinDistanceAndUsable((IWorldPosCallable)this.worldPosition, (PlayerEntity)playerIn, state -> state.func_177230_c() instanceof ISlimeCrucibleBlock, (double)64.0);
    }

    public boolean func_75140_a(PlayerEntity playerIn, int id) {
        ItemStack mouseStack;
        int itemPoints;
        if (id >= 0 && id < this.availableRecipes.size() && this.canCraft(id)) {
            this.selectedRecipe.func_221494_a(id);
            this.updateOutputs();
            return true;
        }
        if (id == -42 && (itemPoints = TileEntitySlimeCrucible.getSlimePointsForItem(this.playerWorld, mouseStack = playerIn.field_71071_by.func_70445_o(), this.getCrucibleType())) > 0 && this.getSlimePoints() < this.getCrucibleType().getMaxSlimePoints()) {
            this.worldPosition.func_221486_a((world, pos) -> {
                TileEntity tile = world.func_175625_s(pos);
                if (tile instanceof TileEntitySlimeCrucible) {
                    ((TileEntitySlimeCrucible)tile).addSlimePoints(itemPoints);
                    if (this.playerEntity != null) {
                        this.playerEntity.func_195066_a(DarkUtils.content.statSlimeCrucibleFeed);
                    }
                }
            });
            mouseStack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public void func_75142_b() {
        this.worldPosition.func_221486_a((worldIn, pos) -> {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (tileEntity instanceof TileEntitySlimeCrucible) {
                int currentSlimePoints = ((TileEntitySlimeCrucible)tileEntity).getContainedSlimePoints();
                if (this.getSlimePoints() != currentSlimePoints) {
                    this.slimePoints.func_221494_a(currentSlimePoints);
                }
            }
        });
        super.func_75142_b();
        if (!this.hasSyncedType && this.playerEntity != null && this.func_216957_a() != null) {
            DarkUtils.NETWORK.sendToPlayer(this.playerEntity, (Object)new MessageSyncCrucibleType(this.getCrucibleType().getRegistryName()));
            this.hasSyncedType = true;
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        ItemStack inputStack = this.slotInput.func_75211_c();
        if (!ItemStack.func_77989_b((ItemStack)inputStack, (ItemStack)this.currentInput)) {
            this.currentInput = inputStack.func_77946_l();
        }
        if (this.getSelectedRecipeId() == -1 || !this.getAvailableRecipes().get(this.getSelectedRecipeId()).isValid(inputStack, this.getCrucibleType(), this.getSlimePoints())) {
            this.selectedRecipe.func_221494_a(-1);
            this.slotOutput.func_75215_d(ItemStack.field_190927_a);
        }
        this.updateAvailableRecipes();
    }

    public ContainerType<?> func_216957_a() {
        return DarkUtils.content.containerSlimeCrucible;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return false;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.reultInventory.func_70304_b(1);
        this.worldPosition.func_221486_a((world, posIn) -> this.func_193327_a(playerIn, playerIn.field_70170_p, (IInventory)this.inventory));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        if (playerIn.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack inputStack = slot.func_75211_c();
            Item inputItem = inputStack.func_77973_b();
            itemstack = inputStack.func_77946_l();
            if (index == 1) {
                inputItem.func_77622_d(inputStack, playerIn.field_70170_p, playerIn);
                if (!this.func_75135_a(inputStack, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(inputStack, itemstack);
            } else if (index == 0 ? !this.func_75135_a(inputStack, 2, 38, false) : (index >= 2 && index < 29 ? !this.func_75135_a(inputStack, 29, 38, false) : index >= 29 && index < 38 && !this.func_75135_a(inputStack, 2, 29, false))) {
                return ItemStack.field_190927_a;
            }
            if (inputStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (inputStack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, inputStack);
            this.func_75142_b();
        }
        return itemstack;
    }
}

