/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.slimecrucible;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.slimecrucible.SlimeCrucibleType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeSlimeCrafting
implements IRecipe<IInventory> {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient input;
    private final int inputCount;
    private final ItemStack output;
    private final int points;
    private final ResourceLocation id;
    private final SlimeCrucibleType[] validTypes;
    private final boolean isHidden;

    public RecipeSlimeCrafting(ResourceLocation id, Ingredient input, int inputCount, ItemStack output, int points, Boolean isHidden, SlimeCrucibleType ... types) {
        this.id = id;
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.points = points;
        this.validTypes = types;
        this.isHidden = isHidden;
    }

    @Deprecated
    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.input.test(inv.func_70301_a(0));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.output.func_77946_l();
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return DarkUtils.content.recipeSerializerSlimeCrafting;
    }

    public IRecipeType<?> func_222127_g() {
        return DarkUtils.content.recipeTypeSlimeCrafting;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)Items.field_151123_aH);
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)this.input);
        return ingredients;
    }

    public int getSlimePoints() {
        return this.points;
    }

    public ItemStack[] getValidItemStacks() {
        return this.input.func_193365_a();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public int getInputCount() {
        return this.inputCount;
    }

    public boolean isValid(ItemStack input) {
        return input.func_190916_E() >= this.getInputCount() && this.input.test(input);
    }

    public boolean isValid(SlimeCrucibleType slimeCrucibleType) {
        return slimeCrucibleType.matchesAny(this.validTypes);
    }

    public boolean isValid(ItemStack input, SlimeCrucibleType slimeCrucibleType, int containedPoints) {
        return this.isValid(input) && this.isValid(slimeCrucibleType) && this.points <= containedPoints;
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeSlimeCrafting> {
        private Serializer() {
        }

        public RecipeSlimeCrafting read(ResourceLocation recipeId, JsonObject json) {
            JsonArray inputElement = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? JSONUtils.func_151214_t((JsonObject)json, (String)"input") : JSONUtils.func_152754_s((JsonObject)json, (String)"input");
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"output"));
            Ingredient input = Ingredient.func_199802_a((JsonElement)inputElement);
            int inputCount = JSONUtils.func_151208_a((JsonObject)json, (String)"inputCount", (int)1);
            int points = JSONUtils.func_151203_m((JsonObject)json, (String)"points");
            boolean isHidden = JSONUtils.func_151209_a((JsonObject)json, (String)"isHidden", (boolean)false);
            JsonArray typesArray = JSONUtils.func_151214_t((JsonObject)json, (String)"validTypes");
            HashSet<SlimeCrucibleType> types = new HashSet<SlimeCrucibleType>();
            for (int i = 0; i < typesArray.size(); ++i) {
                ResourceLocation id = new ResourceLocation(typesArray.get(i).getAsString());
                SlimeCrucibleType type = SlimeCrucibleType.getType(id);
                if (type == null) continue;
                types.add(type);
            }
            if (types.isEmpty()) {
                DarkUtils.LOG.warn("The slime food recipe {} has no valid types. It will not be obtainable. Some valid vanilla types are {}.", (Object)recipeId, (Object)Arrays.toString(SlimeCrucibleType.getTypeKeys().toArray()));
            }
            return new RecipeSlimeCrafting(recipeId, input, inputCount, output, points, isHidden, types.toArray(new SlimeCrucibleType[types.size()]));
        }

        public RecipeSlimeCrafting read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            int inputCount = buffer.readInt();
            ItemStack output = buffer.func_150791_c();
            int points = buffer.readInt();
            boolean isHidden = buffer.readBoolean();
            SlimeCrucibleType[] types = new SlimeCrucibleType[buffer.readInt()];
            for (int i = 0; i < types.length; ++i) {
                types[i] = SlimeCrucibleType.getType(buffer.func_192575_l());
            }
            return new RecipeSlimeCrafting(recipeId, input, inputCount, output, points, isHidden, types);
        }

        public void write(PacketBuffer buffer, RecipeSlimeCrafting recipe) {
            recipe.input.func_199564_a(buffer);
            buffer.writeInt(recipe.inputCount);
            buffer.func_150788_a(recipe.output);
            buffer.writeInt(recipe.points);
            buffer.writeBoolean(recipe.isHidden);
            buffer.writeInt(recipe.validTypes.length);
            for (SlimeCrucibleType type : recipe.validTypes) {
                buffer.func_192572_a(type.getRegistryName());
            }
        }
    }
}

