/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.slimecrucible;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.slimecrucible.SlimeCrucibleType;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeSlimeFood
implements IRecipe<IInventory> {
    public static final Serializer SERIALIZER = new Serializer();
    private final Ingredient input;
    private final int points;
    private final ResourceLocation id;
    private final SlimeCrucibleType[] validTypes;

    public RecipeSlimeFood(ResourceLocation id, Ingredient input, int points, SlimeCrucibleType ... types) {
        this.id = id;
        this.input = input;
        this.points = points;
        this.validTypes = types;
    }

    @Deprecated
    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.input.test(inv.func_70301_a(0));
    }

    @Deprecated
    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    @Deprecated
    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return DarkUtils.content.recipeSerializerSlimeFood;
    }

    public IRecipeType<?> func_222127_g() {
        return DarkUtils.content.recipeTypeSlimeFood;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)Items.field_151123_aH);
    }

    public boolean func_192399_d() {
        return true;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public int getSlimePoints() {
        return this.points;
    }

    public boolean isValid(ItemStack input, SlimeCrucibleType type) {
        return type.matchesAny(this.validTypes) && this.input.test(input);
    }

    private static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RecipeSlimeFood> {
        private Serializer() {
        }

        public RecipeSlimeFood read(ResourceLocation recipeId, JsonObject json) {
            JsonArray inputElement = JSONUtils.func_151202_d((JsonObject)json, (String)"input") ? JSONUtils.func_151214_t((JsonObject)json, (String)"input") : JSONUtils.func_152754_s((JsonObject)json, (String)"input");
            Ingredient input = Ingredient.func_199802_a((JsonElement)inputElement);
            int points = JSONUtils.func_151203_m((JsonObject)json, (String)"points");
            JsonArray typesArray = JSONUtils.func_151214_t((JsonObject)json, (String)"validTypes");
            HashSet<SlimeCrucibleType> types = new HashSet<SlimeCrucibleType>();
            for (int i = 0; i < typesArray.size(); ++i) {
                ResourceLocation id = new ResourceLocation(typesArray.get(i).getAsString());
                SlimeCrucibleType type = SlimeCrucibleType.getType(id);
                if (type == null) continue;
                types.add(type);
            }
            if (types.isEmpty()) {
                DarkUtils.LOG.warn("The slime food recipe {} has no valid types. It will not be obtainable. Some valid vanilla types are {}.", (Object)recipeId, (Object)Arrays.toString(SlimeCrucibleType.getTypeKeys().toArray()));
            }
            return new RecipeSlimeFood(recipeId, input, points, types.toArray(new SlimeCrucibleType[types.size()]));
        }

        public RecipeSlimeFood read(ResourceLocation recipeId, PacketBuffer buffer) {
            Ingredient input = Ingredient.func_199566_b((PacketBuffer)buffer);
            int points = buffer.readInt();
            SlimeCrucibleType[] types = new SlimeCrucibleType[buffer.readInt()];
            for (int i = 0; i < types.length; ++i) {
                types[i] = SlimeCrucibleType.getType(buffer.func_192575_l());
            }
            return new RecipeSlimeFood(recipeId, input, points, types);
        }

        public void write(PacketBuffer buffer, RecipeSlimeFood recipe) {
            recipe.input.func_199564_a(buffer);
            buffer.writeInt(recipe.points);
            buffer.writeInt(recipe.validTypes.length);
            for (SlimeCrucibleType type : recipe.validTypes) {
                buffer.func_192572_a(type.getRegistryName());
            }
        }
    }
}

