/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.slimecrucible;

import com.mojang.blaze3d.platform.GlStateManager;
import net.darkhax.darkutils.features.slimecrucible.TileEntitySlimeCrucible;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderSlimeCrucible
extends TileEntityRenderer<TileEntitySlimeCrucible> {
    public void render(TileEntitySlimeCrucible tile, double x, double y, double z, float partialTicks, int destroyStage) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x + 0.5f), (float)((float)(y + tile.getEntityHeightOffset())), (float)((float)z + 0.5f));
        this.renderCustomName(tile, x, y, z);
        this.renderMob(tile, x, y, z, partialTicks);
        GlStateManager.popMatrix();
    }

    private void renderCustomName(TileEntitySlimeCrucible tile, double x, double y, double z) {
        if (tile.func_145818_k_()) {
            this.func_190053_a(true);
            this.func_190052_a((TileEntity)tile, tile.func_145748_c_().func_150254_d(), x, y + tile.getEntityHeightOffset() + 0.25, z, 12);
            this.func_190053_a(false);
        }
    }

    private void renderMob(TileEntitySlimeCrucible tile, double posX, double posY, double posZ, float partialTicks) {
        SlimeEntity entity = tile.getContainedSlime(tile.func_145831_w());
        if (entity != null) {
            float scale = 1.5f;
            GlStateManager.scalef((float)1.5f, (float)1.5f, (float)1.5f);
            GlStateManager.rotatef((float)tile.getSideToFace().func_185119_l(), (float)0.0f, (float)1.0f, (float)0.0f);
            float elapsedSquish = MathHelper.func_219799_g((float)partialTicks, (float)tile.getPrevSquishFactor(), (float)tile.getSquishFactor()) / 4.0f;
            float squishOffset = 1.0f / (elapsedSquish + 1.0f);
            GlStateManager.scalef((float)squishOffset, (float)(1.0f / squishOffset), (float)squishOffset);
            Minecraft.func_71410_x().func_175598_ae().func_188391_a((Entity)entity, 0.0, 0.0, 0.0, 0.0f, partialTicks, false);
        }
    }
}

