/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.slimecrucible;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.darkhax.bookshelf.util.MathsUtils;
import net.darkhax.bookshelf.util.RenderUtils;
import net.darkhax.darkutils.features.slimecrucible.ContainerSlimeCrucible;
import net.darkhax.darkutils.features.slimecrucible.RecipeSlimeCrafting;
import net.darkhax.darkutils.features.slimecrucible.SlimeCrucibleEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

@OnlyIn(value=Dist.CLIENT)
public class ScreenSlimeCrucible
extends ContainerScreen<ContainerSlimeCrucible> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("darkutils", "textures/gui/container/slime_crucible.png");
    private final World clientWorld;
    private float sliderProgress;
    private boolean mouseBeingDragged;
    private int recipeIndexOffset;
    private boolean showRecipes;
    private SlimeEntity renderEntity;
    public static final RenderUtils.IQuadColorHandler DARKEN_QUAD_COLORS = (stack, quad, providedColor) -> {
        int originalColor = RenderUtils.DEFAULT_QUAD_COLORS.getColorForQuad(stack, quad, providedColor);
        return MathsUtils.multiplyColor((int)originalColor, (float)0.6f);
    };

    public ScreenSlimeCrucible(ContainerSlimeCrucible container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.clientWorld = playerInventory.field_70458_d.field_70170_p;
        container.setUpdateListener(this::listenToContainerUpdate);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        int selectionBoxX = this.field_147003_i + 52;
        int selectionBoxY = this.field_147009_r + 14;
        int lastRecipeIndex = this.recipeIndexOffset + 12;
        if (this.renderEntity != null) {
            int x = this.field_147003_i + 28;
            int y = this.field_147009_r + 38;
            InventoryScreen.func_147046_a((int)x, (int)y, (int)30, (float)(x - mouseX), (float)(y - mouseY), (LivingEntity)this.renderEntity);
        } else if (((ContainerSlimeCrucible)this.field_147002_h).getCrucibleType() != null) {
            this.renderEntity = ((ContainerSlimeCrucible)this.field_147002_h).getCrucibleType().createSlime(this.clientWorld);
        }
        this.func_191948_b(mouseX, mouseY);
        this.renderRecipeTooltips(selectionBoxX, selectionBoxY, mouseX, mouseY, lastRecipeIndex);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.font.func_211126_b(this.title.func_150254_d(), 8.0f, 4.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_145748_c_().func_150254_d(), 8.0f, (float)this.field_147000_g - 94.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.renderBackground();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(TEXTURE);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int sliderHeightOffset = (int)(41.0f * this.sliderProgress);
        this.blit(this.field_147003_i + 119, this.field_147009_r + 15 + sliderHeightOffset, 176 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        int selectionBoxX = this.field_147003_i + 52;
        int selectionBoxY = this.field_147009_r + 14;
        int lastRecipeIndex = this.recipeIndexOffset + 12;
        this.renderRecipeOutputButtons(mouseX, mouseY, selectionBoxX, selectionBoxY, lastRecipeIndex);
        this.renderRecipeOutputs(mouseX, mouseY, selectionBoxX, selectionBoxY, lastRecipeIndex);
    }

    private void renderRecipeOutputButtons(int mouseX, int mouseY, int selectionBoxX, int selectionBoxY, int lastRecipeIndex) {
        for (int i = this.recipeIndexOffset; i < lastRecipeIndex && i < ((ContainerSlimeCrucible)this.field_147002_h).getAvailableRecipesSize(); ++i) {
            int recipeIndex = i - this.recipeIndexOffset;
            int recipeX = selectionBoxX + recipeIndex % 4 * 16;
            int recipeRow = recipeIndex / 4;
            int recipeY = selectionBoxY + recipeRow * 18 + 2;
            boolean canCraftRecipe = ((ContainerSlimeCrucible)this.field_147002_h).canCraft(i);
            RecipeSlimeCrafting recipe = ((ContainerSlimeCrucible)this.field_147002_h).getAvailableRecipes().get(i);
            int textureY = this.field_147000_g;
            int color = -1;
            boolean isRecipeVisible = recipe.isHidden() ? canCraftRecipe : true;
            SlimeCrucibleEvents.RecipeVisibleEvent event = new SlimeCrucibleEvents.RecipeVisibleEvent(recipe, (PlayerEntity)Minecraft.func_71410_x().field_71439_g, isRecipeVisible);
            MinecraftForge.EVENT_BUS.post((Event)event);
            isRecipeVisible = event.isVisible();
            if (!isRecipeVisible) continue;
            if (!canCraftRecipe) {
                textureY += 54;
            } else if (i == ((ContainerSlimeCrucible)this.field_147002_h).getSelectedRecipeId()) {
                textureY += 18;
            } else if (mouseX >= recipeX && mouseY >= recipeY && mouseX < recipeX + 16 && mouseY < recipeY + 18) {
                textureY += 36;
                color = ((ContainerSlimeCrucible)this.field_147002_h).getCrucibleType().getOverlayColor();
            }
            RenderUtils.drawTexturedRect((int)recipeX, (int)(recipeY - 1), (int)this.blitOffset, (float)0.0f, (float)textureY, (int)16, (int)18, (float)256.0f, (float)256.0f, (int)color);
        }
    }

    private void renderRecipeOutputs(int mouseX, int mouseY, int selectionBoxX, int selectionBoxY, int lastRecipeIndex) {
        RenderHelper.func_74520_c();
        List<RecipeSlimeCrafting> list = ((ContainerSlimeCrucible)this.field_147002_h).getAvailableRecipes();
        for (int i = this.recipeIndexOffset; i < lastRecipeIndex && i < ((ContainerSlimeCrucible)this.field_147002_h).getAvailableRecipesSize(); ++i) {
            int recipeIndex = i - this.recipeIndexOffset;
            int recipeItemX = selectionBoxX + recipeIndex % 4 * 16;
            int recipeRow = recipeIndex / 4;
            int recipeItemY = selectionBoxY + recipeRow * 18 + 2;
            boolean canCraft = ((ContainerSlimeCrucible)this.field_147002_h).canCraft(i);
            if (!canCraft && ((ContainerSlimeCrucible)this.field_147002_h).getAvailableRecipes().get(i).isHidden()) continue;
            RenderUtils.renderItemAndEffectIntoGUI((ItemStack)list.get(i).func_77571_b(), (int)recipeItemX, (int)recipeItemY, (int)-1, (RenderUtils.IQuadColorHandler)(canCraft ? RenderUtils.DEFAULT_QUAD_COLORS : DARKEN_QUAD_COLORS));
        }
        RenderHelper.func_74518_a();
    }

    private void renderRecipeTooltips(int selectionBoxX, int selectionBoxY, int mouseX, int mouseY, int lastRecipeIndex) {
        for (int i = this.recipeIndexOffset; i < lastRecipeIndex && i < ((ContainerSlimeCrucible)this.field_147002_h).getAvailableRecipesSize(); ++i) {
            int recipeIndex = i - this.recipeIndexOffset;
            int recipeItemX = selectionBoxX + recipeIndex % 4 * 16;
            int recipeRow = recipeIndex / 4;
            int recipeItemY = selectionBoxY + recipeRow * 18 + 2;
            if (mouseX < recipeItemX || mouseY < recipeItemY || mouseX >= recipeItemX + 16 || mouseY >= recipeItemY + 18) continue;
            RecipeSlimeCrafting recipe = ((ContainerSlimeCrucible)this.field_147002_h).getAvailableRecipes().get(i);
            ItemStack[] inputs = recipe.getValidItemStacks();
            if (recipe.isHidden() && !((ContainerSlimeCrucible)this.field_147002_h).canCraft(i)) break;
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(recipe.func_77571_b().func_200301_q().func_150254_d());
            TextFormatting inputColor = recipe.isValid(((ContainerSlimeCrucible)this.field_147002_h).getCurrentInput()) ? TextFormatting.GREEN : TextFormatting.RED;
            TextFormatting slimeColor = recipe.getSlimePoints() <= ((ContainerSlimeCrucible)this.field_147002_h).getSlimePoints() ? TextFormatting.GREEN : TextFormatting.RED;
            ItemStack inputStack = inputs[(int)(this.clientWorld.func_82737_E() / 20L % (long)inputs.length)];
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltips.darkutils.input", (Object[])new Object[]{inputColor, inputStack.func_200301_q().func_150254_d(), recipe.getInputCount()}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltips.darkutils.slime_points", (Object[])new Object[]{((ContainerSlimeCrucible)this.field_147002_h).getCrucibleType().getMaterialName().func_150254_d(), slimeColor, recipe.getSlimePoints()}));
            this.renderTooltip(tooltip, mouseX, mouseY);
            break;
        }
        int x = this.field_147003_i + 20;
        int y = this.field_147009_r + 22;
        if (mouseX >= x && mouseY >= y && mouseX < x + 16 && mouseY < y + 16) {
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(I18n.func_135052_a((String)"tooltips.darkutils.slime_points", (Object[])new Object[]{((ContainerSlimeCrucible)this.field_147002_h).getCrucibleType().getMaterialName().func_150254_d(), TextFormatting.WHITE, ((ContainerSlimeCrucible)this.field_147002_h).getSlimePoints()}));
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"tooltips.darkutils.slime_crucible.info", (Object[])new Object[]{((ContainerSlimeCrucible)this.field_147002_h).getCrucibleType().getMaterialName().func_150254_d()}));
            this.renderTooltip(tooltip, mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int buttonId) {
        this.mouseBeingDragged = false;
        if (this.showRecipes) {
            int selectionBoxX = this.field_147003_i + 52;
            int selectionBoxY = this.field_147009_r + 14;
            for (int recipeId = this.recipeIndexOffset; recipeId < this.recipeIndexOffset + 12; ++recipeId) {
                int recipeButtonId = recipeId - this.recipeIndexOffset;
                double relativeClickX = mouseX - (double)(selectionBoxX + recipeButtonId % 4 * 16);
                double relativeClickY = mouseY - (double)(selectionBoxY + recipeButtonId / 4 * 18);
                if (!(relativeClickX >= 0.0) || !(relativeClickY >= 0.0) || !(relativeClickX < 16.0) || !(relativeClickY < 18.0) || !((ContainerSlimeCrucible)this.field_147002_h).func_75140_a((PlayerEntity)this.minecraft.field_71439_g, recipeId)) continue;
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)((ContainerSlimeCrucible)this.field_147002_h).getCrucibleType().getCraftingSound(), (float)1.0f));
                this.minecraft.field_71442_b.func_78756_a(((ContainerSlimeCrucible)this.field_147002_h).field_75152_c, recipeId);
                return true;
            }
            int scrollerX = this.field_147003_i + 119;
            int scrollerY = this.field_147009_r + 9;
            if (mouseX >= (double)scrollerX && mouseX < (double)(scrollerX + 12) && mouseY >= (double)scrollerY && mouseY < (double)(scrollerY + 62)) {
                this.mouseBeingDragged = true;
            }
        }
        int x = this.field_147003_i + 20;
        int y = this.field_147009_r + 22;
        ItemStack mouseItem = this.field_213127_e.func_70445_o();
        if (mouseX >= (double)x && mouseY >= (double)y && mouseX < (double)(x + 16) && mouseY < (double)(y + 16) && ((ContainerSlimeCrucible)this.field_147002_h).func_75140_a((PlayerEntity)this.minecraft.field_71439_g, -42)) {
            this.minecraft.field_71442_b.func_78756_a(((ContainerSlimeCrucible)this.field_147002_h).field_75152_c, -42);
            this.renderEntity.field_70813_a = 1.0f;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)this.renderEntity.func_213353_d(mouseItem), (float)1.0f));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, buttonId);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButtonId, double dragX, double dragY) {
        if (this.mouseBeingDragged && this.canScroll()) {
            int i = this.field_147009_r + 14;
            int j = i + 54;
            this.sliderProgress = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)this.getHiddenRows()) + 0.5) * 4;
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButtonId, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseDelta) {
        if (this.canScroll()) {
            int hiddenRows = this.getHiddenRows();
            this.sliderProgress = (float)((double)this.sliderProgress - mouseDelta / (double)hiddenRows);
            this.sliderProgress = MathHelper.func_76131_a((float)this.sliderProgress, (float)0.0f, (float)1.0f);
            this.recipeIndexOffset = (int)((double)(this.sliderProgress * (float)hiddenRows) + 0.5) * 4;
        }
        return true;
    }

    private boolean canScroll() {
        return this.showRecipes && ((ContainerSlimeCrucible)this.field_147002_h).getAvailableRecipesSize() > 12;
    }

    protected int getHiddenRows() {
        int size = ((ContainerSlimeCrucible)this.field_147002_h).getAvailableRecipesSize();
        return size > 12 ? (size + 3) / 4 - 3 : 0;
    }

    private void listenToContainerUpdate(IInventory inventory) {
        ((ContainerSlimeCrucible)this.field_147002_h).func_75130_a(inventory);
        this.showRecipes = ((ContainerSlimeCrucible)this.field_147002_h).canDisplayRecipes();
        if (!this.showRecipes) {
            this.sliderProgress = 0.0f;
            this.recipeIndexOffset = 0;
        }
    }
}

