/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.slimecrucible;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.darkhax.darkutils.DarkUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class SlimeCrucibleType {
    private static final Map<ResourceLocation, SlimeCrucibleType> REGISTRY_MAP = new HashMap<ResourceLocation, SlimeCrucibleType>();
    private final ResourceLocation id;
    private final SoundEvent craftingSound;
    private final SoundEvent happySound;
    private final ITextComponent containerName;
    private final ITextComponent materialName;
    private final int maxSlimePoints;
    private final int overlayColor;
    private final Function<World, SlimeEntity> entityBuilder;

    public SlimeCrucibleType(ResourceLocation id, int maxSlimePoints, Function<World, SlimeEntity> entityBuilder, SoundEvent craftingSound, SoundEvent happySound, int overlayColor) {
        this.id = id;
        this.maxSlimePoints = maxSlimePoints;
        this.entityBuilder = entityBuilder;
        this.craftingSound = craftingSound;
        this.happySound = happySound;
        this.overlayColor = overlayColor;
        this.containerName = new TranslationTextComponent("container." + id.func_110624_b() + ".slime_crucible." + id.func_110623_a(), new Object[0]);
        this.materialName = new TranslationTextComponent("tooltips." + id.func_110624_b() + ".slime_crucible.material." + id.func_110623_a(), new Object[0]);
        REGISTRY_MAP.put(id, this);
    }

    public ResourceLocation getRegistryName() {
        return this.id;
    }

    public SlimeEntity createSlime(World world) {
        if (this.entityBuilder == null) {
            throw new IllegalArgumentException(this == DarkUtils.content.crucibleTypeAll ? "Someone tried to create an instance of the ALL slime type. This is an unsupported operation." : "The slime type " + this.id + " does not have an entityBuilder. This is not allowed.");
        }
        return this.entityBuilder.apply(world);
    }

    public boolean matchesAny(SlimeCrucibleType ... otherTypes) {
        for (SlimeCrucibleType otherType : otherTypes) {
            if (!this.matches(otherType)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(SlimeCrucibleType otherType) {
        return this == DarkUtils.content.crucibleTypeAll || otherType == this || otherType == DarkUtils.content.crucibleTypeAll;
    }

    @Nullable
    public static SlimeCrucibleType getType(ResourceLocation key) {
        return REGISTRY_MAP.get(key);
    }

    public SoundEvent getCraftingSound() {
        return this.craftingSound;
    }

    public SoundEvent getHappySound() {
        return this.happySound;
    }

    public Function<World, SlimeEntity> getEntityBuilder() {
        return this.entityBuilder;
    }

    public ITextComponent getContainerDisplayName(BlockState state, World world, BlockPos pos) {
        return this.containerName;
    }

    public ITextComponent getMaterialName() {
        return this.materialName;
    }

    public int getMaxSlimePoints() {
        return this.maxSlimePoints;
    }

    public int getOverlayColor() {
        return this.overlayColor;
    }

    public static Set<ResourceLocation> getTypeKeys() {
        return REGISTRY_MAP.keySet();
    }
}

