/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.slimecrucible;

import javax.annotation.Nullable;
import net.darkhax.bookshelf.block.tileentity.TileEntityBasicTickable;
import net.darkhax.bookshelf.util.WorldUtils;
import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.slimecrucible.ContainerSlimeCrucible;
import net.darkhax.darkutils.features.slimecrucible.ISlimeCrucibleBlock;
import net.darkhax.darkutils.features.slimecrucible.RecipeSlimeFood;
import net.darkhax.darkutils.features.slimecrucible.SlimeCrucibleType;
import net.minecraft.block.Block;
import net.minecraft.block.ComposterBlock;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class TileEntitySlimeCrucible
extends TileEntityBasicTickable
implements INamedContainerProvider,
INameable {
    private ITextComponent customName;
    private int slimePoints = 0;
    private Direction sideToFace = Direction.SOUTH;
    private double slimeHeightOffset = 0.2f;
    private float squishFactor = 0.0f;
    private float prevSquishFactor = 0.0f;
    private float squishAmount = 0.0f;
    private SlimeEntity entity;

    public TileEntitySlimeCrucible() {
        super(DarkUtils.content.tileSlimeCrucible);
    }

    public void serialize(CompoundNBT dataTag) {
        dataTag.func_74768_a("SlimePoints", this.slimePoints);
        if (this.customName != null) {
            dataTag.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
    }

    public void deserialize(CompoundNBT dataTag) {
        this.slimePoints = dataTag.func_74762_e("SlimePoints");
        if (dataTag.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_150699_a((String)dataTag.func_74779_i("CustomName"));
        }
    }

    public void onTileTick() {
        BlockPos pos = this.func_174877_v();
        PlayerEntity player = this.func_145831_w().func_190525_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 4.5, curPlayer -> !curPlayer.func_175149_v() && !curPlayer.func_82150_aj());
        if (player != null) {
            double distX = player.field_70165_t - (double)((float)this.func_174877_v().func_177958_n() + 0.5f);
            double distZ = player.field_70161_v - (double)((float)this.func_174877_v().func_177952_p() + 0.5f);
            double angle = MathHelper.func_181159_b((double)distX, (double)distZ) * 180.0 / Math.PI;
            this.sideToFace = Direction.func_176733_a((double)(angle + 180.0)).func_176734_d();
            if (this.slimeHeightOffset < 0.85) {
                this.slimeHeightOffset = Math.min(this.slimeHeightOffset + 0.05, 0.85);
            }
        } else if (this.slimeHeightOffset > 0.2) {
            this.slimeHeightOffset = Math.max(this.slimeHeightOffset - 0.03, 0.2);
        }
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        this.squishAmount *= 0.55f;
    }

    public SlimeEntity getContainedSlime(World world) {
        if (this.entity == null) {
            this.entity = this.getCrucibleType().createSlime(world);
        }
        return this.entity;
    }

    public Direction getSideToFace() {
        return this.sideToFace;
    }

    public double getEntityHeightOffset() {
        return this.slimeHeightOffset;
    }

    public int getContainedSlimePoints() {
        return this.slimePoints;
    }

    public static int getSlimePointsForItem(World world, ItemStack inputStack, SlimeCrucibleType type) {
        for (RecipeSlimeFood slimeRecipe : WorldUtils.getRecipes(DarkUtils.content.recipeTypeSlimeFood, (RecipeManager)world.func_199532_z()).values()) {
            if (!slimeRecipe.isValid(inputStack, type)) continue;
            return slimeRecipe.getSlimePoints();
        }
        return MathHelper.func_76141_d((float)(ComposterBlock.field_220299_b.getOrDefault((Object)inputStack.func_77973_b(), 0.0f) * 5.0f));
    }

    public float getSquishFactor() {
        return this.squishFactor;
    }

    public float getPrevSquishFactor() {
        return this.prevSquishFactor;
    }

    public float getSquishAmount() {
        return this.squishAmount;
    }

    public void setSquishAmount(float amount) {
        this.squishAmount = amount;
    }

    public void addSlimePoints(int points) {
        this.slimePoints = Math.min(this.slimePoints + points, this.getCrucibleType().getMaxSlimePoints());
    }

    public void removeSlimePoints(int points) {
        this.slimePoints = Math.max(0, this.slimePoints - points);
    }

    public void setCustomName(ITextComponent name) {
        this.customName = name;
    }

    @Nullable
    public SlimeCrucibleType getCrucibleType() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof ISlimeCrucibleBlock) {
            return ((ISlimeCrucibleBlock)block).getCrucibleType();
        }
        return null;
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerSlimeCrucible(id, playerInventory, IWorldPosCallable.func_221488_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v()));
    }

    public ITextComponent func_200200_C_() {
        if (this.func_145818_k_()) {
            return this.func_200201_e();
        }
        if (this.getCrucibleType() != null) {
            return this.getCrucibleType().getContainerDisplayName(this.func_195044_w(), this.func_145831_w(), this.func_174877_v());
        }
        return new StringTextComponent("Error");
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public ITextComponent func_200201_e() {
        return this.customName;
    }
}

