/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.material;

import net.darkhax.bookshelf.item.ItemBlockBasic;
import net.darkhax.darkutils.DarkUtils;
import net.darkhax.darkutils.features.DUFeature;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.material.BehaviorDispenseWitherDust;
import net.darkhax.darkutils.features.material.BlockWitherDust;
import net.darkhax.darkutils.features.material.ItemMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;

@DUFeature(name="Crafting Materials", description="Material items used throughout DarkUtils")
public class FeatureMaterial
extends Feature {
    public static Item itemMaterial = new ItemMaterial();
    public static Block blockWitherDust = new BlockWitherDust();
    private static boolean skeletonDropDust = true;
    private static int dustDropWeight = 1;

    @Override
    public void onPreInit() {
        itemMaterial = DarkUtils.REGISTRY.registerItem(itemMaterial, "material");
        DarkUtils.REGISTRY.registerBlock(blockWitherDust, (ItemBlock)new ItemBlockBasic(blockWitherDust, BlockWitherDust.types, false), "wither_block");
        BlockDispenser.field_149943_a.func_82595_a((Object)itemMaterial, (Object)new BehaviorDispenseWitherDust());
    }

    @Override
    public void onPreRecipe() {
        DarkUtils.REGISTRY.addShapelessRecipe("skull_to_witherdust", new ItemStack(itemMaterial, 3, 0), new Object[]{new ItemStack(Items.field_151144_bL, 1, 1)});
        DarkUtils.REGISTRY.addShapelessRecipe("dwindlecream", new ItemStack(itemMaterial, 1, 2), new Object[]{new ItemStack(itemMaterial, 1, 0), "slimeball"});
        DarkUtils.REGISTRY.addShapelessRecipe("unstable_pearl", new ItemStack(itemMaterial, 1, 1), new Object[]{new ItemStack(itemMaterial, 1, 0), "enderpearl"});
        DarkUtils.REGISTRY.addShapedRecipe("dark_sugar", new ItemStack(itemMaterial, 8, 3), new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151102_aT, Character.valueOf('y'), itemMaterial});
        DarkUtils.REGISTRY.addShapedRecipe("soulsand", new ItemStack(Blocks.field_150425_aM, 5, 0), new Object[]{"xyx", "yxy", "xyx", Character.valueOf('x'), "sand", Character.valueOf('y'), itemMaterial});
        DarkUtils.REGISTRY.addShapedRecipe("compact_wither", new ItemStack(blockWitherDust, 1, 0), new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack(itemMaterial, 1, 0)});
        DarkUtils.REGISTRY.addShapelessRecipe("deconstruct_wither", new ItemStack(itemMaterial, 4, 0), new Object[]{new ItemStack(blockWitherDust, 3, Short.MAX_VALUE)});
        DarkUtils.REGISTRY.addShapedRecipe("convert_wither_1", new ItemStack(blockWitherDust, 4, 1), new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 0)});
        DarkUtils.REGISTRY.addShapedRecipe("convert_wither_2", new ItemStack(blockWitherDust, 4, 2), new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 1)});
        DarkUtils.REGISTRY.addShapedRecipe("convert_wither_3", new ItemStack(blockWitherDust, 4, 3), new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 2)});
        DarkUtils.REGISTRY.addShapedRecipe("convert_wither_4", new ItemStack(blockWitherDust, 4, 4), new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 3)});
        DarkUtils.REGISTRY.addShapedRecipe("convert_wither_5", new ItemStack(blockWitherDust, 4, 5), new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 4)});
        DarkUtils.REGISTRY.addShapedRecipe("convert_wither_6", new ItemStack(blockWitherDust, 4, 0), new Object[]{"xx", "xx", Character.valueOf('x'), new ItemStack(blockWitherDust, 1, 5)});
    }

    @Override
    public void onInit() {
        OreDictionary.registerOre((String)"blockWither", (ItemStack)new ItemStack(blockWitherDust, 1, Short.MAX_VALUE));
    }

    @Override
    public void setupConfiguration(Configuration config) {
        skeletonDropDust = config.getBoolean("WSkeleton Drop Dust", this.configName, true, "Should wither skeletons drop wither dust?");
        dustDropWeight = config.getInt("Dust Drop Weight", this.configName, 1, 0, 256, "The weighting for Wither Skeletons dropping Wither Dust");
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        LootPool pool1;
        LootTable table = event.getTable();
        if (skeletonDropDust && event.getName().equals((Object)LootTableList.field_186386_ak) && (pool1 = table.getPool("pool1")) != null) {
            pool1.addEntry((LootEntry)new LootEntryItem(itemMaterial, dustDropWeight, 0, new LootFunction[0], new LootCondition[0], "darkutils:wither_dust"));
        }
    }
}

