/*
 * Decompiled with CFR 0.152.
 */
package com.chirptheboy.disenchanting;

import com.chirptheboy.disenchanting.Config;
import com.chirptheboy.disenchanting.blocks.Disenchanter;
import com.chirptheboy.disenchanting.blocks.DisenchanterContainer;
import com.chirptheboy.disenchanting.blocks.DisenchanterTile;
import com.chirptheboy.disenchanting.blocks.ModBlocks;
import com.chirptheboy.disenchanting.setup.ClientProxy;
import com.chirptheboy.disenchanting.setup.IProxy;
import com.chirptheboy.disenchanting.setup.ModSetup;
import com.chirptheboy.disenchanting.setup.ServerProxy;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="disenchanting")
public class Disenchanting {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "disenchanting";
    public static double RARITY_MULTIPLIER = 0.03f;
    public static double RARITY_OFFSET = 1.8f;
    public static int SLIDER_MULTIPLIER = 3;
    public static ModSetup setup = new ModSetup();
    public static IProxy proxy = (IProxy)DistExecutor.runForDist(() -> () -> new ClientProxy(), () -> () -> new ServerProxy());

    public Disenchanting() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("disenchanter-common.toml"));
    }

    private void setup(FMLCommonSetupEvent event) {
        setup.init();
        proxy.init();
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> event) {
            event.getRegistry().register((IForgeRegistryEntry)new Disenchanter());
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> event) {
            Item.Properties properties = new Item.Properties().func_200916_a(Disenchanting.setup.itemGroup);
            event.getRegistry().register(new BlockItem((Block)ModBlocks.DISENCHANTER, properties).setRegistryName("disenchanter"));
        }

        @SubscribeEvent
        public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> event) {
            event.getRegistry().register(TileEntityType.Builder.func_223042_a(DisenchanterTile::new, (Block[])new Block[]{ModBlocks.DISENCHANTER}).func_206865_a(null).setRegistryName("disenchanter"));
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> event) {
            event.getRegistry().register(IForgeContainerType.create((windowId, inv, data) -> {
                BlockPos pos = data.func_179259_c();
                return new DisenchanterContainer(windowId, proxy.getClientWorld(), pos, inv, proxy.getClientPlayer());
            }).setRegistryName("disenchanter"));
        }
    }
}

