/*
 * Decompiled with CFR 0.152.
 */
package com.chirptheboy.disenchanting.blocks;

import com.chirptheboy.disenchanting.Config;
import com.chirptheboy.disenchanting.Disenchanting;
import com.chirptheboy.disenchanting.blocks.ModBlocks;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class DisenchanterContainer
extends Container {
    private TileEntity tileEntity;
    private PlayerEntity playerEntity;
    private IItemHandler playerInventory;
    private Enchantment firstEnchantment;
    private int action;
    private int experienceCostSlider;
    private boolean requireXP;
    public final int[] enchantLevels = new int[1];

    public DisenchanterContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        super(ModBlocks.DISENCHANTER_CONTAINER, windowId);
        this.tileEntity = world.func_175625_s(pos);
        this.playerEntity = player;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.action = -1;
        this.requireXP = (Boolean)Config.DISENCHANTER_REQUIRES_XP.get();
        this.experienceCostSlider = (Integer)Config.DISENCHANTER_COST.get();
        this.func_216958_a(IntReferenceHolder.func_221497_a((int[])this.enchantLevels, (int)0));
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)h, 0, 28, 24, (IItemHandler)h){
            final /* synthetic */ IItemHandler val$h;
            {
                this.val$h = iItemHandler;
                super(x0, x1, x2, x3);
            }

            public int func_75219_a() {
                return 1;
            }

            public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                return !EnchantmentHelper.func_82781_a((ItemStack)itemStack).isEmpty();
            }

            public ItemStack func_190901_a(PlayerEntity playerEntity, ItemStack itemStack) {
                if (this.val$h.getStackInSlot(0).func_190926_b()) {
                    DisenchanterContainer.this.action = 1;
                }
                DisenchanterContainer.this.updateResult();
                return itemStack;
            }

            public void func_75215_d(@Nonnull ItemStack itemStack) {
                if (!itemStack.func_190926_b()) {
                    DisenchanterContainer.this.action = 0;
                }
                super.func_75215_d(itemStack);
                DisenchanterContainer.this.updateResult();
                this.field_75224_c.func_70296_d();
            }

            public void func_75218_e() {
                super.func_75218_e();
                DisenchanterContainer.this.updateResult();
            }
        }));
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)h, 1, 82, 24, (IItemHandler)h){
            final /* synthetic */ IItemHandler val$h;
            {
                this.val$h = iItemHandler;
                super(x0, x1, x2, x3);
            }

            public boolean func_75214_a(@Nonnull ItemStack itemStack) {
                return itemStack.func_77973_b() == Items.field_151122_aG;
            }

            public ItemStack func_190901_a(PlayerEntity playerEntity, ItemStack itemStack) {
                if (this.val$h.getStackInSlot(1).func_190926_b()) {
                    DisenchanterContainer.this.action = 1;
                }
                DisenchanterContainer.this.updateResult();
                return itemStack;
            }

            public void func_75215_d(@Nonnull ItemStack itemStack) {
                if (!itemStack.func_190926_b()) {
                    DisenchanterContainer.this.action = 0;
                }
                super.func_75215_d(itemStack);
                DisenchanterContainer.this.updateResult();
                this.field_75224_c.func_70296_d();
            }
        }));
        this.tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)h, 2, 136, 24){

            public boolean func_75214_a(@Nonnull ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(PlayerEntity playerEntity) {
                return playerEntity.field_71075_bZ.field_75098_d || this.func_75216_d();
            }

            public ItemStack func_190901_a(PlayerEntity playerEntity, ItemStack itemStack) {
                if (!itemStack.func_190926_b()) {
                    DisenchanterContainer.this.action = 2;
                }
                DisenchanterContainer.this.updateResult();
                return itemStack;
            }
        }));
        this.layoutPlayerInventorySlots(10, 70);
    }

    public void func_75134_a(PlayerEntity playerEntity) {
        ((Slot)this.field_75151_b.get(2)).func_75215_d(ItemStack.field_190927_a);
        super.func_75134_a(playerEntity);
    }

    public String getCostString() {
        return this.enchantLevels[0] < 0 ? "" : "Cost: ";
    }

    public String getExperienceCost() {
        return this.enchantLevels[0] < 0 ? "" : String.valueOf(this.enchantLevels[0]);
    }

    public int getCostColor() {
        return this.playerEntity.field_71068_ca < this.enchantLevels[0] ? 12542799 : 0xFFFFFF;
    }

    public void updateResult() {
        if (!this.playerEntity.field_70170_p.field_72995_K) {
            ItemStack enchantedItemStack = ((Slot)this.field_75151_b.get(0)).func_75211_c();
            ItemStack bookItemStack = ((Slot)this.field_75151_b.get(1)).func_75211_c();
            Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)enchantedItemStack);
            switch (this.action) {
                case 0: {
                    if (enchantedItemStack.func_190926_b() || bookItemStack.func_190926_b() || enchantmentMap.isEmpty()) break;
                    Map.Entry entry = enchantmentMap.entrySet().iterator().next();
                    this.firstEnchantment = (Enchantment)entry.getKey();
                    int firstEnchantmentLevel = (Integer)entry.getValue();
                    int rarity = this.firstEnchantment.func_77324_c().func_185270_a();
                    int maxLevel = this.firstEnchantment.func_77325_b();
                    int n = this.enchantLevels[0] = this.requireXP ? (int)((Disenchanting.RARITY_OFFSET - (double)rarity * Disenchanting.RARITY_MULTIPLIER * (double)(firstEnchantmentLevel / maxLevel)) * (double)this.experienceCostSlider) : -1;
                    if (this.requireXP && this.enchantLevels[0] > this.playerEntity.field_71068_ca) break;
                    ItemStack newEnchantedBook = new ItemStack((IItemProvider)Items.field_151134_bR);
                    EnchantmentHelper.func_82782_a((Map)ImmutableMap.of((Object)this.firstEnchantment, (Object)firstEnchantmentLevel), (ItemStack)newEnchantedBook);
                    ((Slot)this.field_75151_b.get(2)).func_75215_d(newEnchantedBook);
                    this.action = -1;
                    break;
                }
                case 1: {
                    ((Slot)this.field_75151_b.get(2)).func_75215_d(ItemStack.field_190927_a);
                    this.enchantLevels[0] = this.requireXP ? 0 : -1;
                    this.action = -1;
                    break;
                }
                case 2: {
                    if (this.requireXP) {
                        this.playerEntity.func_82242_a(-this.enchantLevels[0]);
                        this.enchantLevels[0] = 0;
                    } else {
                        this.enchantLevels[0] = -1;
                    }
                    ((Slot)this.field_75151_b.get(1)).func_75209_a(1);
                    enchantmentMap.remove(this.firstEnchantment);
                    ItemStack newOutputItem = enchantedItemStack.func_77973_b() == Items.field_151134_bR ? (enchantmentMap.size() > 0 ? new ItemStack((IItemProvider)Items.field_151134_bR) : new ItemStack((IItemProvider)Items.field_151122_aG)) : enchantedItemStack.func_77946_l();
                    EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)newOutputItem);
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(newOutputItem);
                    this.action = -1;
                    break;
                }
            }
            this.func_75142_b();
        }
    }

    public boolean func_75145_c(PlayerEntity playerEntity) {
        return DisenchanterContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)Objects.requireNonNull(this.tileEntity.func_145831_w()), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)this.playerEntity, (Block)ModBlocks.DISENCHANTER);
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index < 3) {
                if (index == 2) {
                    this.action = 2;
                }
                if (!this.func_75135_a(stack, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else if (stack.func_77973_b() == Items.field_151122_aG ? !this.func_75135_a(stack, 1, 2, false) : (!EnchantmentHelper.func_82781_a((ItemStack)stack).isEmpty() ? !this.func_75135_a(stack, 0, 1, false) : (index < 30 ? !this.func_75135_a(stack, 30, 39, false) : index < 39 && !this.func_75135_a(stack, 3, 29, false)))) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        this.updateResult();
        return itemstack;
    }
}

