/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.autonetworklib.network.serialization.buf_serializers.generic.hash_set;

import aurocosh.autonetworklib.network.serialization.interfaces.BufWriter;
import io.netty.buffer.ByteBuf;
import java.util.Map;

public class MapWriter<T extends Map<Object, Object>, K extends T>
implements BufWriter<K> {
    private final BufWriter keyWriter;
    private final BufWriter valueWriter;

    public MapWriter(BufWriter keyWriter, BufWriter valueWriter) {
        this.keyWriter = keyWriter;
        this.valueWriter = valueWriter;
    }

    @Override
    public void write(ByteBuf buf, K values) {
        buf.writeInt(values.size());
        if (values.isEmpty()) {
            return;
        }
        for (Map.Entry entry : values.entrySet()) {
            this.keyWriter.write(buf, entry.getKey());
            this.valueWriter.write(buf, entry.getValue());
        }
    }
}

