/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.client.core.handler.stable_gem;

import aurocosh.divinefavor.client.core.handler.base.IHudDescriptionRenderer;
import aurocosh.divinefavor.client.core.handler.common.DisplayStackExtractors;
import aurocosh.divinefavor.common.custom_data.player.data.favor.SpiritData;
import aurocosh.divinefavor.common.item.base.ModItem;
import aurocosh.divinefavor.common.item.gems.base.IStackUsableGemItem;
import aurocosh.divinefavor.common.lib.extensions.PlayerExtensionsKt;
import aurocosh.divinefavor.common.spirit.base.ModSpirit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Laurocosh/divinefavor/client/core/handler/stable_gem/WarpMarkerHudDescriptionRenderer;", "Laurocosh/divinefavor/client/core/handler/base/IHudDescriptionRenderer;", "()V", "REMAINING_HIGHLIGHT_TICKS_INDEX", "", "drawDescription", "", "mc", "Lnet/minecraft/client/Minecraft;", "width", "height", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "stack", "Lnet/minecraft/item/ItemStack;", "drawName", "", "getUseInfo", "", "gem", "Laurocosh/divinefavor/common/item/gems/base/IStackUsableGemItem;", "divinefavor"})
public final class WarpMarkerHudDescriptionRenderer
implements IHudDescriptionRenderer {
    private static final int REMAINING_HIGHLIGHT_TICKS_INDEX = 12;
    public static final WarpMarkerHudDescriptionRenderer INSTANCE;

    @Override
    public void drawDescription(@NotNull Minecraft mc, int width, int height, @NotNull EntityPlayer player, @NotNull ItemStack stack2, boolean drawName) {
        String string;
        Item item;
        Intrinsics.checkParameterIsNotNull((Object)mc, (String)"mc");
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        if (stack2.func_190926_b()) {
            return;
        }
        Item item2 = item = stack2.func_77973_b();
        if (item2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type aurocosh.divinefavor.common.item.gems.base.IStackUsableGemItem");
        }
        IStackUsableGemItem gemItem = (IStackUsableGemItem)item2;
        String description = this.getUseInfo(player, stack2, gemItem);
        ModSpirit spirit = gemItem.getSpirit();
        SpiritData spiritData = PlayerExtensionsKt.getDivinePlayerData(player).getSpiritData();
        ItemStack displayStack = DisplayStackExtractors.INSTANCE.getDisplayStack(stack2);
        if (gemItem.getConsumeOnUse()) {
            string = I18n.func_135052_a((String)"divinefavor:cost_no_favor", (Object[])new Object[0]);
        } else if (spiritData.isFavorInfinite(spirit.getId())) {
            string = I18n.func_135052_a((String)"divinefavor:favor_infinite", (Object[])new Object[0]);
        } else {
            int value = spiritData.getFavor(spirit.getId());
            int maxLimit = spiritData.getMaxFavor(spirit.getId());
            string = "" + value + '/' + maxLimit;
        }
        String favorDescription = string;
        int alpha = 255;
        int color = 32768 + (alpha << 24);
        int x = width / 2;
        int y = height - 71;
        Integer ticks = (Integer)ReflectionHelper.getPrivateValue(GuiIngame.class, (Object)mc.field_71456_v, (int)REMAINING_HIGHLIGHT_TICKS_INDEX);
        if (Intrinsics.compare((int)ticks, (int)0) <= 0) {
            y += 12;
        }
        if (mc.field_71439_g.field_71075_bZ.field_75098_d) {
            y += 14;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        if (drawName && item instanceof ModItem) {
            String translatedName = I18n.func_135052_a((String)((ModItem)item).getNameKey(), (Object[])new Object[0]);
            mc.field_71466_p.func_175063_a(translatedName, 24.0f, -10.0f, color);
        }
        mc.field_71466_p.func_175063_a(description, 24.0f, 0.0f, color);
        int favorDescriptionWidth = mc.field_71466_p.func_78256_a(favorDescription);
        mc.field_71466_p.func_175063_a(favorDescription, (float)(-favorDescriptionWidth - 22), 0.0f, color);
        GlStateManager.func_179152_a((float)((float)alpha / 255.0f), (float)1.0f, (float)1.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_175599_af().func_175042_a(displayStack, 5, -6);
        mc.field_71446_o.func_110577_a(spirit.getIcon());
        Gui.func_146110_a((int)-21, (int)-6, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        mc.field_71446_o.func_110577_a(spirit.getSymbol());
        Gui.func_146110_a((int)-21, (int)-6, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public final String getUseInfo(@NotNull EntityPlayer player, @NotNull ItemStack stack2, @NotNull IStackUsableGemItem gem2) {
        String string;
        int useCount;
        int n;
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)stack2, (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)gem2, (String)"gem");
        if (gem2.getConsumeOnUse()) {
            n = stack2.func_190916_E();
        } else {
            SpiritData spiritData = PlayerExtensionsKt.getDivinePlayerData(player).getSpiritData();
            int favorValue = spiritData.getFavor(gem2.getSpirit().getId());
            boolean infinite = spiritData.isFavorInfinite(gem2.getSpirit().getId()) || gem2.getFavorCost() == 0;
            n = useCount = infinite ? -1 : favorValue / gem2.getFavorCost();
        }
        if (gem2.getConsumeOnUse()) {
            String string2 = I18n.func_135052_a((String)"tooltip.divinefavor:gem.consume_uses", (Object[])new Object[]{useCount});
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"I18n.format(\"tooltip.div\u2026.consume_uses\", useCount)");
        } else if (useCount < 0) {
            String string3 = I18n.func_135052_a((String)"tooltip.divinefavor:gem.infinite_use", (Object[])new Object[0]);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"I18n.format(\"tooltip.div\u2026efavor:gem.infinite_use\")");
        } else if (useCount == 0) {
            String string4 = I18n.func_135052_a((String)"tooltip.divinefavor:gem.unusable", (Object[])new Object[0]);
            string = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"I18n.format(\"tooltip.divinefavor:gem.unusable\")");
        } else {
            String string5 = I18n.func_135052_a((String)"tooltip.divinefavor:gem.cost", (Object[])new Object[]{gem2.getFavorCost(), useCount});
            string = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"I18n.format(\"tooltip.div\u2026 gem.favorCost, useCount)");
        }
        return string;
    }

    private WarpMarkerHudDescriptionRenderer() {
    }

    static {
        WarpMarkerHudDescriptionRenderer warpMarkerHudDescriptionRenderer;
        INSTANCE = warpMarkerHudDescriptionRenderer = new WarpMarkerHudDescriptionRenderer();
        REMAINING_HIGHLIGHT_TICKS_INDEX = 12;
    }
}

