/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.client.render.block_overlay;

import aurocosh.divinefavor.common.block_templates.AbsoluteBlockState;
import aurocosh.divinefavor.common.block_templates.BlockTemplate;
import aurocosh.divinefavor.common.config.common.ConfigGeneral;
import aurocosh.divinefavor.common.custom_data.global.GlobalSaveDataId;
import aurocosh.divinefavor.common.custom_data.global.ModGlobalSaveDataKt;
import aurocosh.divinefavor.common.custom_data.global.TemplateSavedData;
import aurocosh.divinefavor.common.lib.CustomBufferBuilder;
import aurocosh.divinefavor.common.lib.LimitedMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Laurocosh/divinefavor/client/render/block_overlay/BlockTemplateBufferBuilder;", "", "()V", "bufferMap", "Laurocosh/divinefavor/common/lib/LimitedMap;", "Ljava/util/UUID;", "Laurocosh/divinefavor/common/lib/CustomBufferBuilder;", "limit", "", "getLimit", "()I", "buildBuffer", "template", "Laurocosh/divinefavor/common/block_templates/BlockTemplate;", "world", "Lnet/minecraft/world/World;", "getBuffer", "uuid", "divinefavor"})
public final class BlockTemplateBufferBuilder {
    private static final int limit;
    private static final LimitedMap<UUID, CustomBufferBuilder> bufferMap;
    public static final BlockTemplateBufferBuilder INSTANCE;

    public final int getLimit() {
        return limit;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CustomBufferBuilder getBuffer(@NotNull UUID uuid, @NotNull World world) {
        TemplateSavedData templateSavedData;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)uuid, (String)"uuid");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        CustomBufferBuilder bufferBuilder = (CustomBufferBuilder)((Object)bufferMap.get(uuid));
        if (bufferBuilder != null) {
            return bufferBuilder;
        }
        World world2 = world;
        GlobalSaveDataId<TemplateSavedData> globalDataId$iv = ModGlobalSaveDataKt.getTemplateData();
        MapStorage mapStorage = $receiver$iv.func_175693_T();
        if (mapStorage == null) {
            throw (Throwable)new IllegalStateException("World#getMapStorage returned null. The following WorldSave is inaccessible: " + globalDataId$iv + ".name");
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)mapStorage, (String)"this.mapStorage\n        \u2026ble: $globalDataId.name\")");
        MapStorage storage$iv = mapStorage;
        WorldSavedData instance$iv = storage$iv.func_75742_a(globalDataId$iv.getClazz(), globalDataId$iv.getName());
        if (instance$iv != null) {
            templateSavedData = (TemplateSavedData)instance$iv;
        } else {
            TemplateSavedData newInstance$iv = globalDataId$iv.makeNewInstance();
            storage$iv.func_75745_a(globalDataId$iv.getName(), (WorldSavedData)newInstance$iv);
            templateSavedData = newInstance$iv;
        }
        TemplateSavedData templateSavedData2 = templateSavedData;
        BlockTemplate blockTemplate = templateSavedData2.get(uuid);
        if (blockTemplate == null) {
            return null;
        }
        BlockTemplate compound = blockTemplate;
        CustomBufferBuilder customBufferBuilder = this.buildBuffer(compound, world);
        if (customBufferBuilder == null) {
            return null;
        }
        CustomBufferBuilder newBufferBuilder = customBufferBuilder;
        Map map2 = bufferMap;
        CustomBufferBuilder customBufferBuilder2 = newBufferBuilder;
        map2.put(uuid, customBufferBuilder2);
        return newBufferBuilder;
    }

    private final CustomBufferBuilder buildBuffer(BlockTemplate template, World world) {
        BlockPos blockPos2 = BlockPos.field_177992_a;
        Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"BlockPos.ORIGIN");
        List<AbsoluteBlockState> blockMapList = template.getAbsoluteBlockMap(blockPos2);
        if (blockMapList.isEmpty()) {
            return null;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        Intrinsics.checkExpressionValueIsNotNull((Object)minecraft, (String)"Minecraft.getMinecraft()");
        BlockRendererDispatcher dispatcher = minecraft.func_175602_ab();
        CustomBufferBuilder bufferBuilder = new CustomBufferBuilder(0x200000);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        for (AbsoluteBlockState blockMap : blockMapList) {
            IBlockState renderBlockState = blockMap.getState();
            Block block = Blocks.field_150350_a;
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"Blocks.AIR");
            if (!(Intrinsics.areEqual((Object)renderBlockState, (Object)block.func_176223_P()) ^ true)) continue;
            IBakedModel model = dispatcher.func_184389_a(renderBlockState);
            BlockRendererDispatcher blockRendererDispatcher = dispatcher;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockRendererDispatcher, (String)"dispatcher");
            blockRendererDispatcher.func_175019_b().func_187497_c((IBlockAccess)world, model, renderBlockState, blockMap.getOffset(), (BufferBuilder)bufferBuilder, false, 0L);
        }
        bufferBuilder.func_178977_d();
        return bufferBuilder;
    }

    private BlockTemplateBufferBuilder() {
    }

    static {
        BlockTemplateBufferBuilder blockTemplateBufferBuilder;
        INSTANCE = blockTemplateBufferBuilder = new BlockTemplateBufferBuilder();
        limit = ConfigGeneral.temporaryTemplateLimit + ConfigGeneral.persistentTemplateLimit;
        bufferMap = new LimitedMap(limit);
    }
}

