/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.area;

import aurocosh.divinefavor.common.lib.math.CuboidBoundingBox;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0014\u0010\u000b\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rJ\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007J\b\u0010\u0012\u001a\u00020\tH\u0002J\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Laurocosh/divinefavor/common/area/WorldArea;", "", "()V", "boundingBox", "Laurocosh/divinefavor/common/lib/math/CuboidBoundingBox;", "positions", "", "Lnet/minecraft/util/math/BlockPos;", "addPosition", "", "pos", "addPositions", "posList", "", "clearPositions", "isApartOfArea", "", "position", "refreshBoundingBox", "removePosition", "divinefavor"})
public final class WorldArea {
    private final Set<BlockPos> positions = new HashSet();
    private CuboidBoundingBox boundingBox = new CuboidBoundingBox();

    public final void addPositions(@NotNull List<? extends BlockPos> posList2) {
        Intrinsics.checkParameterIsNotNull(posList2, (String)"posList");
        this.positions.addAll((Collection<BlockPos>)posList2);
        this.refreshBoundingBox();
    }

    public final void addPosition(@NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        this.positions.add(pos2);
        this.refreshBoundingBox();
    }

    public final void removePosition(@NotNull BlockPos pos2) {
        Intrinsics.checkParameterIsNotNull((Object)pos2, (String)"pos");
        this.positions.remove(pos2);
        this.refreshBoundingBox();
    }

    public final void clearPositions() {
        this.positions.clear();
        this.refreshBoundingBox();
    }

    private final void refreshBoundingBox() {
        this.boundingBox = CuboidBoundingBox.Companion.getBoundingBox((Collection<? extends BlockPos>)this.positions);
    }

    public final boolean isApartOfArea(@NotNull BlockPos position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        return this.boundingBox.isCoordinateInside(position) && this.positions.contains(position);
    }
}

