/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.area;

import aurocosh.divinefavor.common.area.IAreaWatcher;
import aurocosh.divinefavor.common.area.WatcherToDelete;
import aurocosh.divinefavor.common.area.WorldArea;
import aurocosh.divinefavor.common.area.WorldAreaWatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="divinefavor")
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0007R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Laurocosh/divinefavor/common/area/WorldAreaWatcher;", "", "()V", "watchers", "Ljava/util/HashMap;", "Lnet/minecraft/world/World;", "", "Laurocosh/divinefavor/common/area/IAreaWatcher;", "watchersToDelete", "Ljava/util/ArrayList;", "Laurocosh/divinefavor/common/area/WatcherToDelete;", "cleanup", "", "onBlockChanged", "event", "Lnet/minecraftforge/event/world/BlockEvent;", "registerWatcher", "watcher", "unRegisterController", "divinefavor"})
public final class WorldAreaWatcher {
    private static final ArrayList<WatcherToDelete> watchersToDelete;
    private static final HashMap<World, Set<IAreaWatcher>> watchers;
    public static final WorldAreaWatcher INSTANCE;

    public final void registerWatcher(@NotNull IAreaWatcher watcher) {
        Intrinsics.checkParameterIsNotNull((Object)watcher, (String)"watcher");
        Set<IAreaWatcher> set = watchers.computeIfAbsent(watcher.getAreaWorld(), registerWatcher.controllerSet.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"watchers.computeIfAbsent\u2026reaWorld()) { HashSet() }");
        Set<IAreaWatcher> controllerSet2 = set;
        controllerSet2.add(watcher);
    }

    public final void unRegisterController(@NotNull IAreaWatcher watcher) {
        Intrinsics.checkParameterIsNotNull((Object)watcher, (String)"watcher");
        watchersToDelete.add(new WatcherToDelete(watcher.getAreaWorld(), watcher));
    }

    private final void cleanup() {
        for (WatcherToDelete watcher : watchersToDelete) {
            Set<IAreaWatcher> controllerSet2;
            Set<IAreaWatcher> set = controllerSet2 = watchers.get(watcher.getWorld());
            if (set == null) continue;
            set.remove(watcher.getWatcher());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public final void onBlockChanged(@NotNull BlockEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.cleanup();
        Set<IAreaWatcher> set = watchers.get(event.getWorld());
        if (set == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(set, (String)"watchers[event.world] ?: return");
        Set<IAreaWatcher> controllerSet2 = set;
        BlockPos position = event.getPos();
        for (IAreaWatcher areaWatcher : controllerSet2) {
            WorldArea worldArea = areaWatcher.getArea();
            BlockPos blockPos2 = position;
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos2, (String)"position");
            if (!worldArea.isApartOfArea(blockPos2)) continue;
            World world = event.getWorld();
            Intrinsics.checkExpressionValueIsNotNull((Object)world, (String)"event.world");
            BlockPos blockPos3 = event.getPos();
            Intrinsics.checkExpressionValueIsNotNull((Object)blockPos3, (String)"event.pos");
            IBlockState iBlockState = event.getState();
            Intrinsics.checkExpressionValueIsNotNull((Object)iBlockState, (String)"event.state");
            areaWatcher.blockChanged(world, blockPos3, iBlockState);
        }
    }

    private WorldAreaWatcher() {
    }

    static {
        WorldAreaWatcher worldAreaWatcher;
        INSTANCE = worldAreaWatcher = new WorldAreaWatcher();
        watchersToDelete = new ArrayList();
        watchers = new HashMap();
    }
}

