/*
 * Decompiled with CFR 0.152.
 */
package aurocosh.divinefavor.common.block_operations.do;

import aurocosh.divinefavor.common.block_operations.do.BuildOperation;
import aurocosh.divinefavor.common.block_operations.do.SimpleBuildOperation;
import aurocosh.divinefavor.common.block_operations.undo.UndoBuild;
import aurocosh.divinefavor.common.block_operations.undo.UndoOperation;
import aurocosh.divinefavor.common.lib.extensions.IterableExtensionsKt;
import aurocosh.divinefavor.common.tasks.BlockBuildingTask;
import aurocosh.divinefavor.common.tasks.base.BaseTask;
import aurocosh.divinefavor.common.util.UtilPlayer;
import aurocosh.divinefavor.common.util.UtilTick;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Laurocosh/divinefavor/common/block_operations/do/SimpleBuildOperation;", "Laurocosh/divinefavor/common/block_operations/do/BuildOperation;", "coordinates", "", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "(Ljava/util/List;Lnet/minecraft/block/state/IBlockState;)V", "getBuildingTask", "Lkotlin/Pair;", "Laurocosh/divinefavor/common/tasks/base/BaseTask;", "Laurocosh/divinefavor/common/block_operations/undo/UndoOperation;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "world", "Lnet/minecraft/world/World;", "divinefavor"})
public final class SimpleBuildOperation
extends BuildOperation {
    private final List<BlockPos> coordinates;
    private final IBlockState state;

    @Override
    @NotNull
    protected Pair<BaseTask, UndoOperation> getBuildingTask(@NotNull EntityPlayer player, @NotNull World world) {
        Intrinsics.checkParameterIsNotNull((Object)player, (String)"player");
        Intrinsics.checkParameterIsNotNull((Object)world, (String)"world");
        Collection collection = this.coordinates;
        int toConsume = collection.size();
        int blocksConsumed = UtilPlayer.INSTANCE.consumeBlocks(player, world, this.state, toConsume, false);
        int gooToConsume = toConsume - blocksConsumed;
        int gooConsumed = UtilPlayer.INSTANCE.consumeGoo(player, gooToConsume, false);
        Sequence realBlocks2 = SequencesKt.map(IterableExtensionsKt.getS((Iterable)this.coordinates.subList(0, blocksConsumed)), (Function1)getBuildingTask.realBlocks.1.INSTANCE);
        Sequence gooBlocks2 = SequencesKt.map(IterableExtensionsKt.getS((Iterable)this.coordinates.subList(blocksConsumed, blocksConsumed + gooConsumed)), (Function1)getBuildingTask.gooBlocks.1.INSTANCE);
        List buildData = CollectionsKt.shuffled((Iterable)SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)realBlocks2, (Sequence)gooBlocks2)));
        int buildTime = UtilTick.INSTANCE.secondsToTicks(2.0f);
        int blocksPerTick = buildTime > buildData.size() ? 1 : buildData.size() / buildTime;
        BlockBuildingTask blockPlacingTask = new BlockBuildingTask(buildData, this.state, player, blocksPerTick, false, 16, null);
        UndoBuild undoBuild = new UndoBuild(CollectionsKt.shuffled((Iterable)this.coordinates), this, blocksPerTick);
        return new Pair((Object)blockPlacingTask, (Object)undoBuild);
    }

    public SimpleBuildOperation(@NotNull List<? extends BlockPos> coordinates2, @NotNull IBlockState state2) {
        Intrinsics.checkParameterIsNotNull(coordinates2, (String)"coordinates");
        Intrinsics.checkParameterIsNotNull((Object)state2, (String)"state");
        this.coordinates = coordinates2;
        this.state = state2;
    }
}

